/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TailerListener;

public class Tailer
implements Runnable {
    private final File file;
    private final long delay;
    private final boolean end;
    private final TailerListener listener;
    private volatile boolean run = true;

    public Tailer(File file2, TailerListener listener) {
        this(file2, listener, 1000L);
    }

    public Tailer(File file2, TailerListener listener, long delay2) {
        this(file2, listener, 1000L, false);
    }

    public Tailer(File file2, TailerListener listener, long delay2, boolean end) {
        this.file = file2;
        this.delay = delay2;
        this.end = end;
        this.listener = listener;
        listener.init(this);
    }

    public static Tailer create(File file2, TailerListener listener, long delay2, boolean end) {
        Tailer tailer = new Tailer(file2, listener, delay2, end);
        Thread thread = new Thread(tailer);
        thread.setDaemon(true);
        thread.start();
        return tailer;
    }

    public static Tailer create(File file2, TailerListener listener, long delay2) {
        return Tailer.create(file2, listener, delay2, false);
    }

    public static Tailer create(File file2, TailerListener listener) {
        return Tailer.create(file2, listener, 1000L, false);
    }

    public File getFile() {
        return this.file;
    }

    public long getDelay() {
        return this.delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RandomAccessFile reader2 = null;
        try {
            long last2 = 0L;
            long position = 0L;
            while (this.run && reader2 == null) {
                try {
                    reader2 = new RandomAccessFile(this.file, "r");
                }
                catch (FileNotFoundException e2) {
                    this.listener.fileNotFound();
                }
                if (reader2 == null) {
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException e3) {}
                    continue;
                }
                position = this.end ? this.file.length() : 0L;
                last2 = System.currentTimeMillis();
                reader2.seek(position);
            }
            while (this.run) {
                long length = this.file.length();
                if (length < position) {
                    this.listener.fileRotated();
                    try {
                        RandomAccessFile save = reader2;
                        reader2 = new RandomAccessFile(this.file, "r");
                        position = 0L;
                        IOUtils.closeQuietly(save);
                    }
                    catch (FileNotFoundException e4) {
                        this.listener.fileNotFound();
                    }
                    continue;
                }
                if (length > position) {
                    last2 = System.currentTimeMillis();
                    position = this.readLines(reader2);
                } else if (FileUtils.isFileNewer(this.file, last2)) {
                    position = 0L;
                    reader2.seek(position);
                    last2 = System.currentTimeMillis();
                    position = this.readLines(reader2);
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e5) {}
            }
        }
        catch (Exception e6) {
            this.listener.handle(e6);
        }
        finally {
            IOUtils.closeQuietly(reader2);
        }
    }

    public void stop() {
        this.run = false;
    }

    private long readLines(RandomAccessFile reader2) throws IOException {
        long pos = reader2.getFilePointer();
        String line = this.readLine(reader2);
        while (line != null) {
            pos = reader2.getFilePointer();
            this.listener.handle(line);
            line = this.readLine(reader2);
        }
        reader2.seek(pos);
        return pos;
    }

    private String readLine(RandomAccessFile reader2) throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer();
        boolean seenCR = false;
        block4: while ((ch = reader2.read()) != -1) {
            switch (ch) {
                case 10: {
                    return sb.toString();
                }
                case 13: {
                    seenCR = true;
                    continue block4;
                }
            }
            if (seenCR) {
                sb.append('\r');
                seenCR = false;
            }
            sb.append((char)ch);
        }
        return null;
    }
}

