/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.util.Random;

public class RandomStringUtils {
    private static final Random RANDOM = new Random();

    public static String random(int count2) {
        return RandomStringUtils.random(count2, false, false);
    }

    public static String randomAscii(int count2) {
        return RandomStringUtils.random(count2, 32, 127, false, false);
    }

    public static String randomAlphabetic(int count2) {
        return RandomStringUtils.random(count2, true, false);
    }

    public static String randomAlphanumeric(int count2) {
        return RandomStringUtils.random(count2, true, true);
    }

    public static String randomNumeric(int count2) {
        return RandomStringUtils.random(count2, false, true);
    }

    public static String random(int count2, boolean letters, boolean numbers) {
        return RandomStringUtils.random(count2, 0, 0, letters, numbers);
    }

    public static String random(int count2, int start, int end, boolean letters, boolean numbers) {
        return RandomStringUtils.random(count2, start, end, letters, numbers, null, RANDOM);
    }

    public static String random(int count2, int start, int end, boolean letters, boolean numbers, char[] chars2) {
        return RandomStringUtils.random(count2, start, end, letters, numbers, chars2, RANDOM);
    }

    public static String random(int count2, int start, int end, boolean letters, boolean numbers, char[] chars2, Random random) {
        if (count2 == 0) {
            return "";
        }
        if (count2 < 0) {
            throw new IllegalArgumentException("Requested random string length " + count2 + " is less than 0.");
        }
        if (start == 0 && end == 0) {
            end = 123;
            start = 32;
            if (!letters && !numbers) {
                start = 0;
                end = Integer.MAX_VALUE;
            }
        }
        char[] buffer = new char[count2];
        int gap = end - start;
        while (count2-- != 0) {
            char ch = chars2 == null ? (char)(random.nextInt(gap) + start) : chars2[random.nextInt(gap) + start];
            if (letters && Character.isLetter(ch) || numbers && Character.isDigit(ch) || !letters && !numbers) {
                if (ch >= '\udc00' && ch <= '\udfff') {
                    if (count2 == 0) {
                        ++count2;
                        continue;
                    }
                    buffer[count2] = ch;
                    buffer[--count2] = (char)(55296 + random.nextInt(128));
                    continue;
                }
                if (ch >= '\ud800' && ch <= '\udb7f') {
                    if (count2 == 0) {
                        ++count2;
                        continue;
                    }
                    buffer[count2] = (char)(56320 + random.nextInt(128));
                    buffer[--count2] = ch;
                    continue;
                }
                if (ch >= '\udb80' && ch <= '\udbff') {
                    ++count2;
                    continue;
                }
                buffer[count2] = ch;
                continue;
            }
            ++count2;
        }
        return new String(buffer);
    }

    public static String random(int count2, String chars2) {
        if (chars2 == null) {
            return RandomStringUtils.random(count2, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(count2, chars2.toCharArray());
    }

    public static String random(int count2, char[] chars2) {
        if (chars2 == null) {
            return RandomStringUtils.random(count2, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(count2, 0, chars2.length, false, false, chars2, RANDOM);
    }
}

