/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.commons.lang.Entities;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.commons.lang.text.StrBuilder;

public class StringEscapeUtils {
    private static final char CSV_DELIMITER = ',';
    private static final char CSV_QUOTE = '\"';
    private static final String CSV_QUOTE_STR = String.valueOf('\"');
    private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

    public static String escapeJava(String str2) {
        return StringEscapeUtils.escapeJavaStyleString(str2, false, false);
    }

    public static void escapeJava(Writer out, String str2) throws IOException {
        StringEscapeUtils.escapeJavaStyleString(out, str2, false, false);
    }

    public static String escapeJavaScript(String str2) {
        return StringEscapeUtils.escapeJavaStyleString(str2, true, true);
    }

    public static void escapeJavaScript(Writer out, String str2) throws IOException {
        StringEscapeUtils.escapeJavaStyleString(out, str2, true, true);
    }

    private static String escapeJavaStyleString(String str2, boolean escapeSingleQuotes, boolean escapeForwardSlash) {
        if (str2 == null) {
            return null;
        }
        try {
            StringWriter writer2 = new StringWriter(str2.length() * 2);
            StringEscapeUtils.escapeJavaStyleString(writer2, str2, escapeSingleQuotes, escapeForwardSlash);
            return writer2.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    private static void escapeJavaStyleString(Writer out, String str2, boolean escapeSingleQuote, boolean escapeForwardSlash) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str2 == null) {
            return;
        }
        int sz = str2.length();
        block13: for (int i = 0; i < sz; ++i) {
            char ch = str2.charAt(i);
            if (ch > '\u0fff') {
                out.write("\\u" + StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.write("\\u0" + StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.write("\\u00" + StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92);
                        out.write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92);
                        out.write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + StringEscapeUtils.hex(ch));
                            break;
                        }
                        out.write("\\u000" + StringEscapeUtils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        out.write(92);
                    }
                    out.write(39);
                    continue block13;
                }
                case '\"': {
                    out.write(92);
                    out.write(34);
                    continue block13;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block13;
                }
                case '/': {
                    if (escapeForwardSlash) {
                        out.write(92);
                    }
                    out.write(47);
                    continue block13;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    public static String unescapeJava(String str2) {
        if (str2 == null) {
            return null;
        }
        try {
            StringWriter writer2 = new StringWriter(str2.length());
            StringEscapeUtils.unescapeJava(writer2, str2);
            return writer2.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    public static void unescapeJava(Writer out, String str2) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str2 == null) {
            return;
        }
        int sz = str2.length();
        StrBuilder unicode = new StrBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str2.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.write((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new NestableRuntimeException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        out.write(92);
                        break;
                    }
                    case '\'': {
                        out.write(39);
                        break;
                    }
                    case '\"': {
                        out.write(34);
                        break;
                    }
                    case 'r': {
                        out.write(13);
                        break;
                    }
                    case 'f': {
                        out.write(12);
                        break;
                    }
                    case 't': {
                        out.write(9);
                        break;
                    }
                    case 'n': {
                        out.write(10);
                        break;
                    }
                    case 'b': {
                        out.write(8);
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        out.write(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.write(ch);
        }
        if (hadSlash) {
            out.write(92);
        }
    }

    public static String unescapeJavaScript(String str2) {
        return StringEscapeUtils.unescapeJava(str2);
    }

    public static void unescapeJavaScript(Writer out, String str2) throws IOException {
        StringEscapeUtils.unescapeJava(out, str2);
    }

    public static String escapeHtml(String str2) {
        if (str2 == null) {
            return null;
        }
        try {
            StringWriter writer2 = new StringWriter((int)((double)str2.length() * 1.5));
            StringEscapeUtils.escapeHtml(writer2, str2);
            return writer2.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    public static void escapeHtml(Writer writer2, String string2) throws IOException {
        if (writer2 == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string2 == null) {
            return;
        }
        Entities.HTML40.escape(writer2, string2);
    }

    public static String unescapeHtml(String str2) {
        if (str2 == null) {
            return null;
        }
        try {
            StringWriter writer2 = new StringWriter((int)((double)str2.length() * 1.5));
            StringEscapeUtils.unescapeHtml(writer2, str2);
            return writer2.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    public static void unescapeHtml(Writer writer2, String string2) throws IOException {
        if (writer2 == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string2 == null) {
            return;
        }
        Entities.HTML40.unescape(writer2, string2);
    }

    public static void escapeXml(Writer writer2, String str2) throws IOException {
        if (writer2 == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (str2 == null) {
            return;
        }
        Entities.XML.escape(writer2, str2);
    }

    public static String escapeXml(String str2) {
        if (str2 == null) {
            return null;
        }
        return Entities.XML.escape(str2);
    }

    public static void unescapeXml(Writer writer2, String str2) throws IOException {
        if (writer2 == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (str2 == null) {
            return;
        }
        Entities.XML.unescape(writer2, str2);
    }

    public static String unescapeXml(String str2) {
        if (str2 == null) {
            return null;
        }
        return Entities.XML.unescape(str2);
    }

    public static String escapeSql(String str2) {
        if (str2 == null) {
            return null;
        }
        return StringUtils.replace(str2, "'", "''");
    }

    public static String escapeCsv(String str2) {
        if (StringUtils.containsNone(str2, CSV_SEARCH_CHARS)) {
            return str2;
        }
        try {
            StringWriter writer2 = new StringWriter();
            StringEscapeUtils.escapeCsv(writer2, str2);
            return writer2.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    public static void escapeCsv(Writer out, String str2) throws IOException {
        if (StringUtils.containsNone(str2, CSV_SEARCH_CHARS)) {
            if (str2 != null) {
                out.write(str2);
            }
            return;
        }
        out.write(34);
        for (int i = 0; i < str2.length(); ++i) {
            char c = str2.charAt(i);
            if (c == '\"') {
                out.write(34);
            }
            out.write(c);
        }
        out.write(34);
    }

    public static String unescapeCsv(String str2) {
        if (str2 == null) {
            return null;
        }
        try {
            StringWriter writer2 = new StringWriter();
            StringEscapeUtils.unescapeCsv(writer2, str2);
            return writer2.toString();
        }
        catch (IOException ioe) {
            throw new UnhandledException(ioe);
        }
    }

    public static void unescapeCsv(Writer out, String str2) throws IOException {
        if (str2 == null) {
            return;
        }
        if (str2.length() < 2) {
            out.write(str2);
            return;
        }
        if (str2.charAt(0) != '\"' || str2.charAt(str2.length() - 1) != '\"') {
            out.write(str2);
            return;
        }
        String quoteless = str2.substring(1, str2.length() - 1);
        if (StringUtils.containsAny(quoteless, CSV_SEARCH_CHARS)) {
            str2 = StringUtils.replace(quoteless, CSV_QUOTE_STR + CSV_QUOTE_STR, CSV_QUOTE_STR);
        }
        out.write(str2);
    }
}

