/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.entity.mime.content.AbstractContentBody;

public class ByteArrayBody
extends AbstractContentBody {
    private final byte[] data;
    private final String filename;

    public ByteArrayBody(byte[] data2, String mimeType, String filename) {
        super(mimeType);
        if (data2 == null) {
            throw new IllegalArgumentException("byte[] may not be null");
        }
        this.data = data2;
        this.filename = filename;
    }

    public ByteArrayBody(byte[] data2, String filename) {
        this(data2, "application/octet-stream", filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.data);
    }

    public String getCharset() {
        return null;
    }

    public String getTransferEncoding() {
        return "binary";
    }

    public long getContentLength() {
        return this.data.length;
    }
}

