# nedap-lib

An interactive Leiningen template for creating Clojure libraries.

Includes boilerplate/defaults related to our usage of Clojure/Script, GitHub, CircleCI and JFrog. 

* See `resources/leiningen/new/nedap_lib/*` for getting an accurate idea of each file's contents.
* See the `leiningen.new.nedap-lib` ns to learn about the values to be templated into each file.

## Usage

```
rm -rf ~/.m2/repository/nedap-lib; lein new nedap-lib foo
# the `rm` is necessary for ensuring that the latest version is fetched.
# still, keep in mind that releases can take up to 15m to propagate (Clojars works under a CDN)
# feel free to create a `new_lib` bash function which performs the rm.
```

Will generate a `nedap.foo.api` namespace, and a `com.nedap.staffing-solutions/foo` artifact (or something else, following the interactive procedure).

## Reapplying the template

You can update an existing project to use this template's latest defaults, by following the following steps:

* Create an identically named project from scratch
* `cd` into it
* `cp -r dev .gitignore project.clj .circleci .github LICENSE test ~/the-old-project`
* Selectively stage/discard git chunks, since valuable existing config (e.g. project-specific dependencies) may have been lost.

## Current version

<!-- This section exists to make com.nedap.staffing-solutions/ci.release-workflow happy -->

The project coordinates are `[nedap-lib/lein-template "1.8.0"]`.

However you don't need to use them directly; see [usage](https://github.com/nedap/lein-template/#usage). 

## License

Copyright © Nedap

This program and the accompanying materials are made available under the terms of the Eclipse Public License 2.0 which is available at http://www.eclipse.org/legal/epl-2.0.
