# nedap-lib

An interactive Leiningen template for creating Clojure projects, such as libraries, scripts and applications.

Includes boilerplate/defaults related to our usage of Clojure/Script, GitHub, CircleCI, JFrog/Clojars, etc. It also can be used without introducing Nedap-specific defaults. 

* See `resources/leiningen/new/nedap_lib/*` for getting an accurate idea of each file's contents.
* See the `leiningen.new.nedap-lib` ns to learn about the values to be templated into each file.

## [Rationale and scope](https://github.com/nedap/lein-template/blob/master/doc/rationale.md)

## Highlights

* The template itself is interactive, reapplicable
  * The first run will gather your choices, subsequent runs will reuse past choices. 
* Automated release pipeline
  * The emitted .github and .circleci files, along with the [ncrw](https://github.com/nedap/ci.release-workflow) integration create a cohesive solution for releasing new versions effortlessly and safely.
* Advanced defaults for safer, enjoyable programming
  * The emitted `dev.clj` features an advanced Reloaded workflow. 
  * The emitted Leiningen `project.clj` uses up to 6 different profiles, tuning different aspects.
* Emphasis on .cljc
  * Authoring .cljc libraries tends to be somewhat hard, in terms of having Leiningen, CI, etc build/test everything correctly for two compilation targets.
* Clean, optional [Pedestal](https://github.com/pedestal/pedestal) integration
  * Our emitted boilerplate (quite minimal), in addition to the [components.pedestal](https://github.com/nedap/components.pedestal) integration results in a clean Reloaded workflow, also featuring component injection.
    * (both of those are rarely found in typical Pedestal setups)

## Usage

```
rm -rf ~/.m2/repository/nedap-lib; lein new nedap-lib foo
# the `rm` is necessary for ensuring that the latest version is fetched.
# still, keep in mind that new releases can take up to 15m to propagate (Clojars works under a CDN)
# feel free to create a `new_lib` bash function which performs the rm.
```

...Will generate a `nedap.foo.api` namespace, and a `com.nedap.staffing-solutions/foo` artifact (or something else, following the interactive procedure):

```
$ lein new nedap-lib myproject
Github user/organisation that will own the repo:
(default: nedap)
bigco

Copyright holder (example: My Company):
Big Co Inc.

Maven group id (example: com.mycompany):
com.bigco

Clojure namespace prefix:
(default: com.bigco.myproject)


Email for GPG-signing releases:
big@co.inc

Setup lein-nvd?
(respond with 'yes' or 'no')
n

Also setup ClojureScript?
(respond with 'yes' or 'no')
n

Setup a Pedestal web application?
(respond with 'yes' or 'no')
y

Add `assets` and `layout` and  components to the Pedestal app? (These are not needed in API only projects)
(respond with 'yes' or 'no')
y

Deploy to Clojars?
(respond with 'yes' or 'no')
n

Publicly license?
(respond with 'yes' or 'no')
n
```

Note that the created project will be slightly misformatted; please run `format-and-lint-project!` and sort `project.clj` dependencies a-z before performing the first git commit.

## Reapplying the template

You can update an existing project to use this template's latest defaults, by following the following steps:

* `lein new nedap-lib $(basename $PWD) --to-dir . --force`
* Selectively stage/discard git chunks, since valuable existing config (e.g. project-specific dependencies) may have been lost.
  * [Tower](https://www.git-tower.com/mac) is notably good at this.

#### Automated reapplication

This template is designed for being able to be continuously reapplied, in an automated manner (i.e. requiring no user input).

With that in mind, after each template application, all choices are dumped to a file called `nedap.lein-template.properties` at the root of your project.

Subsequent applications will use that file, for infering choices.

If in a future a new option is introduced, the first time you reapply the template your choice will be added to the `.properties` file, automating subsequent applications.

> Don't blindly commit the changes that a given reapplication gives. They may be wrong, or they may introduce aspects that are deliberately undesired in a given project. 

## Web capabilities

This template can emit Pedestal-based web applications (at least for the server side, for now).

The patterns it uses are derived from the archived [modular-playground](https://github.com/nedap/modular-playground/) project.

Unlike it, it doesn't offer example modules ("taxes", "payments"); they won't be offered again as they already served their purpose.

You can still consult them in the [sample-modules](https://github.com/nedap/modular-playground.sample-modules) repo.

As for the design choices in Pedestal usage, they are explained in our [guidelines](https://github.com/nedap/clojure-guidelines), and in [utils.modular](https://github.com/nedap/utils.modular).

## Current version

<!-- This section exists to make com.nedap.staffing-solutions/ci.release-workflow happy -->

The project coordinates are `[nedap-lib/lein-template "2.0.0-alpha7"]`.

However you don't need to use them directly; see [usage](https://github.com/nedap/lein-template/#usage). 

## License

Copyright © Nedap

This program and the accompanying materials are made available under the terms of the Eclipse Public License 2.0 which is available at http://www.eclipse.org/legal/epl-2.0.
