(ns {{prefix}}.router.component
  (:require
   [com.stuartsierra.component :as component]
   [io.pedestal.http :as http]
   [io.pedestal.http.body-params :as body-params]
   [io.pedestal.http.route :as route]
   [{{prefix}}.environment.kws :as environment]
   [{{prefix}}.router.kws :as router]
   [nedap.components.pedestal.router.kws :as components.pedestal.router]
   [nedap.speced.def :as speced]
   [nedap.utils.modular.api :refer [implement]]
   [ring.util.response :refer [response]]))

(def home-page
  [(fn [request]
     (response "Hello World!"))])

(defn common-interceptors [component-interceptors]
  (into component-interceptors [(body-params/body-params) http/html-body]))

(defn routes [component-interceptors environment]
  (let [base                (common-interceptors component-interceptors)
        home-page           (into base home-page)]
    #{["/" :get home-page :route-name ::router/home-page]}))

(speced/defn ^::components.pedestal.router/component start
  [{^::environment/component env ::environment/component
    ::keys                       [^vector? component-interceptors]
    :as                          ^::components.pedestal.router/component this}]
  (assoc this ::components.pedestal.router/routes (routes component-interceptors env)))

(defn stop [this]
  {})

(defn new [component-interceptors]
  (implement {::component-interceptors component-interceptors}
    component/start start
    component/stop  stop))
