(defproject nedap-lib/lein-template "2.7.3"
  :description "A Leiningen template for Clojure projects."

  :min-lein-version "2.0.0"

  :license {:name "EPL-2.0"
            :url  "https://www.eclipse.org/legal/epl-2.0/"}

  :signing {:gpg-key "releases-staffingsolutions@nedap.com"}

  :repositories {"releases" {:url      "https://nedap.jfrog.io/nedap/staffing-solutions/"
                             :username :env/artifactory_user
                             :password :env/artifactory_pass}}

  :deploy-repositories {"clojars" {:url      "https://clojars.org/repo"
                                   :username :env/clojars_user
                                   :password :env/clojars_pass}}

  :repository-auth {#"https://nedap.jfrog\.io/nedap/staffing-solutions/"
                    {:username :env/artifactory_user
                     :password :env/artifactory_pass}}

  :dependencies [[org.clojure/clojure "1.10.1"]]

  :url "https://github.com/nedap/lein-template"

  ;; Allows running ci.release-workflow regardless of Lein version (Lein may use Clojure < 1.10, assumed by that dep)
  :eval-in-leiningen ~(not (System/getenv "running_ci_release_workflow"))

  :profiles {:ncrw {:global-vars  {*assert* true} ;; `ci.release-workflow` relies on runtime assertions
                    :source-paths   ^:replace []
                    :test-paths     ^:replace []
                    :resource-paths ^:replace []
                    :plugins        ^:replace []
                    :dependencies   ^:replace [[com.nedap.staffing-solutions/ci.release-workflow "1.12.0"]]}
             :ci   {:pedantic?    :abort
                    :jvm-opts     ["-Dclojure.main.report=stderr"]}})
