(ns {{prefix}}.util.log
  (:require
   [clojure.string :as string]
   [nedap.speced.def :as speced]
   [taoensso.timbre :as log]
   [taoensso.timbre.tools.logging :as tools.logging]))

(defn logger-output-fn
  "Define the output format of a log line"
  ([data]
   (logger-output-fn nil data))

  ([opts data]
   (let [{:keys [no-stacktrace? _stacktrace-fonts]} opts
         {:keys [level msg_ ?err ?ns-str ?file
                 timestamp_ ?line]} data]
     (format "%s [%s] %-5s [%s:%s] - %s%s"
             (force timestamp_)
             (.getName (Thread/currentThread))
             (string/upper-case (name level))
             (or ?ns-str ?file "?")
             (or ?line "?")
             (force msg_)
             (if (and (not no-stacktrace?)
                      ?err)
               (str "\n" (log/stacktrace ?err opts))
               "")))))

(speced/defn initialize-logger! []
  (tools.logging/use-timbre)
  (log/merge-config! {:output-fn logger-output-fn
                      :timestamp-opts {:pattern "yyyy-MM-dd HH:mm:ss.SSSZ"}}))

(initialize-logger!)
