;; Please don't bump the library version by hand - use ci.release-workflow instead.
(defproject {{group-id}}/{{raw-name}} "{{initial-release}}"
  ;; Please keep the dependencies sorted a-z.
  :dependencies [[org.clojure/clojure "1.10.3"]
                 [com.nedap.staffing-solutions/speced.def "2.0.0"]
                 {{#system?}}
                 [com.nedap.staffing-solutions/timbre-greylist "0.2.0"]
                 [com.fzakaria/slf4j-timbre "0.3.21"]
                 [com.stuartsierra/component "1.0.0"]
                 [com.taoensso/timbre "4.10.0"]
                 [org.slf4j/jcl-over-slf4j "1.7.30"]
                 [org.slf4j/jul-to-slf4j "1.7.30"]
                 [org.slf4j/log4j-over-slf4j "1.7.30"]
                 {{/system?}}
                 {{#web?}}
                 [aero "1.1.6"]
                 [cheshire "5.10.0"]
                 [com.nedap.staffing-solutions/components.pedestal "2.0.0"]
                 {{#nedap?}}
                 [com.nedap.staffing-solutions/components.uncaught-exception-handler "3.0.0"]
                 [com.nedap.staffing-solutions/pep-rollbar-clj "2.1.1"]
                 {{/nedap?}}
                 [com.nedap.staffing-solutions/utils.modular "2.2.0-alpha4"]
                 {{#ssr?}}
                 [com.nedap.staffing-solutions/components.assets "3.0.0"]
                 [hiccup "1.0.5"]
                 {{/ssr?}}
                 [ring/ring-core "1.8.0"]
                 {{/web?}}]

  :managed-dependencies [[org.clojure/core.incubator "0.1.4"]
                         [org.clojure/tools.logging "0.4.1"]
                         [org.clojure/tools.reader "1.3.2"]
                         [com.cognitect/transit-clj "0.8.313"]
                         [com.nedap.staffing-solutions/utils.spec "1.2.0"]]

{{^clojurescript?}}
  :exclusions [org.clojure/clojurescript]

{{/clojurescript?}}
  :description "{{raw-name}}"

  :url "https://github.com/{{github-username}}/{{raw-name}}"

  :min-lein-version "2.0.0"
{{#license?}}

  :license {:name "EPL-2.0"
            :url  "https://www.eclipse.org/legal/epl-2.0/"}
{{/license?}}
{{^monorepo-subproject?}}

  :signing {:gpg-key "{{gpg-key}}"}
{{/monorepo-subproject?}}
{{#nedap?}}  :repositories {"releases" {:url      "https://nedap.jfrog.io/nedap/staffing-solutions/"
                                        {{#monorepo-subproject?}}
                                         :sign-releases false
                                        {{/monorepo-subproject?}}
                             :username :env/artifactory_user
                             :password :env/artifactory_pass}}

  :repository-auth {#"https://nedap.jfrog\.io/nedap/staffing-solutions/"
                    {:username :env/artifactory_user
                     :password :env/artifactory_pass}}
{{/nedap?}}
{{#clojars?}}

  :deploy-repositories {"clojars" {:url      "https://clojars.org/repo"
                                   :username :env/clojars_user
                                   :password :env/clojars_pass}}
{{/clojars?}}
  :target-path "target/%s"
{{#web?}}

  :source-paths ["src"{{{web-source-paths}}}]

{{/web?}}

  :test-paths ["src" "test"{{{web-source-paths}}}]
{{#system?}}

  ;; Note that the following options aren't passed to production servers (unless using Leiningen there):
  :jvm-opts ["-XX:-OmitStackTraceInFastThrow" ;; increase stacktrace usefulness
             "-server" ;; JCIP recommends exercising server optimizations in all envs.
             ;; The following flags setup GC with short STW pauses, which tend to be apt for webserver workloads.
             ;; Taken from https://docs.oracle.com/cd/E40972_01/doc.70/e40973/cnf_jvmgc.htm#autoId2
             ;; Note that -Xmx and -Xms are unset, since developers can have different needs around that.
             "-XX:+UseG1GC"
             "-XX:MaxGCPauseMillis=200"
             "-XX:ParallelGCThreads=20"
             "-XX:ConcGCThreads=5"
             "-XX:InitiatingHeapOccupancyPercent=70"]

{{/system?}}

  :monkeypatch-clojure-test false
{{#ssr?}}

  :aliases {"compile-assets" ["run" "-m" "{{prefix}}.stylesheet"]}

{{/ssr?}}

  :plugins [{{#clojurescript?}}[lein-cljsbuild "1.1.7"]
            {{/clojurescript?}}[lein-pprint "1.1.2"]]

{{#clojurescript?}}  ;; Please don't add `:hooks [leiningen.cljsbuild]`. It can silently skip running the JS suite on `lein test`.
  ;; It also interferes with Cloverage.
  :cljsbuild {:builds {"test" {:source-paths ["src" "test"{{{web-source-paths}}}]
                               :compiler     {:main          {{prefix}}.test-runner
                                              :output-to     "target/out/tests.js"
                                              :output-dir    "target/out"
                                              :target        :nodejs
                                              :optimizations :none}}}}

{{/clojurescript?}}
  ;; A variety of common dependencies are bundled with `nedap/lein-template`.
  ;; They are divided into two categories:
  ;; * Dependencies that are possible or likely to be needed in all kind of production projects
  ;;   * The point is that when you realise you needed them, they are already in your classpath, avoiding interrupting your flow
  ;;   * After realising this, please move the dependency up to the top level.
  ;; * Genuinely dev-only dependencies allowing 'basic science'
  ;;   * e.g. criterium, deep-diff, clj-java-decompiler

  :profiles {:dev      {:dependencies [[cider/cider-nrepl "0.25.8" #_"formatting-stack needs it"]
                                       [com.clojure-goes-fast/clj-java-decompiler "0.3.0"]
                                       {{#nedap?}}
                                       {{^web?}}
                                       [com.nedap.staffing-solutions/utils.modular "2.1.0"]
                                       {{/web?}}
                                       {{/nedap?}}
                                       [com.nedap.staffing-solutions/utils.spec.predicates "1.1.0"]
                                       {{^system?}}
                                       [com.stuartsierra/component "1.0.0"]
                                       {{/system?}}
                                       {{#system?}}
                                       [com.stuartsierra/component.repl "0.2.0"]
                                       {{/system?}}
                                       [com.taoensso/timbre "4.10.0"]
                                       [criterium "0.4.5"]
                                       [formatting-stack "4.2.3"]
                                       [lambdaisland/deep-diff "0.0-47"]
                                       [medley "1.3.0"]
                                       [org.clojure/core.async "1.0.567"]
                                       [org.clojure/math.combinatorics "0.1.6"]
                                       [org.clojure/test.check "1.0.0"]
                                       [org.clojure/tools.namespace "1.0.0"]
                                       [refactor-nrepl "2.5.0" #_"formatting-stack needs it"]]
                        :jvm-opts     ["-Dclojure.compiler.disable-locals-clearing=true"]
                        :plugins      [[lein-cloverage "1.2.1"]]
                        :source-paths ["dev"]
                        :repl-options {:init-ns dev}}
{{#clojurescript?}}

             :provided {:dependencies         [[org.clojure/clojurescript "1.10.773"]]
                        :managed-dependencies [[com.google.code.findbugs/jsr305 "3.0.2"]
                                               [com.google.javascript/closure-compiler "v20151216"]]}
{{/clojurescript?}}

             :check    {:global-vars  {*unchecked-math* :warn-on-boxed
                                       ;; avoid warnings that cannot affect production:
                                       *assert*         false}}

             ;; some settings recommended for production applications.
             ;; You may also add :test, but beware of doing that if using this profile while running tests in CI.
             ;; (since that would disable tests altogether)
             :production {:jvm-opts ["-Dclojure.compiler.elide-meta=[:doc :file :author :line :column :added :deprecated :nedap.speced.def/spec :nedap.speced.def/nilable]"
                                     "-Dclojure.compiler.direct-linking=true"]
                          :global-vars {*assert* false}}

             ;; this profile is necessary since JDK >= 11 removes XML Bind, used by Jackson, which is a very common dep.
             :jdk11      {:dependencies [[javax.xml.bind/jaxb-api "2.3.1"]
                                         [org.glassfish.jaxb/jaxb-runtime "2.3.1"]]}

             :test     {:dependencies [[com.nedap.staffing-solutions/utils.test "1.6.2"]]
                        :jvm-opts     ["-Dclojure.core.async.go-checking=true"
                                       "-Duser.language=en-US"]}
{{#nvd?}}

             :nvd      {:plugins      [[lein-nvd "1.4.1"]]
                        :nvd          {:suppression-file "nvd_suppressions.xml"}}
{{/nvd?}}


             :ncrw       {:global-vars    {*assert* true} ;; `ci.release-workflow` relies on runtime assertions
                          :source-paths   ^:replace []
                          :test-paths     ^:replace []
                          :resource-paths ^:replace []
                          :plugins        ^:replace []
                          :dependencies   ^:replace [[com.nedap.staffing-solutions/ci.release-workflow "1.12.0"]]}

             :ci       {:pedantic?    :abort
                        :jvm-opts     ["-Dclojure.main.report=stderr"]}

{{#monorepo-subproject?}}
             :monorepo   { ;; use sibling modules' source paths, for an integrated Reloaded workflow
                          :source-paths ~(->> ".."
                                              clojure.java.io/file
                                              .listFiles
                                              (filter (fn [x]
                                                        (and (-> x .isDirectory)
                                                             (-> x (clojure.java.io/file "project.clj") .exists)
                                                             (not= (-> "project.clj" clojure.java.io/file .getParent)
                                                                   (-> x .getCanonicalPath)))))
                                              (mapv (fn [x]
                                                      (-> x (clojure.java.io/file "src") str))))

                          :test-paths ~(->> ".."
                                         clojure.java.io/file
                                         .listFiles
                                         (filter (fn [x]
                                                   (and (-> x .isDirectory)
                                                        (-> x (clojure.java.io/file "project.clj") .exists)
                                                        (not= (-> "project.clj" clojure.java.io/file .getParent)
                                                              (-> x .getCanonicalPath)))))
                                         (mapv (fn [x]
                                                 (-> x (clojure.java.io/file "test") str))))

                          ;; don't depend on modules as .jars, since that would create a resource ambiguity
                          :exclusions   ~(->> ".."
                                              clojure.java.io/file
                                              .listFiles
                                              (filter (fn [x]
                                                        (and (-> x .isDirectory)
                                                             (-> x (clojure.java.io/file "project.clj") .exists))))
                                              (mapv (fn [x]
                                                      (let [s (-> x (clojure.java.io/file "project.clj") slurp)
                                                            wrapped (str "[" s "]")]
                                                        (->> wrapped
                                                             read-string
                                                             (filter (fn [x]
                                                                       (and (sequential? x)
                                                                            (-> x first #{'defproject}))))
                                                             first
                                                             second)))))

                          ;; use sibling modules' dependencies, since :exclusions can also exclude important transitive dependencies
                          :dependencies ~(let [parse-deps (fn [file]
                                                            (let [s (-> file (clojure.java.io/file "project.clj") slurp)
                                                                  wrapped (str "[" s "]")]
                                                              (->> wrapped
                                                                   read-string
                                                                   (filter (fn [x]
                                                                             (and (sequential? x)
                                                                                  (-> x first #{'defproject}))))
                                                                   first
                                                                   (drop 3)
                                                                   (partition 2)
                                                                   (mapv vec)
                                                                   (into {})
                                                                   :dependencies)))
                                               deps-of-this-project (->> "." clojure.java.io/file parse-deps (mapv first) set)
                                               deps-of-other-projects (->> ".."
                                                                           clojure.java.io/file
                                                                           .listFiles
                                                                           (filter (fn [x]
                                                                                     (and (-> x .isDirectory)
                                                                                          (-> x (clojure.java.io/file "project.clj") .exists)
                                                                                          (not= (-> "project.clj" clojure.java.io/file .getParent)
                                                                                                (-> x .getCanonicalPath)))))
                                                                           (mapv parse-deps))]
                                          (if-not (seq deps-of-other-projects)
                                            ;; handle older Lein versions, which lack a 0-arg arity for `into`:
                                            []
                                            (->> deps-of-other-projects
                                                 (reduce into)
                                                 (remove (fn [[dep version]]
                                                           ;; given a duplicate dep, prefer this project's version:
                                                           (deps-of-this-project dep)))
                                                 (vec))))

                           :middleware [~(do
                                           ;; the following ensures that :exclusions are honored in all cases
                                           (create-ns 'user)
                                           (intern 'user
                                                   'nedap-ensure-exclusions
                                                   (fn [project]
                                                     (let [exclusions (->> project
                                                                           :exclusions
                                                                           (map (fn [x]
                                                                                  (str (if (namespace (symbol x))
                                                                                         x
                                                                                         (symbol (str x) (str x))))))
                                                                           (set))]
                                                       (update project :dependencies (fn [deps]
                                                                                       (->> deps
                                                                                            (remove (fn [[dep version]]
                                                                                                      (exclusions (str dep))))
                                                                                            vec))))))
                                           'user/nedap-ensure-exclusions)]}
{{/monorepo-subproject?}}
})
