(ns {{prefix}}.config.component
  (:require
   [aero.core :as aero]
   [clojure.java.io :as io]
   [com.stuartsierra.component :as component]
   [{{prefix}}.config.getters]
   [{{prefix}}.config.kws :as config]
   [{{prefix}}.config.getters :as config.getters]
   [{{prefix}}.environment.kws :as environment]
   [nedap.speced.def :as speced]
   [nedap.utils.modular.api :refer [implement]]))

(speced/defn ^map? start [{^::environment/component env ::environment/component
                           :as                          ^::config/component this}]
  (let [config-value (-> (io/resource "config.edn")
                         (aero/read-config {:profile env}))]
    (-> this
        (assoc ::config/value config-value)
        (config.getters/setup!))))

(defn stop [_]
  {})

(defn new []
  (implement {}
    component/start start
    component/stop  stop))
