(ns {{prefix}}.logging.component
  (:require
   [clojure.string :as string]
   [com.stuartsierra.component :as component]
   [{{prefix}}.config.kws :as config]
   [{{prefix}}.config.protocols.config :as protocols.config]
   [nedap.speced.def :as speced]
   [nedap.timbre-greylist.api :as timbre-greylist]
   [nedap.utils.modular.api :refer [implement]]
   [taoensso.timbre :as log]
   [taoensso.timbre.appenders.core :refer [println-appender]]
   [taoensso.timbre.tools.logging :as tools.logging]))

(defn logger-output-fn
  "Define the output format of a log line"
  ([data]
   (logger-output-fn nil data))

  ([opts data]
   (let [{:keys [no-stacktrace? _stacktrace-fonts]} opts
         {:keys [level msg_ ?err ?ns-str ?file
                 timestamp_ ?line]} data]
     (format "%s %-5s [%s] [%s:%s] - %s%s"
       (force timestamp_)
       (string/upper-case (name level))
       (.getName (Thread/currentThread))
       (or ?ns-str ?file "?")
       (or ?line "?")
       (force msg_)
       (if (and (not no-stacktrace?)
             ?err)
         (str "\n" (log/stacktrace ?err opts))
         "")))))

(speced/defn start [{^::config/component config ::config/component :as this}]
  (tools.logging/use-timbre)
  (log/set-config! {:output-fn      logger-output-fn
                    :appenders      {:println (println-appender {:stream :auto})}
                    :middleware     [timbre-greylist/greylist-middleware]
                    :timestamp-opts {:pattern "yyyy-MM-dd HH:mm:ss.SSSZ"
                                     :locale :jvm-default
                                     :timezone :utc}})
  (log/merge-config! (protocols.config/log-config config))
  this)

(defn stop [_]
  {})

(defn new []
  (implement {}
    component/start start
    component/stop stop))
