(ns leiningen.new.nemesis
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "nemesis"))

(defn nemesis
  "Creates new Nemesis App"
  [name]

  (let [data {:name name
              :sanitized (name-to-path name)}
        render #((renderer "nemesis") % data)]
    (println "Generating new nemesis project named" (str name "..."))
    (->files data
             [".gitignore"  (render "gitignore")]
             ["project.clj" (render "project.clj")]
             ["src/{{sanitized}}/main.clj"      (render "main.clj")]
             ["src/{{sanitized}}/router.clj"       (render "router.clj")]
             ["src/{{sanitized}}/services/service.clj" (render "service.clj")]
             ["src/{{sanitized}}/handlers/handler.clj" (render "handler.clj")]
             ["src/{{sanitized}}/storage/mongo.clj" (render "mongo.clj")])))
