(ns {{name}}.storage.mongo
    (:require [monger.core :as mg]
              [monger.collection :as mc]))
(def dbname "{{name}}")

(defn connect
  "will connect your app with your mongo database,you don't need to use this function."
  []
  (mg/get-db (mg/connect {:host "localhost" :port 27017}) dbname))

(defn insert
  "will insert given document in given collection"
  [coll doc]
  (mc/insert-and-return (connect) coll doc))

(defn find
  "will find you document using your given query and return as a clojure map"
  [coll query]
  (mc/find-one-as-map (connect) coll query))

(defn find-all
  "will find all documents matching your given query and return as a vector of maps"
  [coll query]
  (mc/find-maps (connect) coll query))

(defn remove
  "will remove a document matching your given query"
  [coll query]
  (mc/remove (connect) coll query))

(defn insert-all
  "given a vector of maps will insert all maps in given vector"
  [coll docs]
  (for [doc docs]
    (future
      (insert [coll doc]))))

(defn exists?
  "check if given query exists in database "
  [coll query]
  (let [count (count (mc/find-maps (connect) coll query))]
    (if (not= count 0)
      true
      false)))
(defn count
  "count matching documents with your query"
  [coll query]
  (count (mc/find-maps (connect) coll query)))
