(ns {{name}}.storage.mongo 
    (:require [monger.core :as mg]
              [monger.collection :as mc]))
(def dbname "{{name}}")

(defn connect []
    (mg/get-db (mg/connect {:host "localhost" :port 27017}) dbname))

(defn insert [coll doc]
    (mc/insert-and-return (connect) coll doc))

(defn find [coll query]
    (mc/find-one-as-map (connect) coll query))
(defn find-all [coll query]
    (mc/find-maps (connect) coll query))

(defn remove [coll query]
  (mc/remove (connect) coll query))

;;(defn insert-all [coll docs])
;;(defn exists? [coll query])
;;(defn count [coll query])
