(ns {{name}}.main
  (:gen-class) 
  (:require [io.pedestal.http :as http]
            [io.pedestal.http :as server]
            [io.pedestal.http.route :as route]
            [{{name}}.router :as router]))



(def service {:env :prod
              ::http/routes routes
              ::http/resource-path "/public"
              ::http/type :jetty
              ;;::http/host "localhost"
              ::http/port 8080
              ::http/container-options {:h2c? true
                                        :h2? false
                                        ;:keystore "test/hp/keystore.jks"
                                        ;:key-password "password"
                                        ;:ssl-port 8443
                                        :ssl? false}})

(defonce runnable-service (server/create-server service))

(defn run-dev
  "The entry-point for 'lein run-dev'"
  [& args]
  (println "\nCreating your [DEV] Nemesis server...")
  (-> service
      (merge {:env :dev
              ::server/join? false

              ::server/routes #(route/expand-routes (deref #'router/routes))
              ::server/allowed-origins {:creds true :allowed-origins (constantly true)}
              ::server/secure-headers {:content-security-policy-settings {:object-src "none"}}})
      server/default-interceptors
      server/dev-interceptors
      server/create-server
      server/start))

(defn -main
  "The entry-point for 'lein run'"
  [& args]
  (println "\nCreating your %s server...")
  (server/start runnable-service))



