;  Copyright (C) 2020 Gabriel Ash
; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is made public as is, without any guarantee whatsoever.

  (ns antifessional.libmisc.string
    "String manipulation.
    
    ![](images/antifessional.libmisc.string.png)
    "
    (:require [clojure.string :as str]))

(defn in?
  "find item `x` in string `s`"
  [s x] 
  ((comp boolean str/index-of) s x
                             )) 


(defn swap-delim
  "splits the first string argument on the second and joins
  the result with the third "
  [s old-delim new-delim]
  (str/join new-delim
          (str/split s old-delim)))


(defn str->int 
  "platform independent string to int conversion"
[s]
  
  #?(:clj  (Integer/parseInt s)
     :cljs (js/parseInt s)))


#?(:cljs 
 (defn from-ints
   "accepts a sequence of ints and encodes an ASCII string"
   [ ns ] (apply str
                 (map
                  (fn [n] (js/String.fromCharCode n))
                  ns))))

#?(:cljs 
 (defn from-codes
   "accepts a sequence of charcode strings and encodes an ASCII string"
   [ cs ] (from-ints 
           (map js/parseInt cs))))

#?(:cljs 
 (defn as-chars 
   "accepts a string and returns a sequence of char codes"
   [ s ] (map 
          (fn [c] (.charCodeAt c)) 
          (clojure.string/split s ""))))


#?(:cljs (defn as-ints
           "accepts a string and returns a sequence of integers"
           [ s ] (map
                  str->int (as-chars s))))

