(ns antifessional.libmisc.io
  "filesystem operations
  
    ![](images/antifessional.libmisc.io.png)
  "
  (:require

   [clojure.java.io :as io]
   [clojure.edn :as edn]

   [antifessional.libmisc.core :refer :all]
   [antifessional.libmisc.ex :refer [throw-ex]]
 
   ))


(defn slurp-edn
  "Slurp edn from an io/reader source (filename or io/resource)."
  [source]
  (try
    (with-open [r (io/reader source)]
      (edn/read (java.io.PushbackReader. r)))

    (catch java.io.IOException e
      (throw-ex "Cannot open '%s': %s\n" source (.getMessage e) {:cause e}))
    (catch RuntimeException e
      (throw-ex
                    "Error parsing edn file '%s': %s\n" source (.getMessage e) {:cause e}))))


(defn zap-directory
  "Recursively delete a directory."
  [file-name]
  (let [file (io/file file-name)]
    (when (.isDirectory file)
      (doseq [file-in-dir (.listFiles file)]
        (zap-directory file-in-dir)))
    (io/delete-file file)))
