(ns antifessional.libmisc.np
"Data reader #np supresses output by returning nil instead of whatever it's argument function returns. 
   Useful in the REPL to avoid massive output, for example with datomic transactions.
   Example : `(#np dt/transact conn tx)`
   The result of the last usage is cached in *0, which is normally imported through core.
   
   ![](images/antifessional.libmisc.np.png)
   "
  ) 
  
(defonce *0 nil)

(defn np* [f]
  "Data reader #np supresses output by returning nil instead of whatever its argument function returns. 
   Useful in the REPL to avoid massive output, for example with datomic transactions.
   Example : `(#np dt/transact conn tx)`
   The result of the last usage is cached in *0, which is normally imported through core."
  `(fn [& args#]
     (let [v# (apply ~f args#)]
       (alter-var-root #'*0
                       (constantly v#)))
     nil))


 
