(ns kitashiro.dom
  (:require [goog.fx.dom :as fx-dom]))


(defn fadeout
  "fade out the selected node."
  [el msec]
  (-> (fx-dom/FadeOut. el msec)
      (.play)))


(defn fade-in
  "fade in the selected node."
  [el msec]
  (-> (fx-dom/FadeIn. el msec)
      (.play)))


(defn parse-html
  "parse the html string to HTMLDocument."
  [html-str]
  (-> (js/DOMParser.)
      (.parseFromString html-str "text/html")))

