(ns kitashiro.dom
  (:use-macros [purnam.core :only [def.n ! !>]])
  (:require [goog.fx.dom :as fx-dom]
            [clojure.string :as string]))


(defn fade-out
  "fade out the selected node."
  [el msec]
  (-> (fx-dom/FadeOut. el msec)
      (.play))
  el)


(defn fade-in
  "fade in the selected node."
  [el msec]
  (-> (fx-dom/FadeIn. el msec)
      (.play))
  el)


(defn emulate-parse-html
  "Emulate DOMParser for Safari. https://developer.mozilla.org/en-US/docs/Web/API/DOMParser"
  [html-str]
  (let [doc (!> js/document.implementation.createHTMLDocument "")] ;; https://bitbucket.org/apribase/kitashiro/issue/2/documentimplementationcreatehtmldocument
    (if (->> (string/lower-case html-str)
             (re-find #"<!doctype ([^>]*)>")
             (second))
      (! doc.documentElement.innerHTML html-str)
      (! doc.body.innerHTML html-str))
    doc))


(defn parse-html
  "parse the html string to HTMLDocument."
  [html-str]
  (if-let [result (-> (js/DOMParser.)
                      (.parseFromString html-str "text/html"))]
    result
    (emulate-parse-html html-str)))
