(ns kitashiro.saas.algolia
  (:require [cljs.core.async :as async :refer [chan close! put!]]
            ["algoliasearch" :as algoliasearch]))

;; http://lukevanderhart.com/2011/09/30/using-javascript-and-clojurescript.html


(defn normalize-error-response [default-response props]
  (-> default-response
      (merge props)
      (assoc :success false)))


(defn normalize-success-response [default-response props]
  (-> {}
      (merge props)
      (assoc :success :true)
      (assoc :body default-response)))


(defn get-index
  "Algorlia Search の API Key を使用して Index を取得する。"
  [{:keys [application-id search-only-api-key index]}]
  (-> (algoliasearch application-id search-only-api-key)
      (.initIndex index)))


(defn search
  "Algorlia Search API Key などの `settings` にしたがって `query` を検索する"
  [settings query]
  (let [index (get-index settings)
        c (chan)]
    (doto index
      (.search (clj->js query)
               (fn [err content]
                 (put! c (if err
                           (normalize-error-response   (js->clj err     :keywordize-keys true) {:query query})
                           (normalize-success-response (js->clj content :keywordize-keys true) {})))
                 (close! c))))
    c))



