(ns kitashiro.spa.ajax
  (:refer-clojure :exclude [get])
  (:require [cljs.core.async :as async :refer [chan put!]]
            [ajax.core :as ajax]))

;; cljs-http は query に {:accept "application/edn"} をセットすると
;; HTTP Headers に Accept を追加できる。
;; しかし送られてきた octetstream を EDN として処理する機能はないようだ。

;; cljs-ajax は query に {:response-format (ajax-edn/response-format-edn)} をセットすると
;; HTTP Headers に Accept を追加して、さらに octetstream を EDN として処理する。
;; 詳細情報も取れる cljs-http を使いたいところだが、上記の EDN の扱いのために cljs-ajax を使用する。


;; cljs-http のレスポンスは以下のようになるので、cljs-ajax でもなるべく合わせる。
;; {:status 200
;;  :success true
;;  :body ""
;;  :headers nil
;;  :trace-redirects nil
;;  :error-code :no-error
;;  :error-text nil}

(defn normalize-success-response
  [response]
  {:success true
   :body response})


(defn normalize-error-response
  " default response: https://github.com/JulianBirch/cljs-ajax#error-responses"
  [response]
  (merge {:success false}
         response))


(defn get [url & [query]]
  (let [ch (chan)]
    (ajax/GET url (merge query {:handler #(put! ch (normalize-success-response %))
                                :error-handler #(put! ch (normalize-error-response %))}))
    ch))
