(ns kitashiro.ajax
  (:require [ajax.core :as cljs-ajax]
            [cljs.core.async :as async :refer [chan close! put!]]))


(defn normalize-error-response [default-response props]
  (-> default-response
      (merge props)
      (assoc :status-code (:status default-response))
      (assoc :resp (get-in default-response [:response :resp]))
      (assoc :status :failed)))


(defn easy-ajax [method url & {:as opts}]
  (let [channel (chan)
        base-opts {:method method
                   :uri url
                   :handler #(put! channel {:resp % :status :success})
                   :error-handler #(put! channel (normalize-error-response % {:url url}))
                   :finally #(close! channel)}]
    (->> (merge base-opts opts)
         (cljs-ajax/easy-ajax-request url method))
    channel))

