(ns kitashiro.saas.flickr)


(defn change-size [url sqtmnzcbhk]
  ;; re-find で分解した url を let 束縛する
  (if-let [[url server-id id secret size format]
           (or (re-find #"https?://farm(?:\d+)\.staticflickr\.com/([^/]+)/([^_]+)_([^\._]+)().(jpg)$" url)
               (re-find #"https?://farm(?:\d+)\.staticflickr\.com/([^/]+)/([^_]+)_([^_]+)_([sqtmnzcbhk]).(jpg)" url)
               (re-find #"https?://live\.staticflickr\.com/([^/]+)/([^_]+)_([^_]+)_([sqtmnzcbhk]).(jpg)" url))]
    ;; 分解束縛した値からサムネイルURLを作成する
    ;; サーバー が Yahoo ではなくなったので、 farmID は live になった https://www.flickr.com/help/forum/en-us/72157704518593012/
    (if (= sqtmnzcbhk 500)
      (str "https://live.staticflickr.com/" server-id "/" id "_" secret ".jpg")
      (str "https://live.staticflickr.com/" server-id "/" id "_" secret "_" (name sqtmnzcbhk) ".jpg"))
    ;; Flickr 画像ではない場合は url をそのまま返す
    (do (js/console.log (str "failed to change flickr size: " url))
        url)))
