(ns kitashiro.mui
  (:require [reagent.core :as r]
            ["@material-ui/core/Button" :default Button]
            ["@material-ui/core/Input" :default Input]
            ["@material-ui/core/InputLabel" :default InputLabel]
            ["@material-ui/core/OutlinedInput" :default OutlinedInput]
            ["@material-ui/core/TextField" :default TextField]
            ["@material-ui/core/Select" :default Select]
            ["@material-ui/core/FormControl" :default FormControl]
            ["@material-ui/core/MenuItem" :default MenuItem]
            ["@material-ui/core/Snackbar" :default Snackbar]
            ["@material-ui/core/Grid" :default Grid]
            ["@material-ui/core/GridList" :default GridList]
            ["@material-ui/core/GridListTile" :default GridListTile]
            ["@material-ui/core/GridListTileBar" :default GridListTileBar]
            ["@material-ui/core/Tabs" :default Tabs]
            ["@material-ui/core/Tab" :default Tab]
            ["@material-ui/core/Typography" :default Typography]
            ["@material-ui/core/Box" :default Box]))

;; ! def Button => nil
;; ! def button => button component
;; ! (r/adapt-react-class Button) => Button
;; ! (r/adapt-react-class button) => nil
(def button (r/adapt-react-class Button))
(def input (r/adapt-react-class Input))
(def input-label (r/adapt-react-class InputLabel))
(def outlined-input (r/adapt-react-class OutlinedInput))
(def text-field (r/adapt-react-class TextField))
(def select (r/adapt-react-class Select))
(def form-control (r/adapt-react-class FormControl))
(def menu-item (r/adapt-react-class MenuItem))
(def snackbar (r/adapt-react-class Snackbar))
(def grid (r/adapt-react-class Grid))
(def grid-list (r/adapt-react-class GridList))
(def grid-list-tile (r/adapt-react-class GridListTile))
(def grid-list-tile-bar (r/adapt-react-class GridListTileBar))
(def tabs (r/adapt-react-class Tabs))
(def tab (r/adapt-react-class Tab))
(def typography (r/adapt-react-class Typography))
(def box (r/adapt-react-class Box))
