(ns net.dnolen.vecmath.core)

(def epsilon 1e-6)

(defprotocol VecMath
  (equal? [this other])
  (add [this] [this other])
  (sub [this other])
  (mul [this scalar])
  (div [this scalar])
  (dist [this other])
  (dist-squared [this other])
  (perp [this])
  (neg [this])
  (clean [this])
  (unit [this])
  (length [this])
  (length-squared [this])
  (cross [this other])
  (dot [this other]))