/*
 * Decompiled with CFR 0.152.
 */
package net.f5;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.f5.crypt.F5Random;
import net.f5.crypt.Permutation;
import net.f5.ortega.HuffmanDecode;

public class Extract {
    private static File f;
    private static byte[] carrier;
    private static int[] coeff;
    private static FileOutputStream fos;
    private static String embFileName;
    private static String password;
    private static byte[] deZigZag;

    public static void extract(InputStream fis, int flength, OutputStream fos, String password) throws IOException {
        int nBytesExtracted;
        int extractedFileLength;
        block16: {
            int extractedBit;
            carrier = new byte[flength];
            fis.read(carrier);
            HuffmanDecode hd = new HuffmanDecode(carrier);
            System.out.println("Huffman decoding starts");
            coeff = hd.decode();
            System.out.println("Permutation starts");
            F5Random random = new F5Random(password.getBytes());
            Permutation permutation = new Permutation(coeff.length, random);
            System.out.println(coeff.length + " indices shuffled");
            int extractedByte = 0;
            int availableExtractedBits = 0;
            extractedFileLength = 0;
            nBytesExtracted = 0;
            int shuffledIndex = 0;
            System.out.println("Extraction starts");
            int i = 0;
            while (availableExtractedBits < 32) {
                shuffledIndex = permutation.getShuffled(i);
                if (shuffledIndex % 64 != 0 && coeff[shuffledIndex = shuffledIndex - shuffledIndex % 64 + deZigZag[shuffledIndex % 64]] != 0) {
                    extractedBit = coeff[shuffledIndex] > 0 ? coeff[shuffledIndex] & 1 : 1 - (coeff[shuffledIndex] & 1);
                    extractedFileLength |= extractedBit << availableExtractedBits++;
                }
                ++i;
            }
            extractedFileLength ^= random.getNextByte();
            extractedFileLength ^= random.getNextByte() << 8;
            extractedFileLength ^= random.getNextByte() << 16;
            int k = (extractedFileLength ^= random.getNextByte() << 24) >> 24;
            int n = (1 << (k %= 32)) - 1;
            System.out.println("Length of embedded file: " + (extractedFileLength &= 0x7FFFFF) + " bytes");
            availableExtractedBits = 0;
            if (n > 0) {
                int startOfN = i;
                System.out.println("(1, " + n + ", " + k + ") code used");
                block1: while (true) {
                    int hash = 0;
                    int code = 1;
                    i = 0;
                    while (code <= n) {
                        if (startOfN + i < coeff.length) {
                            shuffledIndex = permutation.getShuffled(startOfN + i);
                            if (shuffledIndex % 64 != 0 && coeff[shuffledIndex = shuffledIndex - shuffledIndex % 64 + deZigZag[shuffledIndex % 64]] != 0) {
                                extractedBit = coeff[shuffledIndex] > 0 ? coeff[shuffledIndex] & 1 : 1 - (coeff[shuffledIndex] & 1);
                                if (extractedBit == 1) {
                                    hash ^= code;
                                }
                                ++code;
                            }
                            ++i;
                            continue;
                        }
                        break block16;
                    }
                    startOfN += i;
                    i = 0;
                    while (true) {
                        if (i >= k) continue block1;
                        extractedByte |= (hash >> i & 1) << availableExtractedBits++;
                        if (availableExtractedBits == 8) {
                            fos.write((byte)(extractedByte ^= random.getNextByte()));
                            extractedByte = 0;
                            availableExtractedBits = 0;
                            if (++nBytesExtracted == extractedFileLength) break block16;
                        }
                        ++i;
                    }
                    break;
                }
            }
            System.out.println("Default code used");
            while (i < coeff.length) {
                shuffledIndex = permutation.getShuffled(i);
                if (shuffledIndex % 64 != 0 && coeff[shuffledIndex = shuffledIndex - shuffledIndex % 64 + deZigZag[shuffledIndex % 64]] != 0) {
                    extractedBit = coeff[shuffledIndex] > 0 ? coeff[shuffledIndex] & 1 : 1 - (coeff[shuffledIndex] & 1);
                    extractedByte |= extractedBit << availableExtractedBits++;
                    if (availableExtractedBits == 8) {
                        fos.write((byte)(extractedByte ^= random.getNextByte()));
                        extractedByte = 0;
                        availableExtractedBits = 0;
                        if (++nBytesExtracted == extractedFileLength) break;
                    }
                }
                ++i;
            }
        }
        if (nBytesExtracted < extractedFileLength) {
            System.out.println("Incomplete file: only " + nBytesExtracted + " of " + extractedFileLength + " bytes extracted");
        }
    }

    public static void main(String[] args) {
        embFileName = "output.txt";
        password = "abc123";
        try {
            if (args.length < 1) {
                Extract.usage();
                return;
            }
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("-")) {
                    if (!args[i].toLowerCase().endsWith(".jpg")) {
                        Extract.usage();
                        return;
                    }
                    f = new File(args[i]);
                    continue;
                }
                if (args.length < i + 1) {
                    System.out.println("Missing parameter for switch " + args[i]);
                    Extract.usage();
                    return;
                }
                if (args[i].equals("-e")) {
                    embFileName = args[i + 1];
                } else if (args[i].equals("-p")) {
                    password = args[i + 1];
                } else {
                    System.out.println("Unknown switch " + args[i] + " ignored.");
                }
                ++i;
            }
            FileInputStream fis = new FileInputStream(f);
            fos = new FileOutputStream(new File(embFileName));
            Extract.extract(fis, (int)f.length(), fos, password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void usage() {
        System.out.println("java Extract [Options] \"image.jpg\"");
        System.out.println("Options:");
        System.out.println("\t-p password (default: abc123)");
        System.out.println("\t-e extractedFileName (default: output.txt)");
        System.out.println("\nAuthor: Andreas Westfeld, westfeld@inf.tu-dresden.de");
    }

    static {
        deZigZag = new byte[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    }
}

