/*
 * Decompiled with CFR 0.152.
 */
package net.ftod.zcube.zdd;

import java.util.Collection;
import java.util.Iterator;
import net.ftod.zcube.zdd.ZDDOperationCache;
import net.ftod.zcube.zdd.ZDDPredicateCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZDD {
    public static final ZDD BOT = new ZDD(0L, null, null, 1, 0L);
    public static final ZDD TOP = new ZDD(0L, null, null, 2, 1L);
    public final long x;
    public final ZDD b;
    public final ZDD t;
    public final int h;
    public final long s;

    private ZDD(long x, ZDD b, ZDD t, int h, long s) {
        this.x = x;
        this.b = b;
        this.t = t;
        this.h = h;
        this.s = s;
    }

    private ZDD(long x, ZDD b, ZDD t) {
        this(x, b, t, ZDD.hash(x, b, t), b.s + t.s);
    }

    private static int hash(long x, ZDD b, ZDD t) {
        int result = 1;
        result = 31 * result + Long.valueOf(x).hashCode();
        result = 31 * result + b.h;
        result = 31 * result + t.h;
        return result;
    }

    private static ZDD zdd(long x, ZDD b, ZDD t) {
        if (t == BOT) {
            return b;
        }
        return new ZDD(x, b, t);
    }

    public static ZDD singleton(long x) {
        return new ZDD(x, BOT, TOP);
    }

    public static ZDD set(long ... xs) {
        return ZDD.set(new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache(), xs);
    }

    public static boolean included(ZDD zdd1, ZDD zdd2) {
        return ZDD.included(new ZDDPredicateCache(), new ZDDPredicateCache(), zdd1, zdd2);
    }

    static boolean included(ZDDPredicateCache eq, ZDDPredicateCache in, ZDD zdd1, ZDD zdd2) {
        if (ZDD.equals(eq, zdd1, zdd2)) {
            return true;
        }
        if (zdd1 == BOT) {
            return true;
        }
        if (zdd1 == TOP) {
            return ZDD.topIncluded(zdd2);
        }
        if (zdd2 == BOT) {
            return false;
        }
        if (zdd2 == TOP) {
            return false;
        }
        Boolean cached = in.get(zdd1, zdd2);
        if (cached != null) {
            return cached;
        }
        long x1 = zdd1.x;
        long x2 = zdd2.x;
        boolean included = x1 < x2 ? false : (x1 > x2 ? ZDD.included(eq, in, zdd1, zdd2.b) : ZDD.included(eq, in, zdd1.b, zdd2.b) && ZDD.included(eq, in, zdd1.t, zdd2.t));
        in.put(zdd1, zdd2, included);
        return included;
    }

    private static boolean topIncluded(ZDD zdd) {
        if (zdd == BOT) {
            return false;
        }
        if (zdd == TOP) {
            return true;
        }
        return ZDD.topIncluded(zdd.b);
    }

    public static ZDD union(ZDD zdd1, ZDD zdd2) {
        return ZDD.union(new ZDDPredicateCache(), new ZDDOperationCache(), zdd1, zdd2);
    }

    public static ZDD union(ZDD ... zdds) {
        return ZDD.union(new ZDDPredicateCache(), new ZDDOperationCache(), zdds);
    }

    public static boolean equals(ZDD zdd1, ZDD zdd2) {
        return ZDD.equals(new ZDDPredicateCache(), zdd1, zdd2);
    }

    public static ZDD trees(String[][] ... a) {
        return ZDD.trees(new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache(), a);
    }

    static ZDD trees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, String[][] ... a) {
        int n = a.length;
        ZDD[] trees = new ZDD[n];
        int i = 0;
        while (i < n) {
            trees[i] = ZDD.trees(eq, cu, un, a[i]);
            ++i;
        }
        return ZDD.union(eq, un, trees);
    }

    public static ZDD trees(String[] ... a) {
        return ZDD.trees(new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache(), a);
    }

    static ZDD trees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, String[] ... a) {
        int n = a.length;
        ZDD[] trees = new ZDD[n];
        int i = 0;
        while (i < n) {
            trees[i] = ZDD.trees(eq, cu, un, a[i]);
            ++i;
        }
        return ZDD.crossUnion(eq, cu, un, trees);
    }

    public static ZDD trees(String ... a) {
        return ZDD.trees(new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache(), a);
    }

    static ZDD trees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, String ... a) {
        return ZDD.trees(eq, cu, un, 1L, 0, a);
    }

    private static ZDD trees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, long h, int i, String[] a) {
        if (i == a.length) {
            return TOP;
        }
        long h1 = ZDD.djb2(h, a[i]);
        return ZDD.union(eq, un, TOP, ZDD.crossUnion(eq, cu, un, ZDD.singleton(h1), ZDD.trees(eq, cu, un, h1, i + 1, a)));
    }

    public static ZDD trees(Collection<Collection<Collection<String>>> i3) {
        ZDDPredicateCache eq = new ZDDPredicateCache();
        ZDDOperationCache cu = new ZDDOperationCache();
        ZDDOperationCache un = new ZDDOperationCache();
        return ZDD.trees3(eq, cu, un, i3);
    }

    static ZDD trees3(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, Collection<Collection<Collection<String>>> i3) {
        ZDD[] zs = new ZDD[i3.size()];
        int j = 0;
        for (Collection<Collection<String>> i2 : i3) {
            zs[j++] = ZDD.trees2(eq, cu, un, i2);
        }
        return ZDD.union(eq, un, zs);
    }

    private static ZDD trees2(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, Collection<Collection<String>> i2) {
        ZDD[] zs = new ZDD[i2.size()];
        int j = 0;
        for (Collection<String> i : i2) {
            zs[j++] = ZDD.trees1(eq, cu, un, i);
        }
        return ZDD.crossUnion(eq, cu, un, zs);
    }

    private static ZDD trees1(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, Collection<String> i) {
        return ZDD.trees1(eq, cu, un, 1L, i.iterator());
    }

    private static ZDD trees1(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, long h, Iterator<String> i) {
        if (i.hasNext()) {
            long h1 = ZDD.djb2(h, i.next());
            return ZDD.union(eq, un, TOP, ZDD.crossUnion(eq, cu, un, ZDD.singleton(h1), ZDD.trees1(eq, cu, un, h1, i)));
        }
        return TOP;
    }

    public static ZDD tree(Collection<Collection<Collection<String>>> i3) {
        ZDDPredicateCache eq = new ZDDPredicateCache();
        ZDDOperationCache cu = new ZDDOperationCache();
        ZDDOperationCache un = new ZDDOperationCache();
        return ZDD.tree3(eq, cu, un, i3);
    }

    public static ZDD tree2(Collection<Collection<String>> i2) {
        ZDDPredicateCache eq = new ZDDPredicateCache();
        ZDDOperationCache cu = new ZDDOperationCache();
        ZDDOperationCache un = new ZDDOperationCache();
        return ZDD.tree2(eq, cu, un, i2);
    }

    public static ZDD tree1(Collection<String> i) {
        ZDDPredicateCache eq = new ZDDPredicateCache();
        ZDDOperationCache cu = new ZDDOperationCache();
        ZDDOperationCache un = new ZDDOperationCache();
        return ZDD.tree1(eq, cu, un, i);
    }

    private static ZDD tree3(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, Collection<Collection<Collection<String>>> i3) {
        ZDD[] zs = new ZDD[i3.size()];
        int j = 0;
        for (Collection<Collection<String>> i2 : i3) {
            zs[j++] = ZDD.tree2(eq, cu, un, i2);
        }
        return ZDD.union(eq, un, zs);
    }

    private static ZDD tree2(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, Collection<Collection<String>> i2) {
        ZDD[] zs = new ZDD[i2.size()];
        int j = 0;
        for (Collection<String> i : i2) {
            zs[j++] = ZDD.tree1(eq, cu, un, i);
        }
        return ZDD.crossUnion(eq, cu, un, zs);
    }

    private static ZDD tree1(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, Collection<String> i) {
        ZDD[] zs = new ZDD[i.size()];
        long h = 1L;
        int j = 0;
        for (String s : i) {
            int n = j++;
            h = ZDD.djb2(h, s);
            zs[n] = ZDD.singleton(h);
        }
        return ZDD.crossUnion(eq, cu, un, zs);
    }

    public static ZDD tree(String[] ... a) {
        return ZDD.tree(new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache(), a);
    }

    public static ZDD tree(String ... a) {
        return ZDD.tree(new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache(), a);
    }

    static ZDD tree(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, String[] ... a) {
        int n = a.length;
        ZDD[] trees = new ZDD[n];
        int i = 0;
        while (i < n) {
            trees[i] = ZDD.tree(eq, cu, un, a[i]);
            ++i;
        }
        return ZDD.crossUnion(eq, cu, un, trees);
    }

    static ZDD tree(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, String ... a) {
        long h = 1L;
        ZDD p = TOP;
        String[] stringArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            h = ZDD.djb2(h, s);
            p = ZDD.crossUnion(eq, cu, un, p, ZDD.singleton(h));
            ++n2;
        }
        return p;
    }

    static long djb2(long seed, String string) {
        long hash = 5381L;
        hash = 33L * hash ^ seed >>> 56 & 0xFFL;
        hash = 33L * hash ^ seed >>> 48 & 0xFFL;
        hash = 33L * hash ^ seed >>> 40 & 0xFFL;
        hash = 33L * hash ^ seed >>> 32 & 0xFFL;
        hash = 33L * hash ^ seed >>> 24 & 0xFFL;
        hash = 33L * hash ^ seed >>> 16 & 0xFFL;
        hash = 33L * hash ^ seed >>> 8 & 0xFFL;
        hash = 33L * hash ^ seed & 0xFFL;
        int i = 0;
        while (i < string.length()) {
            hash = 33L * hash ^ (long)string.charAt(i);
            ++i;
        }
        return hash;
    }

    public int hashCode() {
        return this.h;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof ZDD && ZDD.equals(this, (ZDD)obj);
    }

    public String toString() {
        if (this == BOT) {
            return "BOT";
        }
        if (this == TOP) {
            return "TOP";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("ZDD [x=");
        builder.append(this.x);
        builder.append(", ");
        if (this.b != null) {
            builder.append("b=");
            builder.append(this.b);
            builder.append(", ");
        }
        if (this.t != null) {
            builder.append("t=");
            builder.append(this.t);
            builder.append(", ");
        }
        builder.append("h=");
        builder.append(this.h);
        builder.append(", s=");
        builder.append(this.s);
        builder.append("]");
        return builder.toString();
    }

    static ZDD union(ZDDPredicateCache eq, ZDDOperationCache un, ZDD ... zdds) {
        int l = zdds.length;
        if (l > 2) {
            int l1 = l >> 1;
            int l2 = l - l1;
            ZDD[] zdds1 = new ZDD[l1];
            ZDD[] zdds2 = new ZDD[l2];
            System.arraycopy(zdds, 0, zdds1, 0, l1);
            System.arraycopy(zdds, l1, zdds2, 0, l2);
            return ZDD.union(eq, un, ZDD.union(eq, un, zdds1), ZDD.union(eq, un, zdds2));
        }
        if (l > 1) {
            return ZDD.union(eq, un, zdds[0], zdds[1]);
        }
        if (l > 0) {
            return zdds[0];
        }
        return BOT;
    }

    static ZDD union(ZDDPredicateCache eq, ZDDOperationCache un, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return zdd2;
        }
        if (zdd2 == BOT) {
            return zdd1;
        }
        if (ZDD.equals(eq, zdd1, zdd2)) {
            return zdd1;
        }
        ZDD zdd = un.get(zdd1, zdd2);
        if (zdd == null) {
            long x2;
            long x1;
            zdd = zdd1 == TOP ? ZDD.unionTop(un, zdd2) : (zdd2 == TOP ? ZDD.unionTop(un, zdd1) : ((x1 = zdd1.x) < (x2 = zdd2.x) ? ZDD.zdd(x1, ZDD.union(eq, un, zdd1.b, zdd2), zdd1.t) : (x1 > x2 ? ZDD.zdd(x2, ZDD.union(eq, un, zdd1, zdd2.b), zdd2.t) : ZDD.zdd(x1, ZDD.union(eq, un, zdd1.b, zdd2.b), ZDD.union(eq, un, zdd1.t, zdd2.t)))));
            un.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    private static ZDD unionTop(ZDDOperationCache un, ZDD zdd1) {
        if (zdd1 == BOT) {
            return TOP;
        }
        if (zdd1 == TOP) {
            return TOP;
        }
        ZDD zdd = un.get(TOP, zdd1);
        if (zdd == null) {
            zdd = ZDD.zdd(zdd1.x, ZDD.unionTop(un, zdd1.b), zdd1.t);
            un.put(TOP, zdd1, zdd);
        }
        return zdd;
    }

    static ZDD intersection(ZDDPredicateCache eq, ZDDOperationCache in, ZDD ... zdds) {
        int l = zdds.length;
        if (l > 2) {
            int l1 = l >> 1;
            int l2 = l - l1;
            ZDD[] zdds1 = new ZDD[l1];
            ZDD[] zdds2 = new ZDD[l2];
            System.arraycopy(zdds, 0, zdds1, 0, l1);
            System.arraycopy(zdds, l1, zdds2, 0, l2);
            return ZDD.intersection(eq, in, ZDD.intersection(eq, in, zdds1), ZDD.intersection(eq, in, zdds2));
        }
        if (l > 1) {
            return ZDD.intersection(eq, in, zdds[0], zdds[1]);
        }
        if (l > 0) {
            return zdds[0];
        }
        return BOT;
    }

    static ZDD intersection(ZDDPredicateCache eq, ZDDOperationCache in, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd2 == BOT) {
            return BOT;
        }
        if (ZDD.equals(eq, zdd1, zdd2)) {
            return zdd1;
        }
        ZDD zdd = in.get(zdd1, zdd2);
        if (zdd == null) {
            long x2;
            long x1;
            zdd = zdd1 == TOP ? ZDD.intersectionTop(in, zdd2) : (zdd2 == TOP ? ZDD.intersectionTop(in, zdd1) : ((x1 = zdd1.x) < (x2 = zdd2.x) ? ZDD.intersection(eq, in, zdd1.b, zdd2) : (x1 > x2 ? ZDD.intersection(eq, in, zdd1, zdd2.b) : ZDD.zdd(x1, ZDD.intersection(eq, in, zdd1.b, zdd2.b), ZDD.intersection(eq, in, zdd1.t, zdd2.t)))));
            in.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    private static ZDD intersectionTop(ZDDOperationCache in, ZDD zdd1) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd1 == TOP) {
            return TOP;
        }
        ZDD zdd = in.get(TOP, zdd1);
        if (zdd == null) {
            zdd = ZDD.intersectionTop(in, zdd1.b);
            in.put(TOP, zdd1, zdd);
        }
        return zdd;
    }

    static ZDD difference(ZDDPredicateCache eq, ZDDOperationCache di, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd2 == BOT) {
            return zdd1;
        }
        if (ZDD.equals(eq, zdd1, zdd2)) {
            return BOT;
        }
        ZDD zdd = di.get(zdd1, zdd2);
        if (zdd == null) {
            long x2;
            long x1;
            zdd = zdd1 == TOP ? ZDD.topDifference(di, zdd2) : (zdd2 == TOP ? ZDD.differenceTop(di, zdd1) : ((x1 = zdd1.x) < (x2 = zdd2.x) ? ZDD.zdd(x1, ZDD.difference(eq, di, zdd1.b, zdd2), zdd1.t) : (x1 > x2 ? ZDD.difference(eq, di, zdd1, zdd2.b) : ZDD.zdd(x1, ZDD.difference(eq, di, zdd1.b, zdd2.b), ZDD.difference(eq, di, zdd1.t, zdd2.t)))));
            di.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    private static ZDD differenceTop(ZDDOperationCache di, ZDD zdd1) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd1 == TOP) {
            return BOT;
        }
        ZDD zdd = di.get(zdd1, TOP);
        if (zdd == null) {
            zdd = ZDD.zdd(zdd1.x, ZDD.differenceTop(di, zdd1.b), zdd1.t);
            di.put(zdd1, TOP, zdd);
        }
        return zdd;
    }

    private static ZDD topDifference(ZDDOperationCache di, ZDD zdd2) {
        if (zdd2 == BOT) {
            return TOP;
        }
        if (zdd2 == TOP) {
            return BOT;
        }
        ZDD zdd = di.get(TOP, zdd2);
        if (zdd == null) {
            zdd = ZDD.topDifference(di, zdd2.b);
            di.put(TOP, zdd2, zdd);
        }
        return zdd;
    }

    static ZDD crossUnion(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, ZDD ... zdds) {
        int l = zdds.length;
        if (l > 2) {
            int l1 = l >> 1;
            int l2 = l - l1;
            ZDD[] zdds1 = new ZDD[l1];
            ZDD[] zdds2 = new ZDD[l2];
            System.arraycopy(zdds, 0, zdds1, 0, l1);
            System.arraycopy(zdds, l1, zdds2, 0, l2);
            return ZDD.crossUnion(eq, cu, un, ZDD.crossUnion(eq, cu, un, zdds1), ZDD.crossUnion(eq, cu, un, zdds2));
        }
        if (l > 1) {
            return ZDD.crossUnion(eq, cu, un, zdds[0], zdds[1]);
        }
        if (l > 0) {
            return zdds[0];
        }
        return TOP;
    }

    static ZDD crossUnion(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd2 == BOT) {
            return BOT;
        }
        if (zdd1 == TOP) {
            return zdd2;
        }
        if (zdd2 == TOP) {
            return zdd1;
        }
        ZDD zdd = cu.get(zdd1, zdd2);
        if (zdd == null) {
            long x1 = zdd1.x;
            long x2 = zdd2.x;
            zdd = x1 < x2 ? ZDD.zdd(x1, ZDD.crossUnion(eq, cu, un, zdd1.b, zdd2), ZDD.crossUnion(eq, cu, un, zdd1.t, zdd2)) : (x1 > x2 ? ZDD.zdd(x2, ZDD.crossUnion(eq, cu, un, zdd1, zdd2.b), ZDD.crossUnion(eq, cu, un, zdd1, zdd2.t)) : ZDD.zdd(x1, ZDD.crossUnion(eq, cu, un, zdd1.b, zdd2.b), ZDD.union(eq, un, ZDD.crossUnion(eq, cu, un, zdd1.t, zdd2.t), ZDD.union(eq, un, ZDD.crossUnion(eq, cu, un, zdd1.t, zdd2.b), ZDD.crossUnion(eq, cu, un, zdd1.b, zdd2.t)))));
            cu.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    static ZDD set(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, long ... xs) {
        ZDD[] zdd = new ZDD[xs.length];
        int i = 0;
        while (i < xs.length) {
            zdd[i] = ZDD.singleton(xs[i]);
            ++i;
        }
        return ZDD.crossUnion(eq, cu, un, zdd);
    }

    static ZDD crossIntersection(ZDDPredicateCache eq, ZDDOperationCache ci, ZDDOperationCache un, ZDD ... zdds) {
        int l = zdds.length;
        if (l > 2) {
            int l1 = l >> 1;
            int l2 = l - l1;
            ZDD[] zdds1 = new ZDD[l1];
            ZDD[] zdds2 = new ZDD[l2];
            System.arraycopy(zdds, 0, zdds1, 0, l1);
            System.arraycopy(zdds, l1, zdds2, 0, l2);
            return ZDD.crossIntersection(eq, ci, un, ZDD.crossIntersection(eq, ci, un, zdds1), ZDD.crossIntersection(eq, ci, un, zdds2));
        }
        if (l > 1) {
            return ZDD.crossIntersection(eq, ci, un, zdds[0], zdds[1]);
        }
        if (l > 0) {
            return zdds[0];
        }
        return TOP;
    }

    static ZDD crossIntersection(ZDDPredicateCache eq, ZDDOperationCache ci, ZDDOperationCache un, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd2 == BOT) {
            return BOT;
        }
        if (zdd1 == TOP) {
            return TOP;
        }
        if (zdd2 == TOP) {
            return TOP;
        }
        ZDD zdd = ci.get(zdd1, zdd2);
        if (zdd == null) {
            long x1 = zdd1.x;
            long x2 = zdd2.x;
            zdd = x1 < x2 ? ZDD.union(eq, un, ZDD.crossIntersection(eq, ci, un, zdd1.b, zdd2), ZDD.crossIntersection(eq, ci, un, zdd1.t, zdd2)) : (x1 > x2 ? ZDD.union(eq, un, ZDD.crossIntersection(eq, ci, un, zdd1, zdd2.b), ZDD.crossIntersection(eq, ci, un, zdd1, zdd2.t)) : ZDD.zdd(x1, ZDD.union(eq, un, ZDD.crossIntersection(eq, ci, un, zdd1.b, zdd2.b), ZDD.union(eq, un, ZDD.crossIntersection(eq, ci, un, zdd1.b, zdd2.t), ZDD.crossIntersection(eq, ci, un, zdd1.t, zdd2.b))), ZDD.crossIntersection(eq, ci, un, zdd1.t, zdd2.t)));
            ci.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    static ZDD crossDifference(ZDDPredicateCache eq, ZDDOperationCache cd, ZDDOperationCache un, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd2 == BOT) {
            return BOT;
        }
        if (zdd1 == TOP) {
            return TOP;
        }
        if (zdd2 == TOP) {
            return zdd1;
        }
        ZDD zdd = cd.get(zdd1, zdd2);
        if (zdd == null) {
            long x1 = zdd1.x;
            long x2 = zdd2.x;
            zdd = x1 < x2 ? ZDD.zdd(x1, ZDD.crossDifference(eq, cd, un, zdd1.b, zdd2), ZDD.crossDifference(eq, cd, un, zdd1.t, zdd2)) : (x1 > x2 ? ZDD.union(eq, un, ZDD.crossDifference(eq, cd, un, zdd1, zdd2.b), ZDD.crossDifference(eq, cd, un, zdd1, zdd2.t)) : ZDD.zdd(x1, ZDD.union(eq, un, ZDD.crossDifference(eq, cd, un, zdd1.b, zdd2.b), ZDD.crossDifference(eq, cd, un, zdd1.b, zdd2.t), ZDD.crossDifference(eq, cd, un, zdd1.t, zdd2.t)), ZDD.crossDifference(eq, cd, un, zdd1.t, zdd2.b)));
            cd.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    static boolean equals(ZDDPredicateCache eq, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == zdd2) {
            return true;
        }
        if (zdd1 == BOT) {
            return zdd2 == BOT;
        }
        if (zdd1 == TOP) {
            return zdd2 == TOP;
        }
        if (zdd2 == BOT) {
            return zdd1 == BOT;
        }
        if (zdd2 == TOP) {
            return zdd1 == TOP;
        }
        Boolean cached = eq.get(zdd1, zdd2);
        if (cached != null) {
            return cached;
        }
        boolean equal = zdd1.h != zdd2.h ? false : (zdd1.x != zdd2.x ? false : (!ZDD.equals(eq, zdd1.b, zdd2.b) ? false : ZDD.equals(eq, zdd1.t, zdd2.t)));
        eq.put(zdd1, zdd2, equal);
        return equal;
    }
}

