/*
 * Decompiled with CFR 0.152.
 */
package net.ftod.zcube.zdd;

import java.util.Collection;
import net.ftod.zcube.zdd.ZDD;
import net.ftod.zcube.zdd.ZDDLong;
import net.ftod.zcube.zdd.ZDDOperationCache;
import net.ftod.zcube.zdd.ZDDPredicateCache;
import net.ftod.zcube.zdd.ZDDTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZDDNumber {
    public final ZDD digit;
    public final ZDDNumber number;

    private ZDDNumber(ZDD digit, ZDDNumber number) {
        this.digit = digit;
        this.number = number;
    }

    private static ZDDNumber number(ZDD digit, ZDDNumber number) {
        if (digit == ZDD.BOT && number == null) {
            return null;
        }
        return new ZDDNumber(digit, number);
    }

    static ZDDNumber shift(ZDDNumber n) {
        return ZDDNumber.number(ZDD.BOT, n);
    }

    public static ZDDNumber binary(long l, ZDD zdd) {
        return l == 0L ? null : ZDDNumber.number(l % 2L == 0L ? ZDD.BOT : zdd, ZDDNumber.binary(l >> 1, zdd));
    }

    public static long binary(ZDDNumber zddn, ZDD zdd) {
        return ZDDNumber.binary(new ZDDPredicateCache(), new ZDDPredicateCache(), zddn, zdd);
    }

    static long binary(ZDDPredicateCache eq, ZDDPredicateCache in, ZDDNumber zddn, ZDD zdd) {
        return zddn == null ? 0L : (ZDD.included(eq, in, zdd, zddn.digit) ? 1L : 0L) + (ZDDNumber.binary(eq, in, zddn.number, zdd) << 1);
    }

    public static ZDDNumber binaryAdd(ZDDNumber zddn1, ZDDNumber zddn2) {
        return ZDDNumber.binaryAdd(new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache(), new ZDDOperationCache(), zddn1, zddn2);
    }

    static ZDDNumber binaryAdd(ZDDPredicateCache eq, ZDDOperationCache in, ZDDOperationCache un, ZDDOperationCache di, ZDDNumber zddn1, ZDDNumber zddn2) {
        ZDDNumber zddnc = ZDDNumber.intersection(eq, in, zddn1, zddn2);
        ZDDNumber zddns = ZDDNumber.difference(eq, di, ZDDNumber.union(eq, un, zddn1, zddn2), zddnc);
        if (zddnc == null) {
            return zddns;
        }
        if (zddns == null) {
            return new ZDDNumber(ZDD.BOT, zddnc);
        }
        return ZDDNumber.number(zddns.digit, ZDDNumber.binaryAdd(eq, in, un, di, zddns.number, zddnc));
    }

    public static ZDDNumber negabinary(long l, ZDD zdd) {
        long l1;
        ZDD digit;
        if (l == 0L) {
            return null;
        }
        long q = l / -2L;
        long r = l + 2L * q;
        if (r > 0L) {
            digit = zdd;
            l1 = q;
        } else if (r < 0L) {
            digit = zdd;
            l1 = q + 1L;
        } else {
            digit = ZDD.BOT;
            l1 = q;
        }
        return ZDDNumber.number(digit, ZDDNumber.negabinary(l1, zdd));
    }

    public static long negabinary(ZDDNumber zddn, ZDD zdd) {
        return ZDDNumber.negabinary(new ZDDPredicateCache(), new ZDDPredicateCache(), zddn, zdd);
    }

    static long negabinary(ZDDPredicateCache eq, ZDDPredicateCache in, ZDDNumber zddn, ZDD zdd) {
        if (zddn == null) {
            return 0L;
        }
        return (ZDD.included(eq, in, zdd, zddn.digit) ? 1L : 0L) + ZDDNumber.negabinary(eq, in, zddn.number, zdd) * -2L;
    }

    public static ZDDNumber negabinaryAdd(ZDDNumber zddn1, ZDDNumber zddn2) {
        return ZDDNumber.negabinaryAdd(new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache(), new ZDDOperationCache(), zddn1, zddn2);
    }

    static ZDDNumber negabinaryAdd(ZDDPredicateCache eq, ZDDOperationCache in, ZDDOperationCache un, ZDDOperationCache di, ZDDNumber zddn1, ZDDNumber zddn2) {
        ZDDNumber zddnc = ZDDNumber.intersection(eq, in, zddn1, zddn2);
        ZDDNumber zddns = ZDDNumber.difference(eq, di, ZDDNumber.union(eq, un, zddn1, zddn2), zddnc);
        if (zddnc == null) {
            return zddns;
        }
        return ZDDNumber.negabinarySub(eq, in, un, di, zddns, ZDDNumber.shift(zddnc));
    }

    public static ZDDNumber negabinarySub(ZDDNumber zddn1, ZDDNumber zddn2) {
        return ZDDNumber.negabinarySub(new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache(), new ZDDOperationCache(), zddn1, zddn2);
    }

    static ZDDNumber negabinarySub(ZDDPredicateCache eq, ZDDOperationCache in, ZDDOperationCache un, ZDDOperationCache di, ZDDNumber zddn1, ZDDNumber zddn2) {
        ZDDNumber zddnb = ZDDNumber.difference(eq, di, zddn2, zddn1);
        ZDDNumber zddnd = ZDDNumber.union(eq, un, ZDDNumber.difference(eq, di, zddn1, zddn2), zddnb);
        if (zddnb == null) {
            return zddnd;
        }
        return ZDDNumber.negabinaryAdd(eq, in, un, di, zddnd, ZDDNumber.shift(zddnb));
    }

    private static ZDDNumber intersection(ZDDPredicateCache eq, ZDDOperationCache in, ZDDNumber zddn1, ZDDNumber zddn2) {
        if (zddn1 == null) {
            return null;
        }
        if (zddn2 == null) {
            return null;
        }
        return ZDDNumber.number(ZDD.intersection(eq, in, zddn1.digit, zddn2.digit), ZDDNumber.intersection(eq, in, zddn1.number, zddn2.number));
    }

    private static ZDDNumber union(ZDDPredicateCache eq, ZDDOperationCache un, ZDDNumber zddn1, ZDDNumber zddn2) {
        if (zddn1 == null) {
            return zddn2;
        }
        if (zddn2 == null) {
            return zddn1;
        }
        return ZDDNumber.number(ZDD.union(eq, un, zddn1.digit, zddn2.digit), ZDDNumber.union(eq, un, zddn1.number, zddn2.number));
    }

    private static ZDDNumber difference(ZDDPredicateCache eq, ZDDOperationCache di, ZDDNumber zddn1, ZDDNumber zddn2) {
        if (zddn1 == null) {
            return null;
        }
        if (zddn2 == null) {
            return zddn1;
        }
        return ZDDNumber.number(ZDD.difference(eq, di, zddn1.digit, zddn2.digit), ZDDNumber.difference(eq, di, zddn1.number, zddn2.number));
    }

    public static ZDDNumber addSubtrees(ZDDLong zl, ZDDNumber zn) {
        return ZDDNumber.addSubtrees(zl.l, zl.t, zn);
    }

    public static ZDDNumber addSubtrees(long l, ZDDTree trees, ZDDNumber zn) {
        ZDDPredicateCache _equ = new ZDDPredicateCache();
        ZDDOperationCache _cru = new ZDDOperationCache();
        ZDDOperationCache _uni = new ZDDOperationCache();
        ZDDOperationCache _int = new ZDDOperationCache();
        ZDDOperationCache _dif = new ZDDOperationCache();
        return ZDDNumber.negabinaryAdd(_equ, _int, _uni, _dif, ZDDNumber.negabinary(l, ZDDTree.subtrees(trees, _equ, _cru, _uni)), zn);
    }

    public static ZDDNumber addSubtrees(ZDDLong zl, ZDD filter, ZDDNumber zn) {
        return ZDDNumber.addSubtrees(zl.l, zl.t, filter, zn);
    }

    public static ZDDNumber addSubtrees(long l, ZDDTree trees, ZDD filter, ZDDNumber zn) {
        ZDDPredicateCache _equ = new ZDDPredicateCache();
        ZDDOperationCache _cru = new ZDDOperationCache();
        ZDDOperationCache _uni = new ZDDOperationCache();
        ZDDOperationCache _int = new ZDDOperationCache();
        ZDDOperationCache _dif = new ZDDOperationCache();
        return ZDDNumber.negabinaryAdd(_equ, _int, _uni, _dif, ZDDNumber.negabinary(l, ZDD.intersection(_equ, _int, filter, ZDDTree.trees(trees, _equ, _cru, _uni))), zn);
    }

    public static ZDDNumber addSubtrees(long l, Collection<Collection<Collection<String>>> trees, ZDDNumber zn) {
        ZDDPredicateCache _equ = new ZDDPredicateCache();
        ZDDOperationCache _cru = new ZDDOperationCache();
        ZDDOperationCache _uni = new ZDDOperationCache();
        ZDDOperationCache _int = new ZDDOperationCache();
        ZDDOperationCache _dif = new ZDDOperationCache();
        return ZDDNumber.negabinaryAdd(_equ, _int, _uni, _dif, ZDDNumber.negabinary(l, ZDD.trees3(_equ, _cru, _uni, trees)), zn);
    }

    public static ZDDNumber addSubtrees(long l, Collection<Collection<Collection<String>>> trees, ZDD filter, ZDDNumber zn) {
        ZDDPredicateCache _equ = new ZDDPredicateCache();
        ZDDOperationCache _cru = new ZDDOperationCache();
        ZDDOperationCache _uni = new ZDDOperationCache();
        ZDDOperationCache _int = new ZDDOperationCache();
        ZDDOperationCache _dif = new ZDDOperationCache();
        return ZDDNumber.negabinaryAdd(_equ, _int, _uni, _dif, ZDDNumber.negabinary(l, ZDD.intersection(_equ, _int, filter, ZDD.trees3(_equ, _cru, _uni, trees))), zn);
    }

    public static ZDDNumber addSubtrees(long l, String[][][] trees, ZDDNumber zn) {
        ZDDPredicateCache _equ = new ZDDPredicateCache();
        ZDDOperationCache _cru = new ZDDOperationCache();
        ZDDOperationCache _uni = new ZDDOperationCache();
        ZDDOperationCache _int = new ZDDOperationCache();
        ZDDOperationCache _dif = new ZDDOperationCache();
        return ZDDNumber.negabinaryAdd(_equ, _int, _uni, _dif, ZDDNumber.negabinary(l, ZDD.trees(_equ, _cru, _uni, trees)), zn);
    }

    public static ZDDNumber addSubtrees(long l, String[][][] trees, ZDD filter, ZDDNumber zn) {
        ZDDPredicateCache _equ = new ZDDPredicateCache();
        ZDDOperationCache _cru = new ZDDOperationCache();
        ZDDOperationCache _uni = new ZDDOperationCache();
        ZDDOperationCache _int = new ZDDOperationCache();
        ZDDOperationCache _dif = new ZDDOperationCache();
        return ZDDNumber.negabinaryAdd(_equ, _int, _uni, _dif, ZDDNumber.negabinary(l, ZDD.intersection(_equ, _int, filter, ZDD.trees(_equ, _cru, _uni, trees))), zn);
    }

    public static String sizes(ZDDNumber n) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (n != null) {
            sb.append(n.digit.s);
            ZDDNumber n1 = n.number;
            while (n1 != null) {
                sb.append(',');
                sb.append(n1.digit.s);
                n1 = n1.number;
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

