/*
 * Decompiled with CFR 0.152.
 */
package net.ftod.zcube.zdd;

import net.ftod.zcube.zdd.ZDD;

final class ZDDPredicateCache {
    private static final int POWER = 8;
    private static final int SIZE = 256;
    private static final int MAX = 255;
    private long hit = 0L;
    private long miss = 0L;
    private final ZDD[] _zdd1 = new ZDD[256];
    private final ZDD[] _zdd2 = new ZDD[256];
    private final Boolean[] _bool = new Boolean[256];

    private static int index(ZDD zdd1, ZDD zdd2) {
        return 1 + 31 * (zdd1.h + 31 * zdd2.h) & 0xFF;
    }

    ZDDPredicateCache() {
    }

    Boolean get(ZDD zdd1, ZDD zdd2) {
        int index = ZDDPredicateCache.index(zdd1, zdd2);
        if (zdd1 != this._zdd1[index] || zdd2 != this._zdd2[index]) {
            ++this.miss;
            return null;
        }
        ++this.hit;
        return this._bool[index];
    }

    void put(ZDD zdd1, ZDD zdd2, boolean zdd3) {
        int index = ZDDPredicateCache.index(zdd1, zdd2);
        this._zdd1[index] = zdd1;
        this._zdd2[index] = zdd2;
        this._bool[index] = zdd3;
    }

    long hit() {
        return this.hit;
    }

    long miss() {
        return this.miss;
    }
}

