/*
 * Decompiled with CFR 0.152.
 */
package net.ftod.zcube.zdd;

import net.ftod.zcube.zdd.ZDDCacheL;
import net.ftod.zcube.zdd.ZDDCacheN;
import net.ftod.zcube.zdd.ZDDCacheO;
import net.ftod.zcube.zdd.ZDDCacheP;

public final class ZDD {
    static final int CACHE_POWER = 7;
    static final int CACHE_SIZE = 128;
    static final int CACHE_MAX = 127;
    public static final ZDD BOT = new ZDD(0L, null, null, 1);
    public static final ZDD TOP = new ZDD(0L, null, null, 2);
    public final long x;
    public final ZDD b;
    public final ZDD t;
    public final int h;

    private ZDD(long x, ZDD b, ZDD t, int h) {
        this.x = x;
        this.b = b;
        this.t = t;
        this.h = h;
    }

    private ZDD(long x, ZDD b, ZDD t) {
        this(x, b, t, ZDD.hash(x, b, t));
    }

    private static int hash(long x, ZDD b, ZDD t) {
        int result = 1;
        result = 31 * result + ZDD.hash(x);
        result = 31 * result + b.h;
        result = 31 * result + t.h;
        return result;
    }

    private static int hash(long l) {
        return (int)(l ^ l >>> 32);
    }

    private static ZDD zdd(ZDDCacheN nod, long x, ZDD b, ZDD t) {
        if (t == BOT) {
            return b;
        }
        int h = ZDD.hash(x, b, t);
        ZDD z = nod.get(h, x, b, t);
        if (z == null) {
            z = new ZDD(x, b, t, h);
            nod.put(h, x, b, t, z);
        }
        return z;
    }

    public static long size(ZDD z) {
        return ZDD.size(new ZDDCacheL(), z);
    }

    static long size(ZDDCacheL _clo, ZDD z) {
        if (z == BOT) {
            return 0L;
        }
        if (z == TOP) {
            return 1L;
        }
        Long cached = _clo.get(z);
        if (cached != null) {
            return cached;
        }
        long s = ZDD.size(_clo, z.b) + ZDD.size(_clo, z.t);
        _clo.put(z, s);
        return s;
    }

    public static ZDD singleton(long x) {
        return ZDD.singleton(new ZDDCacheN(), x);
    }

    static ZDD singleton(ZDDCacheN _nod, long x) {
        return ZDD.zdd(_nod, x, BOT, TOP);
    }

    public static ZDD set(long ... xs) {
        return ZDD.set(new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), new ZDDCacheO(), xs);
    }

    public static boolean included(ZDD zdd1, ZDD zdd2) {
        return ZDD.included(new ZDDCacheP(), new ZDDCacheP(), zdd1, zdd2);
    }

    static boolean included(ZDDCacheP _equ, ZDDCacheP _inc, ZDD zdd1, ZDD zdd2) {
        if (ZDD.equals(_equ, zdd1, zdd2)) {
            return true;
        }
        if (zdd1 == BOT) {
            return true;
        }
        if (zdd1 == TOP) {
            return ZDD.topIncluded(zdd2);
        }
        if (zdd2 == BOT) {
            return false;
        }
        if (zdd2 == TOP) {
            return false;
        }
        Boolean cached = _inc.get(zdd1, zdd2);
        if (cached != null) {
            return cached;
        }
        long x1 = zdd1.x;
        long x2 = zdd2.x;
        boolean included = x1 < x2 ? false : (x1 > x2 ? ZDD.included(_equ, _inc, zdd1, zdd2.b) : ZDD.included(_equ, _inc, zdd1.b, zdd2.b) && ZDD.included(_equ, _inc, zdd1.t, zdd2.t));
        _inc.put(zdd1, zdd2, included);
        return included;
    }

    private static boolean topIncluded(ZDD zdd) {
        if (zdd == BOT) {
            return false;
        }
        if (zdd == TOP) {
            return true;
        }
        return ZDD.topIncluded(zdd.b);
    }

    public static ZDD union(ZDD zdd1, ZDD zdd2) {
        return ZDD.union(new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), zdd1, zdd2);
    }

    public static ZDD union(ZDD ... zdds) {
        return ZDD.union(new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), zdds);
    }

    public static boolean equals(ZDD zdd1, ZDD zdd2) {
        return ZDD.equals(new ZDDCacheP(), zdd1, zdd2);
    }

    public int hashCode() {
        return this.h;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof ZDD && ZDD.equals(this, (ZDD)obj);
    }

    public String toString() {
        if (this == BOT) {
            return "BOT";
        }
        if (this == TOP) {
            return "TOP";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("ZDD [x=");
        builder.append(this.x);
        builder.append(", ");
        if (this.b != null) {
            builder.append("b=");
            builder.append(this.b);
            builder.append(", ");
        }
        if (this.t != null) {
            builder.append("t=");
            builder.append(this.t);
            builder.append(", ");
        }
        builder.append("h=");
        builder.append(this.h);
        builder.append("]");
        return builder.toString();
    }

    static ZDD union(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _uni, ZDD ... zdds) {
        return ZDD.union(_nod, _equ, _uni, 0, zdds.length, zdds);
    }

    static ZDD union(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _uni, int begin, int end, ZDD[] zdda) {
        int length = end - begin;
        if (length > 2) {
            int middle = begin + (length >> 1);
            return ZDD.union(_nod, _equ, _uni, ZDD.union(_nod, _equ, _uni, begin, middle, zdda), ZDD.union(_nod, _equ, _uni, middle, end, zdda));
        }
        if (length > 1) {
            return ZDD.union(_nod, _equ, _uni, zdda[begin], zdda[begin + 1]);
        }
        if (length > 0) {
            return zdda[begin];
        }
        return BOT;
    }

    static ZDD union(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _uni, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return zdd2;
        }
        if (zdd2 == BOT) {
            return zdd1;
        }
        if (ZDD.equals(_equ, zdd1, zdd2)) {
            return zdd1;
        }
        ZDD zdd = _uni.get(zdd1, zdd2);
        if (zdd == null) {
            long x2;
            long x1;
            zdd = zdd1 == TOP ? ZDD.unionTop(_nod, _uni, zdd2) : (zdd2 == TOP ? ZDD.unionTop(_nod, _uni, zdd1) : ((x1 = zdd1.x) < (x2 = zdd2.x) ? ZDD.zdd(_nod, x1, ZDD.union(_nod, _equ, _uni, zdd1.b, zdd2), zdd1.t) : (x1 > x2 ? ZDD.zdd(_nod, x2, ZDD.union(_nod, _equ, _uni, zdd1, zdd2.b), zdd2.t) : ZDD.zdd(_nod, x1, ZDD.union(_nod, _equ, _uni, zdd1.b, zdd2.b), ZDD.union(_nod, _equ, _uni, zdd1.t, zdd2.t)))));
            _uni.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    private static ZDD unionTop(ZDDCacheN _nod, ZDDCacheO _uni, ZDD zdd1) {
        if (zdd1 == BOT) {
            return TOP;
        }
        if (zdd1 == TOP) {
            return TOP;
        }
        ZDD zdd = _uni.get(TOP, zdd1);
        if (zdd == null) {
            zdd = ZDD.zdd(_nod, zdd1.x, ZDD.unionTop(_nod, _uni, zdd1.b), zdd1.t);
            _uni.put(TOP, zdd1, zdd);
        }
        return zdd;
    }

    static ZDD intersection(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _int, ZDD ... zdds) {
        return ZDD.intersection(_nod, _equ, _int, 0, zdds.length, zdds);
    }

    static ZDD intersection(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _int, int begin, int end, ZDD[] zdda) {
        int length = end - begin;
        if (length > 2) {
            int middle = begin + (length >> 1);
            return ZDD.intersection(_nod, _equ, _int, ZDD.intersection(_nod, _equ, _int, begin, middle, zdda), ZDD.intersection(_nod, _equ, _int, middle, end, zdda));
        }
        if (length > 1) {
            return ZDD.intersection(_nod, _equ, _int, zdda[begin], zdda[begin + 1]);
        }
        if (length > 0) {
            return zdda[begin];
        }
        return BOT;
    }

    static ZDD intersection(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _int, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd2 == BOT) {
            return BOT;
        }
        if (ZDD.equals(_equ, zdd1, zdd2)) {
            return zdd1;
        }
        ZDD zdd = _int.get(zdd1, zdd2);
        if (zdd == null) {
            long x2;
            long x1;
            zdd = zdd1 == TOP ? ZDD.intersectionTop(_int, zdd2) : (zdd2 == TOP ? ZDD.intersectionTop(_int, zdd1) : ((x1 = zdd1.x) < (x2 = zdd2.x) ? ZDD.intersection(_nod, _equ, _int, zdd1.b, zdd2) : (x1 > x2 ? ZDD.intersection(_nod, _equ, _int, zdd1, zdd2.b) : ZDD.zdd(_nod, x1, ZDD.intersection(_nod, _equ, _int, zdd1.b, zdd2.b), ZDD.intersection(_nod, _equ, _int, zdd1.t, zdd2.t)))));
            _int.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    private static ZDD intersectionTop(ZDDCacheO _int, ZDD zdd1) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd1 == TOP) {
            return TOP;
        }
        ZDD zdd = _int.get(TOP, zdd1);
        if (zdd == null) {
            zdd = ZDD.intersectionTop(_int, zdd1.b);
            _int.put(TOP, zdd1, zdd);
        }
        return zdd;
    }

    static ZDD difference(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _dif, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd2 == BOT) {
            return zdd1;
        }
        if (ZDD.equals(_equ, zdd1, zdd2)) {
            return BOT;
        }
        ZDD zdd = _dif.get(zdd1, zdd2);
        if (zdd == null) {
            long x2;
            long x1;
            zdd = zdd1 == TOP ? ZDD.topDifference(_dif, zdd2) : (zdd2 == TOP ? ZDD.differenceTop(_nod, _dif, zdd1) : ((x1 = zdd1.x) < (x2 = zdd2.x) ? ZDD.zdd(_nod, x1, ZDD.difference(_nod, _equ, _dif, zdd1.b, zdd2), zdd1.t) : (x1 > x2 ? ZDD.difference(_nod, _equ, _dif, zdd1, zdd2.b) : ZDD.zdd(_nod, x1, ZDD.difference(_nod, _equ, _dif, zdd1.b, zdd2.b), ZDD.difference(_nod, _equ, _dif, zdd1.t, zdd2.t)))));
            _dif.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    private static ZDD differenceTop(ZDDCacheN _nod, ZDDCacheO _dif, ZDD zdd1) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd1 == TOP) {
            return BOT;
        }
        ZDD zdd = _dif.get(zdd1, TOP);
        if (zdd == null) {
            zdd = ZDD.zdd(_nod, zdd1.x, ZDD.differenceTop(_nod, _dif, zdd1.b), zdd1.t);
            _dif.put(zdd1, TOP, zdd);
        }
        return zdd;
    }

    private static ZDD topDifference(ZDDCacheO _dif, ZDD zdd2) {
        if (zdd2 == BOT) {
            return TOP;
        }
        if (zdd2 == TOP) {
            return BOT;
        }
        ZDD zdd = _dif.get(TOP, zdd2);
        if (zdd == null) {
            zdd = ZDD.topDifference(_dif, zdd2.b);
            _dif.put(TOP, zdd2, zdd);
        }
        return zdd;
    }

    static ZDD crossUnion(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cru, ZDDCacheO _uni, ZDD ... zdds) {
        return ZDD.crossUnion(_nod, _equ, _cru, _uni, 0, zdds.length, zdds);
    }

    static ZDD crossUnion(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cru, ZDDCacheO _uni, int begin, int end, ZDD[] zdda) {
        int length = end - begin;
        if (length > 2) {
            int middle = begin + (length >> 1);
            return ZDD.crossUnion(_nod, _equ, _cru, _uni, ZDD.crossUnion(_nod, _equ, _cru, _uni, begin, middle, zdda), ZDD.crossUnion(_nod, _equ, _cru, _uni, middle, end, zdda));
        }
        if (length > 1) {
            return ZDD.crossUnion(_nod, _equ, _cru, _uni, zdda[begin], zdda[begin + 1]);
        }
        if (length > 0) {
            return zdda[begin];
        }
        return TOP;
    }

    static ZDD crossUnion(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cru, ZDDCacheO _uni, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd2 == BOT) {
            return BOT;
        }
        if (zdd1 == TOP) {
            return zdd2;
        }
        if (zdd2 == TOP) {
            return zdd1;
        }
        ZDD zdd = _cru.get(zdd1, zdd2);
        if (zdd == null) {
            long x1 = zdd1.x;
            long x2 = zdd2.x;
            zdd = x1 < x2 ? ZDD.zdd(_nod, x1, ZDD.crossUnion(_nod, _equ, _cru, _uni, zdd1.b, zdd2), ZDD.crossUnion(_nod, _equ, _cru, _uni, zdd1.t, zdd2)) : (x1 > x2 ? ZDD.zdd(_nod, x2, ZDD.crossUnion(_nod, _equ, _cru, _uni, zdd1, zdd2.b), ZDD.crossUnion(_nod, _equ, _cru, _uni, zdd1, zdd2.t)) : ZDD.zdd(_nod, x1, ZDD.crossUnion(_nod, _equ, _cru, _uni, zdd1.b, zdd2.b), ZDD.union(_nod, _equ, _uni, ZDD.crossUnion(_nod, _equ, _cru, _uni, zdd1.t, zdd2.t), ZDD.union(_nod, _equ, _uni, ZDD.crossUnion(_nod, _equ, _cru, _uni, zdd1.t, zdd2.b), ZDD.crossUnion(_nod, _equ, _cru, _uni, zdd1.b, zdd2.t)))));
            _cru.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    static ZDD set(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cru, ZDDCacheO _uni, long[] xs) {
        ZDD[] zdd = new ZDD[xs.length];
        int i = 0;
        while (i < xs.length) {
            zdd[i] = ZDD.singleton(_nod, xs[i]);
            ++i;
        }
        return ZDD.crossUnion(_nod, _equ, _cru, _uni, zdd);
    }

    static ZDD crossIntersection(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cri, ZDDCacheO _uni, ZDD[] zdds) {
        return ZDD.crossIntersection(_nod, _equ, _cri, _uni, 0, zdds.length, zdds);
    }

    static ZDD crossIntersection(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cri, ZDDCacheO _uni, int begin, int end, ZDD[] zdda) {
        int length = end - begin;
        if (length > 2) {
            int middle = begin + (length >> 1);
            return ZDD.crossIntersection(_nod, _equ, _cri, _uni, ZDD.crossIntersection(_nod, _equ, _cri, _uni, begin, middle, zdda), ZDD.crossIntersection(_nod, _equ, _cri, _uni, middle, end, zdda));
        }
        if (length > 1) {
            return ZDD.crossIntersection(_nod, _equ, _cri, _uni, zdda[begin], zdda[begin + 1]);
        }
        if (length > 0) {
            return zdda[begin];
        }
        return TOP;
    }

    static ZDD crossIntersection(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cri, ZDDCacheO _uni, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd2 == BOT) {
            return BOT;
        }
        if (zdd1 == TOP) {
            return TOP;
        }
        if (zdd2 == TOP) {
            return TOP;
        }
        ZDD zdd = _cri.get(zdd1, zdd2);
        if (zdd == null) {
            long x1 = zdd1.x;
            long x2 = zdd2.x;
            zdd = x1 < x2 ? ZDD.union(_nod, _equ, _uni, ZDD.crossIntersection(_nod, _equ, _cri, _uni, zdd1.b, zdd2), ZDD.crossIntersection(_nod, _equ, _cri, _uni, zdd1.t, zdd2)) : (x1 > x2 ? ZDD.union(_nod, _equ, _uni, ZDD.crossIntersection(_nod, _equ, _cri, _uni, zdd1, zdd2.b), ZDD.crossIntersection(_nod, _equ, _cri, _uni, zdd1, zdd2.t)) : ZDD.zdd(_nod, x1, ZDD.union(_nod, _equ, _uni, ZDD.crossIntersection(_nod, _equ, _cri, _uni, zdd1.b, zdd2.b), ZDD.union(_nod, _equ, _uni, ZDD.crossIntersection(_nod, _equ, _cri, _uni, zdd1.b, zdd2.t), ZDD.crossIntersection(_nod, _equ, _cri, _uni, zdd1.t, zdd2.b))), ZDD.crossIntersection(_nod, _equ, _cri, _uni, zdd1.t, zdd2.t)));
            _cri.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    static ZDD crossDifference(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _crd, ZDDCacheO _uni, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == BOT) {
            return BOT;
        }
        if (zdd2 == BOT) {
            return BOT;
        }
        if (zdd1 == TOP) {
            return TOP;
        }
        if (zdd2 == TOP) {
            return zdd1;
        }
        ZDD zdd = _crd.get(zdd1, zdd2);
        if (zdd == null) {
            long x1 = zdd1.x;
            long x2 = zdd2.x;
            zdd = x1 < x2 ? ZDD.zdd(_nod, x1, ZDD.crossDifference(_nod, _equ, _crd, _uni, zdd1.b, zdd2), ZDD.crossDifference(_nod, _equ, _crd, _uni, zdd1.t, zdd2)) : (x1 > x2 ? ZDD.union(_nod, _equ, _uni, ZDD.crossDifference(_nod, _equ, _crd, _uni, zdd1, zdd2.b), ZDD.crossDifference(_nod, _equ, _crd, _uni, zdd1, zdd2.t)) : ZDD.zdd(_nod, x1, ZDD.union(_nod, _equ, _uni, ZDD.crossDifference(_nod, _equ, _crd, _uni, zdd1.b, zdd2.b), ZDD.crossDifference(_nod, _equ, _crd, _uni, zdd1.b, zdd2.t), ZDD.crossDifference(_nod, _equ, _crd, _uni, zdd1.t, zdd2.t)), ZDD.crossDifference(_nod, _equ, _crd, _uni, zdd1.t, zdd2.b)));
            _crd.put(zdd1, zdd2, zdd);
        }
        return zdd;
    }

    static boolean equals(ZDDCacheP _equ, ZDD zdd1, ZDD zdd2) {
        if (zdd1 == zdd2) {
            return true;
        }
        if (zdd1.h != zdd2.h) {
            return false;
        }
        Boolean cached = _equ.get(zdd1, zdd2);
        if (cached != null) {
            return cached;
        }
        boolean equal = zdd1.x != zdd2.x ? false : (!ZDD.equals(_equ, zdd1.b, zdd2.b) ? false : ZDD.equals(_equ, zdd1.t, zdd2.t));
        _equ.put(zdd1, zdd2, equal);
        return equal;
    }
}

