/*
 * Decompiled with CFR 0.152.
 */
package net.ftod.zcube.zdd;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.ftod.zcube.zdd.ZDDNumber;
import net.ftod.zcube.zdd.ZDDTerm;

public abstract class ZDDTermReducer<T> {
    private static final ZDDTermReducer<ZDDNumber> SUM_SUBTREES = new ZDDTermReducer<ZDDNumber>(){

        @Override
        protected ZDDNumber reduce(Iterator<ZDDTerm> i) {
            return ZDDNumber.pSumSubtrees(i);
        }
    };

    private ZDDTermReducer() {
    }

    protected abstract T reduce(Iterator<ZDDTerm> var1);

    private final T reduce(File file) throws IOException {
        try (final DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file), 262144));){
            T t = this.reduce(new Iterator<ZDDTerm>(){
                private ZDDTerm next = null;

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    try {
                        this.next = ZDDTerm.read(dis);
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                    return true;
                }

                @Override
                public ZDDTerm next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    ZDDTerm _next = this.next;
                    this.next = null;
                    return _next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
            return t;
        }
    }

    public static ZDDNumber sumSubtrees(File file) throws IOException {
        return super.reduce(file);
    }

    /* synthetic */ ZDDTermReducer(ZDDTermReducer zDDTermReducer) {
        this();
    }
}

