/*
 * Decompiled with CFR 0.152.
 */
package net.ftod.zcube.zdd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.ftod.zcube.zdd.ZDD;
import net.ftod.zcube.zdd.ZDDCacheN;
import net.ftod.zcube.zdd.ZDDCacheO;
import net.ftod.zcube.zdd.ZDDCacheP;
import net.ftod.zcube.zdd.ZDDTreeLBOT;
import net.ftod.zcube.zdd.ZDDTreeLCross;
import net.ftod.zcube.zdd.ZDDTreeLNode;
import net.ftod.zcube.zdd.ZDDTreeLSum;
import net.ftod.zcube.zdd.ZDDTreeLTOP;

abstract class ZDDTreeL {
    ZDDTreeL() {
    }

    static final ZDDTreeL bot() {
        return ZDDTreeLBOT.INSTANCE;
    }

    static final ZDDTreeL top() {
        return ZDDTreeLTOP.INSTANCE;
    }

    static final ZDDTreeL node(long node, ZDDTreeL tree) {
        return new ZDDTreeLNode(node, tree);
    }

    static final ZDDTreeL sum(ZDDTreeL ... trees) {
        return new ZDDTreeLSum(trees);
    }

    static final ZDDTreeL cross(ZDDTreeL ... trees) {
        return new ZDDTreeLCross(trees);
    }

    protected abstract Type type();

    protected abstract void _write(DataOutputStream var1) throws IOException;

    public final void write(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type().ordinal());
        this._write(dos);
    }

    public static final ZDDTreeL read(DataInputStream dis) throws IOException {
        return Type.values()[dis.readByte()].read(dis);
    }

    protected static final void writeArray(ZDDTreeL[] ts, DataOutputStream dos) throws IOException {
        int n = ts.length;
        dos.writeByte(n);
        int i = 0;
        while (i < n) {
            ts[i].write(dos);
            ++i;
        }
    }

    protected static final ZDDTreeL[] readArray(DataInputStream dis) throws IOException {
        int n = dis.readByte();
        ZDDTreeL[] ts = new ZDDTreeL[n];
        int i = 0;
        while (i < n) {
            ts[i] = ZDDTreeL.read(dis);
            ++i;
        }
        return ts;
    }

    protected abstract ZDD trees(ZDDCacheN var1, ZDDCacheP var2, ZDDCacheO var3, ZDDCacheO var4);

    protected abstract ZDD subtrees(ZDDCacheN var1, ZDDCacheP var2, ZDDCacheO var3, ZDDCacheO var4);

    protected static final ZDD[] mapTrees(ZDDCacheN nod, ZDDCacheP eq, ZDDCacheO cu, ZDDCacheO un, ZDDTreeL[] ts) {
        int n = ts.length;
        ZDD[] zdds = new ZDD[n];
        int i = 0;
        while (i < n) {
            zdds[i] = ts[i].trees(nod, eq, cu, un);
            ++i;
        }
        return zdds;
    }

    protected static final ZDD[] mapSubtrees(ZDDCacheN nod, ZDDCacheP eq, ZDDCacheO cu, ZDDCacheO un, ZDDTreeL[] ts) {
        int n = ts.length;
        ZDD[] zdds = new ZDD[n];
        int i = 0;
        while (i < n) {
            zdds[i] = ts[i].subtrees(nod, eq, cu, un);
            ++i;
        }
        return zdds;
    }

    public static ZDD trees(ZDDTreeL t) {
        return ZDDTreeL.trees(t, new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), new ZDDCacheO());
    }

    static ZDD trees(ZDDTreeL t, ZDDCacheN nod, ZDDCacheP eq, ZDDCacheO cu, ZDDCacheO un) {
        return t.trees(nod, eq, cu, un);
    }

    public static ZDD unionTrees(ZDDTreeL ... ts) {
        return ZDDTreeL.unionTrees(ts, new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), new ZDDCacheO());
    }

    static ZDD unionTrees(ZDDTreeL[] ts, ZDDCacheN nod, ZDDCacheP eq, ZDDCacheO cu, ZDDCacheO un) {
        int n = ts.length;
        ZDD[] zs = new ZDD[n];
        int i = 0;
        while (i < n) {
            zs[i] = ZDDTreeL.trees(ts[i], nod, eq, cu, un);
            ++i;
        }
        return ZDD.union(nod, eq, un, zs);
    }

    public static ZDD subtrees(ZDDTreeL t) {
        return ZDDTreeL.subtrees(t, new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), new ZDDCacheO());
    }

    static ZDD subtrees(ZDDTreeL t, ZDDCacheN nod, ZDDCacheP eq, ZDDCacheO cu, ZDDCacheO un) {
        return t.subtrees(nod, eq, cu, un);
    }

    public static ZDD subtrees(ZDD z, ZDDTreeL t) {
        ZDDCacheN nod = new ZDDCacheN();
        ZDDCacheP eq = new ZDDCacheP();
        ZDDCacheO cu = new ZDDCacheO();
        ZDDCacheO un = new ZDDCacheO();
        ZDDCacheO in = new ZDDCacheO();
        return ZDD.intersection(nod, eq, in, z, ZDDTreeL.subtrees(t, nod, eq, cu, un));
    }

    protected static enum Type {
        BOT{

            ZDDTreeL read(DataInputStream dis) {
                return ZDDTreeLBOT._read(dis);
            }
        }
        ,
        TOP{

            ZDDTreeL read(DataInputStream dis) {
                return ZDDTreeLTOP._read(dis);
            }
        }
        ,
        NODE{

            ZDDTreeL read(DataInputStream dis) throws IOException {
                return ZDDTreeLNode._read(dis);
            }
        }
        ,
        CROSS{

            ZDDTreeL read(DataInputStream dis) throws IOException {
                return ZDDTreeLCross._read(dis);
            }
        }
        ,
        SUM{

            ZDDTreeL read(DataInputStream dis) throws IOException {
                return ZDDTreeLSum._read(dis);
            }
        };


        abstract ZDDTreeL read(DataInputStream var1) throws IOException;
    }
}

