/*
 * Decompiled with CFR 0.152.
 */
package net.ftod.zcube.zdd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.ftod.zcube.zdd.ZDD;
import net.ftod.zcube.zdd.ZDDCacheN;
import net.ftod.zcube.zdd.ZDDCacheO;
import net.ftod.zcube.zdd.ZDDCacheP;
import net.ftod.zcube.zdd.ZDDTreeL;

final class ZDDTreeLNode
extends ZDDTreeL {
    private final long h;
    private final ZDDTreeL t;

    ZDDTreeLNode(long h, ZDDTreeL t) {
        this.h = h;
        this.t = t;
    }

    @Override
    protected ZDDTreeL.Type type() {
        return ZDDTreeL.Type.NODE;
    }

    @Override
    protected void _write(DataOutputStream dos) throws IOException {
        dos.writeLong(this.h);
        this.t.write(dos);
    }

    static ZDDTreeLNode _read(DataInputStream dis) throws IOException {
        long node = dis.readLong();
        ZDDTreeL tree = ZDDTreeLNode.read(dis);
        return new ZDDTreeLNode(node, tree);
    }

    @Override
    protected ZDD trees(ZDDCacheN nod, ZDDCacheP eq, ZDDCacheO cu, ZDDCacheO un) {
        return ZDD.crossUnion(nod, eq, cu, un, ZDD.singleton(nod, this.h), this.t.trees(nod, eq, cu, un));
    }

    @Override
    protected ZDD subtrees(ZDDCacheN nod, ZDDCacheP eq, ZDDCacheO cu, ZDDCacheO un) {
        return ZDD.union(nod, eq, un, ZDD.TOP, ZDD.crossUnion(nod, eq, cu, un, ZDD.singleton(nod, this.h), this.t.subtrees(nod, eq, cu, un)));
    }
}

