/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.cgram;

import com.sun.gluegen.cgram.TNode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CSymbolTable {
    private Vector scopeStack = new Vector(10);
    private Hashtable symTable = new Hashtable(533);

    public void pushScope(String s) {
        this.scopeStack.addElement(s);
    }

    public void popScope() {
        int size = this.scopeStack.size();
        if (size > 0) {
            this.scopeStack.removeElementAt(size - 1);
        }
    }

    public String currentScopeAsString() {
        StringBuffer buf = new StringBuffer(100);
        boolean first = true;
        Enumeration e = this.scopeStack.elements();
        while (e.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                buf.append("::");
            }
            buf.append(e.nextElement().toString());
        }
        return buf.toString();
    }

    public String addCurrentScopeToName(String name) {
        String currScope = this.currentScopeAsString();
        return this.addScopeToName(currScope, name);
    }

    public String addScopeToName(String scope, String name) {
        if (scope == null || scope.length() > 0) {
            return scope + "::" + name;
        }
        return name;
    }

    public String removeOneLevelScope(String scopeName) {
        int index = scopeName.lastIndexOf("::");
        if (index > 0) {
            return scopeName.substring(0, index);
        }
        if (scopeName.length() > 0) {
            return "";
        }
        return null;
    }

    public TNode add(String name, TNode node) {
        return this.symTable.put(this.addCurrentScopeToName(name), node);
    }

    public TNode lookupScopedName(String scopedName) {
        return (TNode)((Object)this.symTable.get(scopedName));
    }

    public TNode lookupNameInCurrentScope(String name) {
        String scope = this.currentScopeAsString();
        TNode tnode = null;
        while (tnode == null && scope != null) {
            String scopedName = this.addScopeToName(scope, name);
            tnode = (TNode)((Object)this.symTable.get(scopedName));
            scope = this.removeOneLevelScope(scope);
        }
        return tnode;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(300);
        buff.append("CSymbolTable { \nCurrentScope: " + this.currentScopeAsString() + "\nDefinedSymbols:\n");
        Enumeration ke = this.symTable.keys();
        Enumeration ve = this.symTable.elements();
        while (ke.hasMoreElements()) {
            buff.append(ke.nextElement().toString() + " (" + TNode.getNameForType(((TNode)((Object)ve.nextElement())).getType()) + ")\n");
        }
        buff.append("}\n");
        return buff.toString();
    }
}

