/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.cgram;

import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import com.sun.gluegen.cgram.CToken;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;

public class TNode
extends CommonAST {
    protected int ttype;
    protected String text;
    protected int lineNum = 0;
    protected TNode defNode;
    protected TNode up;
    protected TNode left;
    protected boolean marker = false;
    protected Hashtable attributes = null;
    static String tokenVocabulary;

    public static void setTokenVocabulary(String s) {
        tokenVocabulary = s;
    }

    public void initialize(Token token) {
        CToken tok = (CToken)token;
        this.setText(tok.getText());
        this.setType(tok.getType());
        this.setLineNum(tok.getLine());
        this.setAttribute("source", tok.getSource());
        this.setAttribute("tokenNumber", new Integer(tok.getTokenNumber()));
    }

    public void initialize(AST tr) {
        TNode t = (TNode)tr;
        this.setText(t.getText());
        this.setType(t.getType());
        this.setLineNum(t.getLineNum());
        this.setDefNode(t.getDefNode());
        this.attributes = t.getAttributesTable();
    }

    public int getType() {
        return this.ttype;
    }

    public void setType(int ttype_) {
        this.ttype = ttype_;
    }

    public boolean getMarker() {
        return this.marker;
    }

    public void setMarker(boolean marker_) {
        this.marker = marker_;
    }

    public Hashtable getAttributesTable() {
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        return this.attributes;
    }

    public void setAttribute(String attrName, Object value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        this.attributes.put(attrName, value);
    }

    public Object getAttribute(String attrName) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attrName);
    }

    public int getLineNum() {
        if (this.lineNum != 0) {
            return this.lineNum;
        }
        if (this.down == null) {
            return this.lineNum;
        }
        return ((TNode)this.down).getLocalLineNum();
    }

    public int getLocalLineNum() {
        if (this.lineNum != 0) {
            return this.lineNum;
        }
        if (this.down == null) {
            if (this.right == null) {
                return this.lineNum;
            }
            return ((TNode)this.right).getLocalLineNum();
        }
        return ((TNode)this.down).getLocalLineNum();
    }

    public void setLineNum(int lineNum_) {
        this.lineNum = lineNum_;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text_) {
        this.text = text_;
    }

    public String getAllChildrenText() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getText());
        for (TNode node = (TNode)this.getFirstChild(); node != null; node = (TNode)node.getNextSibling()) {
            buf.append(node.getText());
        }
        return buf.toString();
    }

    public TNode getLastChild() {
        TNode down = (TNode)this.getFirstChild();
        if (down != null) {
            return down.getLastSibling();
        }
        return null;
    }

    public TNode getLastSibling() {
        TNode next = (TNode)this.getNextSibling();
        if (next != null) {
            return next.getLastSibling();
        }
        return this;
    }

    public TNode getFirstSibling() {
        TNode prev = this.left;
        if (prev != null) {
            return prev.getFirstSibling();
        }
        return this;
    }

    public TNode getParent() {
        return this.getFirstSibling().up;
    }

    public void addSibling(AST node) {
        if (node == null) {
            return;
        }
        TNode next = (TNode)this.right;
        this.right = (TNode)node;
        ((TNode)node).left = this;
        TNode nodeLastSib = ((TNode)node).getLastSibling();
        nodeLastSib.right = next;
        if (next != null) {
            next.left = nodeLastSib;
        }
    }

    public int numberOfChildren() {
        int count = 0;
        for (AST child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ++count;
        }
        return count;
    }

    public void removeSelf() {
        TNode parent = this.up;
        TNode prev = this.left;
        TNode next = (TNode)this.right;
        if (parent != null) {
            parent.down = next;
            if (next != null) {
                next.up = parent;
                next.left = prev;
            }
        } else {
            if (prev != null) {
                prev.right = next;
            }
            if (next != null) {
                next.left = prev;
            }
        }
    }

    public TNode getDefNode() {
        return this.defNode;
    }

    public void setDefNode(TNode n) {
        this.defNode = n;
    }

    public TNode deepCopy() {
        TNode copy = new TNode();
        copy.ttype = this.ttype;
        copy.text = this.text;
        copy.lineNum = this.lineNum;
        copy.defNode = this.defNode;
        if (this.attributes != null) {
            copy.attributes = (Hashtable)this.attributes.clone();
        }
        if (this.down != null) {
            copy.down = ((TNode)this.down).deepCopyWithRightSiblings();
        }
        copy.doubleLink();
        return copy;
    }

    public TNode deepCopyWithRightSiblings() {
        TNode copy = new TNode();
        copy.ttype = this.ttype;
        copy.text = this.text;
        copy.lineNum = this.lineNum;
        copy.defNode = this.defNode;
        if (this.attributes != null) {
            copy.attributes = (Hashtable)this.attributes.clone();
        }
        if (this.down != null) {
            copy.down = ((TNode)this.down).deepCopyWithRightSiblings();
        }
        if (this.right != null) {
            copy.right = ((TNode)this.right).deepCopyWithRightSiblings();
        }
        copy.doubleLink();
        return copy;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(TNode.getNameForType(this.getType()) + "[" + this.getText() + ", " + "]");
        if (this.getLineNum() != 0) {
            str.append(" line:" + this.getLineNum());
        }
        Enumeration keys = this.getAttributesTable().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            str.append(" " + key + ":" + this.getAttribute(key));
        }
        return str.toString();
    }

    public static void printTree(AST t) {
        if (t == null) {
            return;
        }
        TNode.printASTNode(t, 0);
        System.out.print("\n");
    }

    protected static void printASTNode(AST t, int indent) {
        AST next;
        String s;
        AST child1 = t.getFirstChild();
        System.out.print("\n");
        for (int i = 0; i < indent; ++i) {
            System.out.print("   ");
        }
        if (child1 != null) {
            System.out.print("(");
        }
        if ((s = t.getText()) != null && s.length() > 0) {
            System.out.print(TNode.getNameForType(t.getType()));
            System.out.print(": \"" + s + "\"");
        } else {
            System.out.print(TNode.getNameForType(t.getType()));
        }
        if (((TNode)t).getLineNum() != 0) {
            System.out.print(" line:" + ((TNode)t).getLineNum());
        }
        Enumeration keys = ((TNode)t).getAttributesTable().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            System.out.print(" " + key + ":" + ((TNode)t).getAttribute(key));
        }
        TNode def = ((TNode)t).getDefNode();
        if (def != null) {
            System.out.print("[" + TNode.getNameForType(def.getType()) + "]");
        }
        if (child1 != null) {
            TNode.printASTNode(child1, indent + 1);
            System.out.print("\n");
            for (int i = 0; i < indent; ++i) {
                System.out.print("   ");
            }
            System.out.print(")");
        }
        if ((next = t.getNextSibling()) != null) {
            TNode.printASTNode(next, indent);
        }
    }

    public static String getNameForType(int t) {
        try {
            Class<?> c = Class.forName(tokenVocabulary);
            Field[] fields = c.getDeclaredFields();
            if (t - 2 < fields.length) {
                return fields[t - 2].getName();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return "unfoundtype: " + t;
    }

    public void doubleLink() {
        TNode down;
        TNode right = (TNode)this.getNextSibling();
        if (right != null) {
            right.left = this;
            right.doubleLink();
        }
        if ((down = (TNode)this.getFirstChild()) != null) {
            down.up = this;
            down.doubleLink();
        }
    }

    public TNode parentOfType(int type) {
        if (this.up == null) {
            if (this.left == null) {
                return null;
            }
            return this.left.parentOfType(type);
        }
        if (this.up.getType() == type) {
            return this.up;
        }
        return this.up.parentOfType(type);
    }

    public TNode firstChildOfType(int type) {
        TNode down = (TNode)this.getFirstChild();
        if (down == null) {
            return null;
        }
        if (down.getType() == type) {
            return down;
        }
        return down.firstSiblingOfType(type);
    }

    public TNode firstSiblingOfType(int type) {
        TNode right = (TNode)this.getNextSibling();
        if (right == null) {
            return null;
        }
        if (right.getType() == type) {
            return right;
        }
        return right.firstSiblingOfType(type);
    }
}

