/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.cgram.types;

import com.sun.gluegen.cgram.types.SizeThunk;
import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.cgram.types.TypeVisitor;

public class ArrayType
extends Type {
    private Type elementType;
    private int length;
    private String computedName;

    public ArrayType(Type elementType, SizeThunk sizeInBytes, int length, int cvAttributes) {
        super(elementType.getName() + " *", sizeInBytes, cvAttributes);
        this.elementType = elementType;
        this.length = length;
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null || !(arg instanceof ArrayType)) {
            return false;
        }
        ArrayType t = (ArrayType)arg;
        return super.equals(arg) && this.elementType.equals(t.elementType) && this.length == t.length;
    }

    @Override
    public String getName(boolean includeCVAttrs) {
        if (this.computedName == null) {
            this.computedName = this.elementType.getName() + " *";
            this.computedName = this.computedName.intern();
        }
        return this.computedName;
    }

    @Override
    public ArrayType asArray() {
        return this;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public int getLength() {
        return this.length;
    }

    public boolean hasLength() {
        return this.length >= 0;
    }

    public Type getBaseElementType() {
        ArrayType t = this;
        while (t.getElementType().isArray()) {
            t = t.getElementType().asArray();
        }
        return t.getElementType();
    }

    public void recomputeSize() {
        ArrayType arrayElementType = this.getElementType().asArray();
        if (arrayElementType != null) {
            arrayElementType.recomputeSize();
        }
        super.setSize(SizeThunk.mul(SizeThunk.constant(this.getLength()), this.elementType.getSize()));
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(String variableName) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.elementType.getName());
        if (variableName != null) {
            buf.append(" ");
            buf.append(variableName);
        }
        buf.append("[");
        buf.append(this.length);
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void visit(TypeVisitor arg) {
        super.visit(arg);
        this.elementType.visit(arg);
    }

    @Override
    Type newCVVariant(int cvAttributes) {
        return new ArrayType(this.elementType, this.getSize(), this.length, cvAttributes);
    }
}

