/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.cgram.types;

import com.sun.gluegen.cgram.types.SizeThunk;
import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.cgram.types.TypeVisitor;
import java.util.ArrayList;

public class FunctionType
extends Type {
    private Type returnType;
    private ArrayList argumentTypes;
    private ArrayList argumentNames;

    public FunctionType(String name, SizeThunk size, Type returnType, int cvAttributes) {
        super(name, size, cvAttributes);
        this.returnType = returnType;
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null || !(arg instanceof FunctionType)) {
            return false;
        }
        FunctionType t = (FunctionType)arg;
        return super.equals(arg) && this.returnType.equals(t.returnType) && FunctionType.listsEqual(this.argumentTypes, t.argumentTypes);
    }

    @Override
    public FunctionType asFunction() {
        return this;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public int getNumArguments() {
        return this.argumentTypes == null ? 0 : this.argumentTypes.size();
    }

    public String getArgumentName(int i) {
        return (String)this.argumentNames.get(i);
    }

    public Type getArgumentType(int i) {
        return (Type)this.argumentTypes.get(i);
    }

    public void addArgument(Type argumentType, String argumentName) {
        if (this.argumentTypes == null) {
            this.argumentTypes = new ArrayList();
            this.argumentNames = new ArrayList();
        }
        this.argumentTypes.add(argumentType);
        this.argumentNames.add(argumentName);
    }

    public void setArgumentName(int i, String name) {
        this.argumentNames.set(i, name);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(String functionName) {
        return this.toString(functionName, false);
    }

    public String toString(String functionName, boolean emitNativeTag) {
        return this.toString(functionName, null, emitNativeTag, false);
    }

    String toString(String functionName, String callingConvention, boolean emitNativeTag, boolean isPointer) {
        StringBuffer res = new StringBuffer();
        res.append(this.getReturnType());
        res.append(" ");
        if (isPointer) {
            res.append("(");
            if (callingConvention != null) {
                res.append(callingConvention);
            }
            res.append("*");
        }
        if (functionName != null) {
            if (emitNativeTag) {
                res.append("{@native ");
            }
            res.append(functionName);
            if (emitNativeTag) {
                res.append("}");
            }
        }
        if (isPointer) {
            res.append(")");
        }
        res.append("(");
        int n = this.getNumArguments();
        for (int i = 0; i < n; ++i) {
            Type t = this.getArgumentType(i);
            if (t.isFunctionPointer()) {
                FunctionType ft = t.asPointer().getTargetType().asFunction();
                res.append(ft.toString(this.getArgumentName(i), callingConvention, false, true));
            } else if (t.isArray()) {
                res.append(t.asArray().toString(this.getArgumentName(i)));
            } else {
                res.append(t);
                String argumentName = this.getArgumentName(i);
                if (argumentName != null) {
                    res.append(" ");
                    res.append(argumentName);
                }
            }
            if (i >= n - 1) continue;
            res.append(", ");
        }
        res.append(")");
        if (!isPointer) {
            res.append(";");
        }
        return res.toString();
    }

    @Override
    public void visit(TypeVisitor arg) {
        super.visit(arg);
        this.returnType.visit(arg);
        int n = this.getNumArguments();
        for (int i = 0; i < n; ++i) {
            this.getArgumentType(i).visit(arg);
        }
    }

    @Override
    Type newCVVariant(int cvAttributes) {
        return this;
    }
}

