/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.cgram.types;

import com.sun.gluegen.cgram.types.FunctionType;
import com.sun.gluegen.cgram.types.SizeThunk;
import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.cgram.types.TypeVisitor;

public class PointerType
extends Type {
    private Type targetType;
    private String computedName;
    private boolean hasTypedefedName = false;

    public PointerType(SizeThunk size, Type targetType, int cvAttributes) {
        this(size, targetType, cvAttributes, false, null);
    }

    private PointerType(SizeThunk size, Type targetType, int cvAttributes, boolean hasTypedefedName, String typedefedName) {
        super(targetType.getName() + " *", size, cvAttributes);
        this.targetType = targetType;
        if (hasTypedefedName) {
            this.setName(typedefedName);
        }
    }

    @Override
    public int hashCode() {
        return this.targetType.hashCode();
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null || !(arg instanceof PointerType)) {
            return false;
        }
        PointerType t = (PointerType)arg;
        return this.getSize() == t.getSize() && this.getCVAttributes() == t.getCVAttributes() && this.targetType.equals(t.targetType);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.hasTypedefedName = true;
    }

    @Override
    public String getName(boolean includeCVAttrs) {
        if (this.hasTypedefedName) {
            return super.getName(includeCVAttrs);
        }
        if (this.computedName == null) {
            this.computedName = this.targetType.getName(includeCVAttrs) + " *";
            this.computedName = this.computedName.intern();
        }
        if (!includeCVAttrs) {
            return this.computedName;
        }
        return this.targetType.getName(includeCVAttrs) + " * " + this.getCVAttributesString();
    }

    public boolean hasTypedefedName() {
        return this.hasTypedefedName;
    }

    @Override
    public PointerType asPointer() {
        return this;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    @Override
    public boolean isFunctionPointer() {
        return this.targetType.isFunction();
    }

    @Override
    public String toString() {
        if (this.hasTypedefedName) {
            return super.getName(true);
        }
        if (!this.targetType.isFunction()) {
            return this.targetType.toString() + " * " + this.getCVAttributesString();
        }
        return this.toString(null, null);
    }

    public String toString(String functionName, String callingConvention) {
        if (!this.targetType.isFunction()) {
            throw new RuntimeException("<Internal error or misuse> This method is only for use when printing function pointers");
        }
        return ((FunctionType)this.targetType).toString(functionName, callingConvention, false, true);
    }

    @Override
    public void visit(TypeVisitor arg) {
        super.visit(arg);
        this.targetType.visit(arg);
    }

    @Override
    Type newCVVariant(int cvAttributes) {
        return new PointerType(this.getSize(), this.targetType, cvAttributes, this.hasTypedefedName, this.hasTypedefedName ? this.getName() : null);
    }
}

