/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.cgram.types;

import com.sun.gluegen.cgram.types.ArrayType;
import com.sun.gluegen.cgram.types.BitType;
import com.sun.gluegen.cgram.types.CompoundType;
import com.sun.gluegen.cgram.types.DoubleType;
import com.sun.gluegen.cgram.types.EnumType;
import com.sun.gluegen.cgram.types.FloatType;
import com.sun.gluegen.cgram.types.FunctionType;
import com.sun.gluegen.cgram.types.IntType;
import com.sun.gluegen.cgram.types.MachineDescription;
import com.sun.gluegen.cgram.types.PointerType;
import com.sun.gluegen.cgram.types.SizeThunk;
import com.sun.gluegen.cgram.types.TypeVisitor;
import com.sun.gluegen.cgram.types.VoidType;
import java.util.List;

public abstract class Type {
    private String name;
    private SizeThunk size;
    private int cvAttributes;
    private int typedefedCVAttributes;
    private boolean hasTypedefName;

    protected Type(String name, SizeThunk size, int cvAttributes) {
        this.setName(name);
        this.size = size;
        this.cvAttributes = cvAttributes;
        this.hasTypedefName = false;
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean includeCVAttrs) {
        if (!includeCVAttrs) {
            return this.name;
        }
        return this.getCVAttributesString() + this.name;
    }

    public void setName(String name) {
        this.name = name == null ? name : name.intern();
        this.typedefedCVAttributes = this.cvAttributes;
        this.hasTypedefName = true;
    }

    public SizeThunk getSize() {
        return this.size;
    }

    public long getSize(MachineDescription machDesc) {
        SizeThunk thunk = this.getSize();
        if (thunk == null) {
            throw new RuntimeException("No size set for type \"" + this.getName() + "\"");
        }
        return thunk.compute(machDesc);
    }

    void setSize(SizeThunk size) {
        this.size = size;
    }

    public BitType asBit() {
        return null;
    }

    public IntType asInt() {
        return null;
    }

    public EnumType asEnum() {
        return null;
    }

    public FloatType asFloat() {
        return null;
    }

    public DoubleType asDouble() {
        return null;
    }

    public PointerType asPointer() {
        return null;
    }

    public ArrayType asArray() {
        return null;
    }

    public CompoundType asCompound() {
        return null;
    }

    public FunctionType asFunction() {
        return null;
    }

    public VoidType asVoid() {
        return null;
    }

    public boolean isBit() {
        return this.asBit() != null;
    }

    public boolean isInt() {
        return this.asInt() != null;
    }

    public boolean isEnum() {
        return this.asEnum() != null;
    }

    public boolean isFloat() {
        return this.asFloat() != null;
    }

    public boolean isDouble() {
        return this.asDouble() != null;
    }

    public boolean isPointer() {
        return this.asPointer() != null;
    }

    public boolean isArray() {
        return this.asArray() != null;
    }

    public boolean isCompound() {
        return this.asCompound() != null;
    }

    public boolean isFunction() {
        return this.asFunction() != null;
    }

    public boolean isVoid() {
        return this.asVoid() != null;
    }

    public boolean isConst() {
        return (this.cvAttributes & ~this.typedefedCVAttributes & 1) != 0;
    }

    public boolean isVolatile() {
        return (this.cvAttributes & ~this.typedefedCVAttributes & 2) != 0;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isFunctionPointer() {
        return this.isPointer() && this.asPointer().getTargetType().isFunction();
    }

    public int hashCode() {
        if (this.name == null) {
            return 0;
        }
        if (this.cvAttributes != 0) {
            String nameWithAttribs = this.name + this.cvAttributes;
            return nameWithAttribs.hashCode();
        }
        return this.name.hashCode();
    }

    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null || !(arg instanceof Type)) {
            return false;
        }
        Type t = (Type)arg;
        return (this.name == t.name || this.name != null && this.name.equals(this.name)) && this.size == t.size && this.cvAttributes == t.cvAttributes;
    }

    public String toString() {
        return this.getName(true);
    }

    public void visit(TypeVisitor visitor) {
        visitor.visitType(this);
    }

    public final int getCVAttributes() {
        return this.cvAttributes;
    }

    public final String getCVAttributesString() {
        if (this.isConst() && this.isVolatile()) {
            return "const volatile ";
        }
        if (this.isConst()) {
            return "const ";
        }
        if (this.isVolatile()) {
            return "volatile ";
        }
        return "";
    }

    public final Type getCVVariant(int cvAttributes) {
        if (this.cvAttributes == cvAttributes) {
            return this;
        }
        return this.newCVVariant(cvAttributes);
    }

    abstract Type newCVVariant(int var1);

    public boolean hasTypedefName() {
        return this.hasTypedefName;
    }

    public int pointerDepth() {
        PointerType pt = this.asPointer();
        if (pt == null) {
            return 0;
        }
        return 1 + pt.getTargetType().pointerDepth();
    }

    public int arrayDimension() {
        ArrayType arrayType = this.asArray();
        if (arrayType == null) {
            return 0;
        }
        return 1 + arrayType.getElementType().arrayDimension();
    }

    static boolean listsEqual(List a, List b) {
        return a == null && b == null || a != null && b != null && ((Object)a).equals(b);
    }
}

