/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.runtime;

import com.sun.gluegen.runtime.BufferFactory;
import com.sun.gluegen.runtime.CPU;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public class PointerBuffer {
    private ByteBuffer bb;
    private LongBuffer lb;
    private int capacity;
    private int position;
    private long[] backup;

    private PointerBuffer(ByteBuffer bb) {
        this.bb = bb;
        this.lb = bb.asLongBuffer();
        this.capacity = bb.capacity() / 8;
        this.position = 0;
        this.backup = new long[this.capacity];
    }

    public final int limit() {
        return this.capacity;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public final int remaining() {
        return this.capacity - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.capacity;
    }

    public final void rewind() {
        this.position = 0;
    }

    int arrayOffset() {
        return 0;
    }

    boolean hasArray() {
        return true;
    }

    public long[] array() {
        return this.backup;
    }

    public static PointerBuffer allocate(int size) {
        return new PointerBuffer(ByteBuffer.wrap(new byte[8 * size]));
    }

    public static PointerBuffer allocateDirect(int size) {
        return new PointerBuffer(BufferFactory.newDirectByteBuffer(8 * size));
    }

    public static PointerBuffer wrap(ByteBuffer src) {
        PointerBuffer res = new PointerBuffer(src);
        res.updateBackup();
        return res;
    }

    public static PointerBuffer wrapNative2Java(ByteBuffer src, boolean keepDirect) {
        PointerBuffer res;
        if (CPU.is32Bit()) {
            IntBuffer buf = src.asIntBuffer();
            int len = buf.capacity();
            res = src.isDirect() && keepDirect ? PointerBuffer.allocateDirect(len) : PointerBuffer.allocate(len);
            for (int i = 0; i < len; ++i) {
                res.put(i, buf.get(i));
            }
        } else {
            res = new PointerBuffer(src);
            res.updateBackup();
        }
        return res;
    }

    public ByteBuffer getBuffer() {
        return this.bb;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public long get(int idx) {
        if (0 > idx || idx >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        return this.lb.get(idx);
    }

    public long get() {
        long r = this.get(this.position + 1);
        ++this.position;
        return r;
    }

    public PointerBuffer put(int idx, long v) {
        if (0 > idx || idx >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.backup[idx] = v;
        this.lb.put(idx, v);
        return this;
    }

    public PointerBuffer put(long v) {
        this.put(this.position + 1, v);
        ++this.position;
        return this;
    }

    private void updateBackup() {
        for (int i = 0; i < this.capacity; ++i) {
            this.backup[i] = this.get(i);
        }
    }
}

