/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.runtime;

import com.sun.gluegen.runtime.DynamicLookupHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ProcAddressHelper {
    public static final String PROCADDRESS_VAR_PREFIX = "_addressof_";
    protected static boolean DEBUG;
    protected static String DEBUG_PREFIX;
    protected static int debugNum;

    protected static PrintStream getDebugOutStream() {
        PrintStream out = null;
        if (DEBUG) {
            if (DEBUG_PREFIX != null) {
                try {
                    out = new PrintStream(new BufferedOutputStream(new FileOutputStream(DEBUG_PREFIX + File.separatorChar + "procaddresshelper-" + ++debugNum + ".txt")));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    out = System.err;
                }
            } else {
                out = System.err;
            }
        }
        return out;
    }

    public static void resetProcAddressTable(Object table, DynamicLookupHelper lookup) throws RuntimeException {
        Class<?> tableClass = table.getClass();
        Field[] fields = tableClass.getFields();
        PrintStream dout = ProcAddressHelper.getDebugOutStream();
        if (DEBUG) {
            dout.println("ProcAddressHelper.resetProcAddressTable(" + table.getClass().getName() + ")");
        }
        for (int i = 0; i < fields.length; ++i) {
            String addressFieldName = fields[i].getName();
            if (!addressFieldName.startsWith(PROCADDRESS_VAR_PREFIX)) continue;
            int startOfMethodName = PROCADDRESS_VAR_PREFIX.length();
            String funcName = addressFieldName.substring(startOfMethodName);
            try {
                Field addressField = fields[i];
                assert (addressField.getType() == Long.TYPE);
                long newProcAddress = lookup.dynamicLookupFunction(funcName);
                addressField.setLong(table, newProcAddress);
                if (!DEBUG) continue;
                dout.println("  " + addressField.getName() + " -> 0x" + Long.toHexString(newProcAddress));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Can not get proc address for method \"" + funcName + "\": Couldn't set value of field \"" + addressFieldName + "\" in class " + tableClass.getName(), e);
            }
        }
        if (DEBUG) {
            dout.flush();
            if (DEBUG_PREFIX != null) {
                dout.close();
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl = DEBUG = System.getProperty("gluegen.debug.ProcAddressHelper") != null;
                if (DEBUG) {
                    DEBUG_PREFIX = System.getProperty("gluegen.debug.ProcAddressHelper.prefix");
                }
                return null;
            }
        });
    }
}

