/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.runtime.opengl;

public class GLExtensionNames {
    public static final String[] extensionsARB = new String[]{"ARB", "GL2", "OES", "KHR", "OML"};
    public static final String[] extensionsVEN = new String[]{"3DFX", "AMD", "APPLE", "ATI", "EXT", "HP", "IBM", "MESA", "MESAX", "NV", "SGI", "SGIS", "SGIX", "SUN", "WIN"};

    public static final boolean isGLFunction(String str) {
        return str.startsWith("gl") || str.startsWith("egl") || str.startsWith("wgl") || str.startsWith("agl") || str.startsWith("cgl");
    }

    public static final boolean isGLEnumeration(String str) {
        return str.startsWith("GL_") || str.startsWith("GLU_") || str.startsWith("GLX_") || str.startsWith("EGL_") || str.startsWith("WGL_") || str.startsWith("AGL_") || str.startsWith("CGL_");
    }

    public static final int getExtensionIdx(String[] extensions, String str, boolean isGLFunc) {
        if (isGLFunc) {
            for (int i = extensions.length - 1; i >= 0; --i) {
                if (!str.endsWith(extensions[i])) continue;
                return i;
            }
        } else {
            for (int i = extensions.length - 1; i >= 0; --i) {
                if (!str.endsWith("_" + extensions[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static final boolean isExtension(String[] extensions, String str, boolean isGLFunc) {
        return GLExtensionNames.getExtensionIdx(extensions, str, isGLFunc) >= 0;
    }

    public static final String getExtensionSuffix(String str, boolean isGLFunc) {
        int idx = GLExtensionNames.getExtensionIdx(extensionsARB, str, isGLFunc);
        if (idx >= 0) {
            return extensionsARB[idx];
        }
        idx = GLExtensionNames.getExtensionIdx(extensionsVEN, str, isGLFunc);
        if (idx >= 0) {
            return extensionsVEN[idx];
        }
        return null;
    }

    public static final String normalize(String[] extensions, String str, boolean isGLFunc) {
        boolean touched = false;
        for (int i = extensions.length - 1; !touched && i >= 0; --i) {
            if (isGLFunc) {
                if (!str.endsWith(extensions[i])) continue;
                str = str.substring(0, str.length() - extensions[i].length());
                touched = true;
                continue;
            }
            if (!str.endsWith("_" + extensions[i])) continue;
            str = str.substring(0, str.length() - 1 - extensions[i].length());
            touched = true;
        }
        return str;
    }

    public static final String normalizeARB(String str, boolean isGLFunc) {
        return GLExtensionNames.normalize(extensionsARB, str, isGLFunc);
    }

    public static final boolean isExtensionARB(String str, boolean isGLFunc) {
        return GLExtensionNames.isExtension(extensionsARB, str, isGLFunc);
    }

    public static final String normalizeVEN(String str, boolean isGLFunc) {
        return GLExtensionNames.normalize(extensionsVEN, str, isGLFunc);
    }

    public static final boolean isExtensionVEN(String str, boolean isGLFunc) {
        return GLExtensionNames.isExtension(extensionsVEN, str, isGLFunc);
    }

    public static final String normalize(String str, boolean isGLFunc) {
        if (GLExtensionNames.isExtensionARB(str, isGLFunc)) {
            return GLExtensionNames.normalizeARB(str, isGLFunc);
        }
        if (GLExtensionNames.isExtensionVEN(str, isGLFunc)) {
            return GLExtensionNames.normalizeVEN(str, isGLFunc);
        }
        return str;
    }

    public static final boolean isExtension(String str, boolean isGLFunc) {
        return GLExtensionNames.isExtension(extensionsARB, str, isGLFunc) || GLExtensionNames.isExtension(extensionsVEN, str, isGLFunc);
    }

    public static final int getFuncNamePermutationNumber(String name) {
        if (GLExtensionNames.isExtensionARB(name, true) || GLExtensionNames.isExtensionVEN(name, true)) {
            return 1;
        }
        return 1 + extensionsARB.length + extensionsVEN.length;
    }

    public static final String getFuncNamePermutation(String name, int i) {
        if (i == 0) {
            return name;
        }
        if (0 > i || i >= 1 + extensionsARB.length + extensionsVEN.length) {
            throw new RuntimeException("Index out of range [0.." + (1 + extensionsARB.length + extensionsVEN.length - 1) + "]: " + i);
        }
        if (--i < extensionsARB.length) {
            return name + extensionsARB[i];
        }
        return name + extensionsVEN[i -= extensionsARB.length];
    }
}

