/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.runtime.opengl;

import com.sun.gluegen.runtime.DynamicLookupHelper;
import com.sun.gluegen.runtime.ProcAddressHelper;
import com.sun.gluegen.runtime.opengl.GLExtensionNames;
import java.io.PrintStream;
import java.lang.reflect.Field;

public class GLProcAddressHelper
extends ProcAddressHelper {
    public static void resetProcAddressTable(Object table, DynamicLookupHelper lookup) throws RuntimeException {
        Class<?> tableClass = table.getClass();
        Field[] fields = tableClass.getFields();
        PrintStream dout = GLProcAddressHelper.getDebugOutStream();
        if (DEBUG) {
            dout.println("ProcAddressHelper.resetProcAddressTable(" + table.getClass().getName() + ")");
        }
        for (int i = 0; i < fields.length; ++i) {
            Field addressField;
            String addressFieldName = fields[i].getName();
            if (!addressFieldName.startsWith("_addressof_")) continue;
            int startOfMethodName = "_addressof_".length();
            String funcNameBase = addressFieldName.substring(startOfMethodName);
            try {
                addressField = fields[i];
                assert (addressField.getType() == Long.TYPE);
            }
            catch (Exception e) {
                throw new RuntimeException("Can not get proper proc address field for method \"" + funcNameBase + "\": Couldn't get field \"" + addressFieldName + "\" in class " + tableClass.getName(), e);
            }
            long newProcAddress = 0L;
            int funcNamePermNum = GLExtensionNames.getFuncNamePermutationNumber(funcNameBase);
            String funcName = null;
            for (int j = 0; 0L == newProcAddress && j < funcNamePermNum; ++j) {
                funcName = GLExtensionNames.getFuncNamePermutation(funcNameBase, j);
                try {
                    newProcAddress = lookup.dynamicLookupFunction(funcName);
                    continue;
                }
                catch (Exception e) {
                    if (!DEBUG) continue;
                    dout.println(e);
                    e.printStackTrace();
                }
            }
            try {
                addressField.setLong(table, newProcAddress);
                if (!DEBUG) continue;
                dout.println("  " + addressField.getName() + " " + funcName + " -> 0x" + Long.toHexString(newProcAddress));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Can not set proc address field for method \"" + funcNameBase + "\": Couldn't set field \"" + addressFieldName + "\" in class " + tableClass.getName(), e);
            }
        }
        if (DEBUG) {
            dout.flush();
            if (DEBUG_PREFIX != null) {
                dout.close();
            }
        }
    }
}

