/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen;

import com.sun.gluegen.CommentEmitter;
import com.sun.gluegen.FunctionEmitter;
import com.sun.gluegen.JavaMethodBindingEmitter;
import com.sun.gluegen.JavaType;
import com.sun.gluegen.MethodBinding;
import com.sun.gluegen.cgram.types.ArrayType;
import com.sun.gluegen.cgram.types.MachineDescription;
import com.sun.gluegen.cgram.types.PointerType;
import com.sun.gluegen.cgram.types.Type;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.List;

public class CMethodBindingEmitter
extends FunctionEmitter {
    protected static final CommentEmitter defaultCommentEmitter = new DefaultCommentEmitter();
    protected static final String arrayResLength = "_array_res_length";
    protected static final String arrayRes = "_array_res";
    protected static final String arrayIdx = "_array_idx";
    protected MethodBinding binding;
    private String packageName;
    private String className;
    private boolean isOverloadedBinding;
    private boolean isJavaMethodStatic;
    protected boolean forImplementingMethodCall;
    protected boolean forIndirectBufferAndArrayImplementation;
    private List temporaryCVariableDeclarations;
    private List temporaryCVariableAssignments;
    private MessageFormat returnValueCapacityExpression = null;
    private MessageFormat returnValueLengthExpression = null;
    private static final boolean EMIT_NULL_CHECKS = true;
    protected static final String STRING_CHARS_PREFIX = "_strchars_";
    protected MachineDescription machDesc;

    public CMethodBindingEmitter(MethodBinding binding, PrintWriter output, String javaPackageName, String javaClassName, boolean isOverloadedBinding, boolean isJavaMethodStatic, boolean forImplementingMethodCall, boolean forIndirectBufferAndArrayImplementation, MachineDescription machDesc) {
        super(output, false);
        assert (binding != null);
        assert (javaClassName != null);
        assert (javaPackageName != null);
        this.binding = binding;
        this.packageName = javaPackageName;
        this.className = javaClassName;
        this.isOverloadedBinding = isOverloadedBinding;
        this.isJavaMethodStatic = isJavaMethodStatic;
        this.forImplementingMethodCall = forImplementingMethodCall;
        this.forIndirectBufferAndArrayImplementation = forIndirectBufferAndArrayImplementation;
        this.machDesc = machDesc;
        this.setCommentEmitter(defaultCommentEmitter);
    }

    public final MethodBinding getBinding() {
        return this.binding;
    }

    @Override
    public String getName() {
        return this.binding.getName();
    }

    public final MessageFormat getReturnValueCapacityExpression() {
        return this.returnValueCapacityExpression;
    }

    public final void setReturnValueCapacityExpression(MessageFormat expression) {
        this.returnValueCapacityExpression = expression;
        if (!this.binding.getJavaReturnType().isNIOBuffer() && !this.binding.getJavaReturnType().isCompoundTypeWrapper()) {
            throw new IllegalArgumentException("Cannot specify return value capacity for a method that does not return java.nio.Buffer or a compound type wrapper: \"" + this.binding + "\"");
        }
    }

    public final MessageFormat getReturnValueLengthExpression() {
        return this.returnValueLengthExpression;
    }

    public final void setReturnValueLengthExpression(MessageFormat expression) {
        this.returnValueLengthExpression = expression;
        if (!this.binding.getJavaReturnType().isArray() && !this.binding.getJavaReturnType().isArrayOfCompoundTypeWrappers()) {
            throw new IllegalArgumentException("Cannot specify return value length for a method that does not return an array: \"" + this.binding + "\"");
        }
    }

    public final List getTemporaryCVariableDeclarations() {
        return this.temporaryCVariableDeclarations;
    }

    public final void setTemporaryCVariableDeclarations(List arg) {
        this.temporaryCVariableDeclarations = arg;
    }

    public final List getTemporaryCVariableAssignments() {
        return this.temporaryCVariableAssignments;
    }

    public final void setTemporaryCVariableAssignments(List arg) {
        this.temporaryCVariableAssignments = arg;
    }

    public String getJavaPackageName() {
        return this.packageName;
    }

    public String getJavaClassName() {
        return this.className;
    }

    public final boolean getIsOverloadedBinding() {
        return this.isOverloadedBinding;
    }

    public final boolean getIsJavaMethodStatic() {
        return this.isJavaMethodStatic;
    }

    public final boolean forIndirectBufferAndArrayImplementation() {
        return this.forIndirectBufferAndArrayImplementation;
    }

    public final MachineDescription getMachineDescription() {
        return this.machDesc;
    }

    @Override
    protected void emitReturnType(PrintWriter writer) {
        writer.print("JNIEXPORT ");
        writer.print(this.binding.getJavaReturnType().jniTypeName());
        writer.print(" JNICALL");
    }

    @Override
    protected void emitName(PrintWriter writer) {
        writer.println();
        writer.print("Java_");
        writer.print(this.jniMangle(this.getJavaPackageName()));
        writer.print("_");
        writer.print(this.jniMangle(this.getJavaClassName()));
        writer.print("_");
        if (this.isOverloadedBinding) {
            writer.print(this.jniMangle(this.binding));
        } else {
            writer.print(this.jniMangle(this.getName()));
        }
    }

    protected String getImplSuffix() {
        if (this.forImplementingMethodCall) {
            if (this.forIndirectBufferAndArrayImplementation) {
                return "1";
            }
            return "0";
        }
        return "";
    }

    @Override
    protected int emitArguments(PrintWriter writer) {
        writer.print("JNIEnv *env, ");
        int numEmitted = 1;
        if (this.isJavaMethodStatic && !this.binding.hasContainingType()) {
            writer.print("jclass");
        } else {
            writer.print("jobject");
        }
        writer.print(" _unused");
        ++numEmitted;
        if (this.binding.hasContainingType()) {
            writer.print(", jobject " + JavaMethodBindingEmitter.javaThisArgumentName());
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaArgType = this.binding.getJavaArgumentType(i);
            if (javaArgType.isVoid()) {
                assert (this.binding.getNumArguments() == 1);
                continue;
            }
            if (javaArgType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            writer.print(", ");
            writer.print(javaArgType.jniTypeName());
            writer.print(" ");
            writer.print(this.binding.getArgumentName(i));
            ++numEmitted;
            if (javaArgType.isPrimitiveArray() || javaArgType.isNIOBuffer()) {
                writer.print(", jint " + this.byteOffsetArgName(i));
                continue;
            }
            if (!javaArgType.isNIOBufferArray()) continue;
            writer.print(", jintArray " + this.byteOffsetArrayArgName(i));
        }
        return numEmitted;
    }

    @Override
    protected void emitBody(PrintWriter writer) {
        writer.println(" {");
        this.emitBodyVariableDeclarations(writer);
        this.emitBodyUserVariableDeclarations(writer);
        this.emitBodyVariablePreCallSetup(writer, false);
        this.emitBodyVariablePreCallSetup(writer, true);
        this.emitBodyCallCFunction(writer);
        this.emitBodyUserVariableAssignments(writer);
        this.emitBodyVariablePostCallCleanup(writer, true);
        this.emitBodyVariablePostCallCleanup(writer, false);
        this.emitBodyReturnResult(writer);
        writer.println("}");
        writer.println();
    }

    protected void emitBodyVariableDeclarations(PrintWriter writer) {
        if (this.binding.hasContainingType()) {
            this.emitPointerDeclaration(writer, this.binding.getContainingType(), this.binding.getContainingCType(), CMethodBindingEmitter.cThisArgumentName(), null);
        }
        boolean emittedDataCopyTemps = false;
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType type = this.binding.getJavaArgumentType(i);
            if (type.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            if (type.isArray() || type.isNIOBuffer() || type.isCompoundTypeWrapper() || type.isArrayOfCompoundTypeWrappers()) {
                String convName = this.pointerConversionArgumentName(i);
                boolean needsDataCopy = this.emitPointerDeclaration(writer, this.binding.getJavaArgumentType(i), this.binding.getCArgumentType(i), convName, this.binding.getArgumentName(i));
                if (!needsDataCopy || emittedDataCopyTemps) continue;
                writer.println("  jobject _tmpObj;");
                writer.println("  int _copyIndex;");
                writer.println("  jsize _tmpArrayLen;");
                writer.println("  int * _offsetHandle = NULL;");
                emittedDataCopyTemps = true;
                continue;
            }
            if (!type.isString()) continue;
            Type cType = this.binding.getCArgumentType(i);
            if (this.isUTF8Type(cType)) {
                writer.print("  const char* ");
            } else {
                writer.print("  jchar* ");
            }
            writer.print(STRING_CHARS_PREFIX);
            writer.print(this.binding.getArgumentName(i));
            writer.println(" = NULL;");
        }
        Type cReturnType = this.binding.getCReturnType();
        JavaType javaReturnType = this.binding.getJavaReturnType();
        String capitalizedComponentType = null;
        if (!cReturnType.isVoid()) {
            writer.print("  ");
            writer.print(this.binding.getCSymbol().getReturnType().getName(true));
            writer.println(" _res;");
            if (javaReturnType.isNIOByteBufferArray() || javaReturnType.isArrayOfCompoundTypeWrappers()) {
                writer.print("  int ");
                writer.print(arrayResLength);
                writer.println(";");
                writer.print("  int ");
                writer.print(arrayIdx);
                writer.println(";");
                writer.print("  jobjectArray ");
                writer.print(arrayRes);
                writer.println(";");
            } else if (javaReturnType.isArray()) {
                writer.print("  int ");
                writer.print(arrayResLength);
                writer.println(";");
                Class<?> componentType = javaReturnType.getJavaClass().getComponentType();
                if (componentType.isArray()) {
                    throw new RuntimeException("Multi-dimensional arrays not supported yet");
                }
                String javaTypeName = componentType.getName();
                capitalizedComponentType = "" + Character.toUpperCase(javaTypeName.charAt(0)) + javaTypeName.substring(1);
                String javaArrayTypeName = "j" + javaTypeName + "Array";
                writer.print("  ");
                writer.print(javaArrayTypeName);
                writer.print(" ");
                writer.print(arrayRes);
                writer.println(";");
            }
        }
    }

    protected void emitBodyUserVariableDeclarations(PrintWriter writer) {
        if (this.temporaryCVariableDeclarations != null) {
            for (String val : this.temporaryCVariableDeclarations) {
                writer.print("  ");
                writer.println(val);
            }
        }
    }

    protected boolean isUTF8Type(Type type) {
        int i = 0;
        while (!type.isInt() && !type.isVoid() && i < 2) {
            PointerType pt = type.asPointer();
            if (pt != null) {
                type = pt.getTargetType();
                continue;
            }
            ArrayType arrt = type.asArray();
            if (arrt == null) {
                throw new IllegalArgumentException("Type " + type + " should have been a pointer or array type");
            }
            type = arrt.getElementType();
        }
        if (type.isVoid()) {
            return true;
        }
        if (!type.isInt()) {
            throw new IllegalArgumentException("Type " + type + " should have been a one- or two-dimensional integer pointer or array type");
        }
        if (type.getSize(this.machDesc) != 1L && type.getSize(this.machDesc) != 2L) {
            throw new IllegalArgumentException("Type " + type + " should have been a one- or two-dimensional pointer to char or short");
        }
        return type.getSize(this.machDesc) == 1L;
    }

    protected boolean isConstPtrPtr(Type type) {
        if (type.pointerDepth() != 2) {
            return false;
        }
        return type.asPointer().getTargetType().asPointer().getTargetType().isConst();
    }

    protected void emitBodyVariablePreCallSetup(PrintWriter writer, boolean emittingPrimitiveArrayCritical) {
        int i;
        if (!emittingPrimitiveArrayCritical) {
            if (this.binding.hasContainingType()) {
                this.emitPointerConversion(writer, this.binding, this.binding.getContainingType(), this.binding.getContainingCType(), JavaMethodBindingEmitter.javaThisArgumentName(), CMethodBindingEmitter.cThisArgumentName(), null);
            }
            for (i = 0; i < this.binding.getNumArguments(); ++i) {
                JavaType type = this.binding.getJavaArgumentType(i);
                if (type.isJNIEnv() || this.binding.isArgumentThisPointer(i) || !type.isCompoundTypeWrapper() && (!type.isNIOBuffer() || this.forIndirectBufferAndArrayImplementation)) continue;
                this.emitPointerConversion(writer, this.binding, type, this.binding.getCArgumentType(i), this.binding.getArgumentName(i), this.pointerConversionArgumentName(i), this.byteOffsetArgName(i));
            }
        }
        for (i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaArgType = this.binding.getJavaArgumentType(i);
            if (javaArgType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            if (javaArgType.isArray() || javaArgType.isNIOBuffer() && this.forIndirectBufferAndArrayImplementation || javaArgType.isArrayOfCompoundTypeWrappers()) {
                boolean needsDataCopy = this.javaArgTypeNeedsDataCopy(javaArgType);
                if (!needsDataCopy && !emittingPrimitiveArrayCritical || needsDataCopy && emittingPrimitiveArrayCritical) continue;
                writer.print("  if (");
                writer.print(this.binding.getArgumentName(i));
                writer.println(" != NULL) {");
                Type cArgType = this.binding.getCArgumentType(i);
                String cArgTypeName = cArgType.getName();
                String convName = this.pointerConversionArgumentName(i);
                if (!needsDataCopy) {
                    writer.print("    ");
                    writer.print(convName);
                    writer.print(" = (");
                    if (javaArgType.isStringArray()) {
                        cArgTypeName = "jstring *";
                    }
                    writer.print(cArgTypeName);
                    writer.print(") (((char*) (*env)->GetPrimitiveArrayCritical(env, ");
                    writer.print(this.binding.getArgumentName(i));
                    writer.println(", NULL)) + " + this.byteOffsetArgName(i) + ");");
                } else {
                    if (!this.isConstPtrPtr(cArgType) && !javaArgType.isArrayOfCompoundTypeWrappers()) {
                        throw new RuntimeException("Cannot copy data for ptr-to-ptr arg type \"" + cArgType + "\": support for non-const ptr-to-ptr types not implemented.");
                    }
                    writer.println();
                    writer.println("    /* Copy contents of " + this.binding.getArgumentName(i) + " into " + convName + "_copy */");
                    String arrayLenName = "_tmpArrayLen";
                    writer.print("    ");
                    writer.print(arrayLenName);
                    writer.print(" = (*env)->GetArrayLength(env, ");
                    writer.print(this.binding.getArgumentName(i));
                    writer.println(");");
                    if (cArgType.pointerDepth() != 2) {
                        throw new RuntimeException("Could not copy data for type \"" + cArgType + "\"; copying only supported for types of the form " + "ptr-to-ptr-to-type.");
                    }
                    PointerType cArgPtrType = cArgType.asPointer();
                    if (cArgPtrType == null) {
                        throw new RuntimeException("Could not copy data for type \"" + cArgType + "\"; currently only pointer types supported.");
                    }
                    PointerType cArgElementType = cArgPtrType.getTargetType().asPointer();
                    this.emitMalloc(writer, convName + "_copy", cArgElementType.getName(), this.isConstPtrPtr((Type)cArgPtrType), arrayLenName, "Could not allocate buffer for copying data in argument \\\"" + this.binding.getArgumentName(i) + "\\\"");
                    if (javaArgType.isNIOBufferArray()) {
                        writer.println("    _offsetHandle = (int *) (*env)->GetPrimitiveArrayCritical(env, " + this.byteOffsetArrayArgName(i) + ", NULL);");
                    }
                    writer.println("    for (_copyIndex = 0; _copyIndex < " + arrayLenName + "; ++_copyIndex) {");
                    writer.println("      /* get each element of the array argument \"" + this.binding.getArgumentName(i) + "\" */");
                    writer.print("      _tmpObj = (*env)->GetObjectArrayElement(env, ");
                    writer.print(this.binding.getArgumentName(i));
                    writer.println(", _copyIndex);");
                    if (javaArgType.isStringArray()) {
                        writer.print("  ");
                        this.emitGetStringChars(writer, "(jstring) _tmpObj", convName + "_copy[_copyIndex]", this.isUTF8Type(cArgType), true);
                    } else if (javaArgType.isNIOBufferArray()) {
                        this.emitGetDirectBufferAddress(writer, "_tmpObj", cArgElementType.getName(), convName + "_copy[_copyIndex]", "_offsetHandle[_copyIndex]", true);
                    } else if (javaArgType.isArrayOfCompoundTypeWrappers()) {
                        this.emitGetDirectBufferAddress(writer, "_tmpObj", cArgElementType.getName(), convName + "_copy[_copyIndex]", null, true);
                    } else {
                        writer.print("      ");
                        this.emitMalloc(writer, convName + "_copy[_copyIndex]", cArgElementType.getTargetType().getName(), this.isConstPtrPtr((Type)cArgPtrType), "(*env)->GetArrayLength(env, _tmpObj)", "Could not allocate buffer during copying of data in argument \\\"" + this.binding.getArgumentName(i) + "\\\"");
                        throw new RuntimeException("Cannot yet handle type \"" + cArgType.getName() + "\"; need to add support for copying ptr-to-ptr-to-primitiveType subarrays");
                    }
                    writer.println("    }");
                    if (javaArgType.isNIOBufferArray()) {
                        writer.println("    (*env)->ReleasePrimitiveArrayCritical(env, " + this.byteOffsetArrayArgName(i) + ", _offsetHandle, JNI_ABORT);");
                    }
                    writer.println();
                }
                writer.println("  }");
                continue;
            }
            if (!javaArgType.isString() || !emittingPrimitiveArrayCritical) continue;
            this.emitGetStringChars(writer, this.binding.getArgumentName(i), STRING_CHARS_PREFIX + this.binding.getArgumentName(i), this.isUTF8Type(this.binding.getCArgumentType(i)), false);
        }
    }

    protected void emitBodyVariablePostCallCleanup(PrintWriter writer, boolean emittingPrimitiveArrayCritical) {
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaArgType = this.binding.getJavaArgumentType(i);
            if (javaArgType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            Type cArgType = this.binding.getCArgumentType(i);
            if (javaArgType.isArray() || javaArgType.isNIOBuffer() && this.forIndirectBufferAndArrayImplementation || javaArgType.isArrayOfCompoundTypeWrappers()) {
                boolean needsDataCopy = this.javaArgTypeNeedsDataCopy(javaArgType);
                if (!needsDataCopy && !emittingPrimitiveArrayCritical || needsDataCopy && emittingPrimitiveArrayCritical) continue;
                writer.print("  if (");
                writer.print(this.binding.getArgumentName(i));
                writer.println(" != NULL) {");
                String convName = this.pointerConversionArgumentName(i);
                if (!needsDataCopy) {
                    writer.print("    (*env)->ReleasePrimitiveArrayCritical(env, ");
                    writer.print(this.binding.getArgumentName(i));
                    writer.print(", ");
                    writer.print(convName);
                    writer.println(", 0);");
                } else {
                    if (!this.isConstPtrPtr(cArgType)) {
                        if (javaArgType.isArrayOfCompoundTypeWrappers()) {
                            String argName = this.binding.getArgumentName(i);
                            writer.println("    _tmpArrayLen = (*env)->GetArrayLength(env, " + argName + ");");
                            writer.println("    for (_copyIndex = 0; _copyIndex < _tmpArrayLen; ++_copyIndex) {");
                            writer.println("      _tmpObj = (*env)->GetObjectArrayElement(env, " + argName + ", _copyIndex);");
                            String copyName = this.pointerConversionArgumentName(i) + "_copy";
                            writer.println("      if ((" + copyName + "[_copyIndex] == NULL && _tmpObj == NULL) ||");
                            writer.println("          (" + copyName + "[_copyIndex] != NULL && _tmpObj != NULL &&");
                            writer.println("           (*env)->GetDirectBufferAddress(env, _tmpObj) == " + copyName + "[_copyIndex])) {");
                            writer.println("        /* No copy back needed */");
                            writer.println("      } else {");
                            writer.println("        if (" + copyName + "[_copyIndex] == NULL) {");
                            writer.println("          (*env)->SetObjectArrayElement(env, " + argName + ", _copyIndex, NULL);");
                            writer.println("        } else {");
                            writer.println("          _tmpObj = (*env)->NewDirectByteBuffer(env, " + copyName + "[_copyIndex], sizeof(" + cArgType.getName() + "));");
                            writer.println("          (*env)->SetObjectArrayElement(env, " + argName + ", _copyIndex, _tmpObj);");
                            writer.println("        }");
                            writer.println("      }");
                            writer.println("    }");
                        } else {
                            throw new RuntimeException("Cannot clean up copied data for ptr-to-ptr arg type \"" + cArgType + "\": support for cleaning up most non-const ptr-to-ptr types not implemented.");
                        }
                    }
                    writer.println("    /* Clean up " + convName + "_copy */");
                    if (!javaArgType.isNIOBufferArray() && !javaArgType.isArrayOfCompoundTypeWrappers()) {
                        String arrayLenName = "_tmpArrayLen";
                        writer.print("    ");
                        writer.print(arrayLenName);
                        writer.print(" = (*env)->GetArrayLength(env, ");
                        writer.print(this.binding.getArgumentName(i));
                        writer.println(");");
                        PointerType cArgPtrType = cArgType.asPointer();
                        if (cArgPtrType == null) {
                            throw new RuntimeException("Could not copy data for type \"" + cArgType + "\"; currently only pointer types supported.");
                        }
                        PointerType cArgElementType = cArgPtrType.getTargetType().asPointer();
                        writer.println("    for (_copyIndex = 0; _copyIndex < " + arrayLenName + "; ++_copyIndex) {");
                        writer.println("      /* free each element of " + convName + "_copy */");
                        writer.print("      _tmpObj = (*env)->GetObjectArrayElement(env, ");
                        writer.print(this.binding.getArgumentName(i));
                        writer.println(", _copyIndex);");
                        if (!javaArgType.isStringArray()) {
                            throw new RuntimeException("Cannot yet handle type \"" + cArgType.getName() + "\"; need to add support for cleaning up copied ptr-to-ptr-to-primitiveType subarrays");
                        }
                        writer.print("     (*env)->ReleaseStringUTFChars(env, ");
                        writer.print("(jstring) _tmpObj");
                        writer.print(", ");
                        writer.print(convName + "_copy[_copyIndex]");
                        writer.println(");");
                        writer.println("    }");
                    }
                    writer.print("    free((void*) ");
                    writer.print(convName + "_copy");
                    writer.println(");");
                }
                writer.println("  }");
                continue;
            }
            if (!javaArgType.isString() || emittingPrimitiveArrayCritical) continue;
            writer.print("  if (");
            writer.print(this.binding.getArgumentName(i));
            writer.println(" != NULL) {");
            if (this.isUTF8Type(cArgType)) {
                writer.print("    (*env)->ReleaseStringUTFChars(env, ");
                writer.print(this.binding.getArgumentName(i));
                writer.print(", _strchars_");
                writer.print(this.binding.getArgumentName(i));
                writer.println(");");
            } else {
                writer.println("    free((void*) _strchars_" + this.binding.getArgumentName(i) + ");");
            }
            writer.println("  }");
        }
    }

    protected int emitBodyPassCArguments(PrintWriter writer) {
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaArgType;
            if (i != 0) {
                writer.print(", ");
            }
            if ((javaArgType = this.binding.getJavaArgumentType(i)).isVoid()) {
                assert (this.binding.getNumArguments() == 1);
                continue;
            }
            if (javaArgType.isJNIEnv()) {
                writer.print("env");
                continue;
            }
            if (this.binding.isArgumentThisPointer(i)) {
                writer.print(CMethodBindingEmitter.cThisArgumentName());
                continue;
            }
            writer.print("(");
            Type cArgType = this.binding.getCSymbol().getArgumentType(i);
            if (this.isConstPtrPtr(cArgType)) {
                writer.print("const ");
            }
            writer.print(cArgType.getName());
            writer.print(") ");
            if (this.binding.getCArgumentType(i).isPointer() && this.binding.getJavaArgumentType(i).isPrimitive()) {
                writer.print("(intptr_t) ");
            }
            if (javaArgType.isArray() || javaArgType.isNIOBuffer() || javaArgType.isCompoundTypeWrapper() || javaArgType.isArrayOfCompoundTypeWrappers()) {
                writer.print(this.pointerConversionArgumentName(i));
                if (!this.javaArgTypeNeedsDataCopy(javaArgType)) continue;
                writer.print("_copy");
                continue;
            }
            if (javaArgType.isString()) {
                writer.print(STRING_CHARS_PREFIX);
            }
            writer.print(this.binding.getArgumentName(i));
        }
        return this.binding.getNumArguments();
    }

    protected void emitBodyCallCFunction(PrintWriter writer) {
        writer.print("  ");
        Type cReturnType = this.binding.getCReturnType();
        if (!cReturnType.isVoid()) {
            writer.print("_res = ");
        }
        if (this.binding.hasContainingType()) {
            writer.print(CMethodBindingEmitter.cThisArgumentName() + "->");
        }
        writer.print(this.binding.getCSymbol().getName());
        writer.print("(");
        this.emitBodyPassCArguments(writer);
        writer.println(");");
    }

    protected void emitBodyUserVariableAssignments(PrintWriter writer) {
        if (this.temporaryCVariableAssignments != null) {
            for (String val : this.temporaryCVariableAssignments) {
                writer.print("  ");
                writer.println(val);
            }
        }
    }

    protected void emitBodyReturnResult(PrintWriter writer) {
        Type cReturnType = this.binding.getCReturnType();
        if (!cReturnType.isVoid()) {
            JavaType javaReturnType = this.binding.getJavaReturnType();
            if (javaReturnType.isPrimitive()) {
                writer.print("  return ");
                if (cReturnType.isPointer()) {
                    writer.print("(" + javaReturnType.jniTypeName() + ") (intptr_t) ");
                }
                writer.println("_res;");
            } else if (javaReturnType.isNIOBuffer() || javaReturnType.isCompoundTypeWrapper()) {
                writer.println("  if (_res == NULL) return NULL;");
                writer.print("  return (*env)->NewDirectByteBuffer(env, _res, ");
                if (this.returnValueCapacityExpression != null) {
                    writer.print(this.returnValueCapacityExpression.format(this.argumentNameArray()));
                } else {
                    if (cReturnType.isPointer() && cReturnType.asPointer().getTargetType().isCompound() && cReturnType.asPointer().getTargetType().getSize() == null) {
                        throw new RuntimeException("Error emitting code for compound return type for function \"" + this.binding + "\": " + "Structs to be emitted should have been laid out by this point " + "(type " + cReturnType.asPointer().getTargetType().getName() + " / " + cReturnType.asPointer().getTargetType() + " was not)");
                    }
                    writer.print("sizeof(" + cReturnType.getName() + ")");
                    System.err.println("WARNING: No capacity specified for java.nio.Buffer return value for function \"" + this.binding + "\";" + " assuming size of equivalent C return type (sizeof(" + cReturnType.getName() + ")): " + this.binding);
                }
                writer.println(");");
            } else if (javaReturnType.isString()) {
                writer.print("  if (_res == NULL) return NULL;");
                writer.println("  return (*env)->NewStringUTF(env, _res);");
            } else if (javaReturnType.isArrayOfCompoundTypeWrappers() || javaReturnType.isArray() && javaReturnType.isNIOByteBufferArray()) {
                writer.println("  if (_res == NULL) return NULL;");
                if (this.returnValueLengthExpression == null) {
                    throw new RuntimeException("Error while generating C code: no length specified for array returned from function " + this.binding);
                }
                writer.println("  _array_res_length = " + this.returnValueLengthExpression.format(this.argumentNameArray()) + ";");
                writer.println("  _array_res = (*env)->NewObjectArray(env, _array_res_length, (*env)->FindClass(env, \"java/nio/ByteBuffer\"), NULL);");
                writer.println("  for (_array_idx = 0; _array_idx < _array_res_length; _array_idx++) {");
                Type retType = this.binding.getCSymbol().getReturnType();
                Type pointerType = retType.isPointer() ? retType.asPointer().getTargetType() : retType.asArray().getElementType();
                Type baseType = pointerType.asPointer().getTargetType();
                writer.println("    (*env)->SetObjectArrayElement(env, _array_res, _array_idx, (*env)->NewDirectByteBuffer(env, _res[_array_idx], sizeof(" + pointerType.getName() + ")));");
                writer.println("  }");
                writer.println("  return _array_res;");
            } else {
                if (javaReturnType.isArray()) {
                    throw new RuntimeException("Could not emit native code for function \"" + this.binding + "\": array return values for non-char types not implemented yet");
                }
                System.err.print("Unhandled return type: ");
                javaReturnType.dump();
                throw new RuntimeException("Unhandled return type");
            }
        }
    }

    protected static String cThisArgumentName() {
        return "this0";
    }

    protected String jniMangle(String name) {
        return name.replaceAll("_", "_1").replace('.', '_');
    }

    protected String jniMangle(MethodBinding binding) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.jniMangle(this.getName()));
        buf.append(this.getImplSuffix());
        buf.append("__");
        if (binding.hasContainingType()) {
            this.jniMangle(ByteBuffer.class, buf, true);
        }
        for (int i = 0; i < binding.getNumArguments(); ++i) {
            if (binding.isArgumentThisPointer(i)) continue;
            JavaType type = binding.getJavaArgumentType(i);
            if (type.isVoid()) {
                if (i == 0 && binding.getNumArguments() <= 1) continue;
                throw new RuntimeException("Saw illegal \"void\" argument while emitting \"" + this.getName() + "\"");
            }
            Class<?> c = type.getJavaClass();
            if (c != null) {
                this.jniMangle(c, buf, false);
                if (type.isNIOBuffer()) {
                    this.jniMangle(Integer.TYPE, buf, false);
                } else if (type.isNIOBufferArray()) {
                    int[] intArrayType = new int[]{};
                    c = intArrayType.getClass();
                    this.jniMangle(c, buf, true);
                }
                if (!type.isPrimitiveArray()) continue;
                this.jniMangle(Integer.TYPE, buf, false);
                continue;
            }
            if (type.isCompoundTypeWrapper()) {
                this.jniMangle(ByteBuffer.class, buf, true);
                continue;
            }
            if (type.isArrayOfCompoundTypeWrappers()) {
                ByteBuffer[] tmp = new ByteBuffer[]{};
                this.jniMangle(tmp.getClass(), buf, true);
                continue;
            }
            if (type.isJNIEnv()) continue;
            throw new RuntimeException("Unknown kind of JavaType: name=" + type.getName());
        }
        return buf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void jniMangle(Class c, StringBuffer res, boolean syntheticArgument) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                res.append("Z");
                return;
            } else if (c == Byte.TYPE) {
                res.append("B");
                return;
            } else if (c == Character.TYPE) {
                res.append("C");
                return;
            } else if (c == Short.TYPE) {
                res.append("S");
                return;
            } else if (c == Integer.TYPE) {
                res.append("I");
                return;
            } else if (c == Long.TYPE) {
                res.append("J");
                return;
            } else if (c == Float.TYPE) {
                res.append("F");
                return;
            } else {
                if (c != Double.TYPE) throw new RuntimeException("Illegal primitive type \"" + c.getName() + "\"");
                res.append("D");
            }
            return;
        } else if (syntheticArgument) {
            if (c.isArray()) {
                res.append("_3");
                Class<?> componentType = c.getComponentType();
                this.jniMangle(componentType, res, componentType == ByteBuffer.class);
                return;
            } else {
                res.append("L");
                res.append(c.getName().replace('.', '_'));
                res.append("_2");
            }
            return;
        } else if (c.isArray()) {
            res.append("_3");
            this.jniMangle(c.getComponentType(), res, false);
            return;
        } else if (c == String.class) {
            res.append("L");
            res.append(c.getName().replace('.', '_'));
            res.append("_2");
            return;
        } else {
            res.append("L");
            res.append("java_lang_Object");
            res.append("_2");
        }
    }

    private void emitOutOfMemoryCheck(PrintWriter writer, String varName, String errorMessage) {
        writer.print("    if (");
        writer.print(varName);
        writer.println(" == NULL) {");
        writer.println("      (*env)->ThrowNew(env, (*env)->FindClass(env, \"java/lang/OutOfMemoryError\"),");
        writer.print("                       \"" + errorMessage);
        writer.print(" in native dispatcher for \\\"");
        writer.print(this.getName());
        writer.println("\\\"\");");
        writer.print("      return");
        if (!this.binding.getJavaReturnType().isVoid()) {
            writer.print(" 0");
        }
        writer.println(";");
        writer.println("    }");
    }

    private void emitMalloc(PrintWriter writer, String targetVarName, String elementTypeString, boolean elementTypeIsConst, String numElementsExpression, String mallocFailureErrorString) {
        writer.print("    ");
        writer.print(targetVarName);
        writer.print(" = (");
        if (elementTypeIsConst) {
            writer.print("const ");
        }
        writer.print(elementTypeString);
        writer.print(" *) malloc(");
        writer.print(numElementsExpression);
        writer.print(" * sizeof(");
        writer.print(elementTypeString);
        writer.println("));");
        this.emitOutOfMemoryCheck(writer, targetVarName, mallocFailureErrorString);
    }

    private void emitCalloc(PrintWriter writer, String targetVarName, String elementTypeString, String numElementsExpression, String mallocFailureErrorString) {
        writer.print("    ");
        writer.print(targetVarName);
        writer.print(" = (");
        writer.print(elementTypeString);
        writer.print(" *) calloc(");
        writer.print(numElementsExpression);
        writer.print(", sizeof(");
        writer.print(elementTypeString);
        writer.println("));");
        this.emitOutOfMemoryCheck(writer, targetVarName, mallocFailureErrorString);
    }

    private void emitGetStringChars(PrintWriter writer, String sourceVarName, String receivingVarName, boolean isUTF8, boolean emitElseClause) {
        writer.print("  if (");
        writer.print(sourceVarName);
        writer.println(" != NULL) {");
        if (isUTF8) {
            writer.print("    ");
            writer.print(receivingVarName);
            writer.print(" = (*env)->GetStringUTFChars(env, ");
            writer.print(sourceVarName);
            writer.println(", (jboolean*)NULL);");
            this.emitOutOfMemoryCheck(writer, receivingVarName, "Failed to get UTF-8 chars for argument \\\"" + sourceVarName + "\\\"");
        } else {
            this.emitCalloc(writer, receivingVarName, "jchar", "(*env)->GetStringLength(env, " + sourceVarName + ") + 1", "Could not allocate temporary buffer for copying string argument \\\"" + sourceVarName + "\\\"");
            writer.println("    (*env)->GetStringRegion(env, " + sourceVarName + ", 0, (*env)->GetStringLength(env, " + sourceVarName + "), " + receivingVarName + ");");
        }
        writer.print("  }");
        if (emitElseClause) {
            writer.print(" else {");
            writer.print("      ");
            writer.print(receivingVarName);
            writer.println(" = NULL;");
            writer.println("  }");
        } else {
            writer.println();
        }
    }

    private void emitGetDirectBufferAddress(PrintWriter writer, String sourceVarName, String receivingVarTypeString, String receivingVarName, String byteOffsetVarName, boolean emitElseClause) {
        writer.print("    if (");
        writer.print(sourceVarName);
        writer.println(" != NULL) {");
        writer.print("    ");
        writer.print("    ");
        writer.print(receivingVarName);
        writer.print(" = (");
        writer.print(receivingVarTypeString);
        writer.print(") (((char*) (*env)->GetDirectBufferAddress(env, ");
        writer.print(sourceVarName);
        writer.println(")) + " + (byteOffsetVarName != null ? byteOffsetVarName : "0") + ");");
        writer.print("    }");
        if (emitElseClause) {
            writer.println(" else {");
            writer.print("      ");
            writer.print(receivingVarName);
            writer.println(" = NULL;");
            writer.println("    }");
        } else {
            writer.println();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean emitPointerDeclaration(PrintWriter writer, JavaType javaType, Type cType, String cVariableName, String javaArgumentName) {
        String ptrTypeString = null;
        boolean needsDataCopy = false;
        if (javaType.isNIOBuffer()) {
            ptrTypeString = cType.getName();
        } else if (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers()) {
            needsDataCopy = this.javaArgTypeNeedsDataCopy(javaType);
            if (javaType.isPrimitiveArray() || javaType.isNIOBufferArray() || javaType.isArrayOfCompoundTypeWrappers()) {
                ptrTypeString = cType.getName();
            } else if (!javaType.isStringArray()) {
                Class<?> elementType = javaType.getJavaClass().getComponentType();
                if (!elementType.isArray()) throw new RuntimeException("Unsupported pointer type: \"" + cType.getName() + "\"");
                Class<?> subElementType = elementType.getComponentType();
                if (!subElementType.isPrimitive()) throw new RuntimeException("Unsupported pointer type: \"" + cType.getName() + "\"");
                ptrTypeString = cType.getName();
            }
        } else {
            ptrTypeString = cType.getName();
        }
        if (!needsDataCopy) {
            writer.print("  ");
            writer.print(ptrTypeString);
            writer.print(" ");
            writer.print(cVariableName);
            writer.println(" = NULL;");
            return needsDataCopy;
        } else {
            if (javaType.isStringArray()) {
                String cElementTypeName = "char *";
                PointerType cPtrType = cType.asPointer();
                if (cPtrType != null) {
                    cElementTypeName = cPtrType.getTargetType().asPointer().getName();
                }
                if (this.isConstPtrPtr(cType)) {
                    writer.print("  const " + cElementTypeName + " *");
                } else {
                    writer.print("  " + cElementTypeName + " *");
                }
            } else if (this.isConstPtrPtr(cType)) {
                writer.print("  const " + ptrTypeString);
            } else {
                writer.print("  " + ptrTypeString);
            }
            writer.print(" ");
            writer.print(cVariableName);
            writer.print("_copy = NULL; /* copy of data in ");
            writer.print(javaArgumentName);
            writer.println(", laid out according to C memory model */");
        }
        return needsDataCopy;
    }

    private void emitPointerConversion(PrintWriter writer, MethodBinding binding, JavaType type, Type cType, String incomingArgumentName, String cVariableName, String byteOffsetVarName) {
        if (type.isCompoundTypeWrapper()) {
            byteOffsetVarName = null;
        }
        this.emitGetDirectBufferAddress(writer, incomingArgumentName, cType.getName(), cVariableName, byteOffsetVarName, false);
    }

    protected String byteOffsetArgName(int i) {
        return this.byteOffsetArgName(this.binding.getArgumentName(i));
    }

    protected String byteOffsetArgName(String s) {
        return s + "_byte_offset";
    }

    protected String byteOffsetArrayArgName(int i) {
        return this.binding.getArgumentName(i) + "_byte_offset_array";
    }

    protected String[] argumentNameArray() {
        String[] argumentNames = new String[this.binding.getNumArguments()];
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            argumentNames[i] = this.binding.getArgumentName(i);
            if (!this.binding.getJavaArgumentType(i).isPrimitiveArray()) continue;
            argumentNames[i] = argumentNames[i] + ", " + this.byteOffsetArgName(i);
        }
        return argumentNames;
    }

    protected String pointerConversionArgumentName(int i) {
        return "_ptr" + i;
    }

    protected boolean javaArgTypeNeedsDataCopy(JavaType javaArgType) {
        if (javaArgType.isArray()) {
            return javaArgType.isNIOBufferArray() || javaArgType.isStringArray() || javaArgType.getJavaClass().getComponentType().isArray();
        }
        return javaArgType.isArrayOfCompoundTypeWrappers();
    }

    protected static class DefaultCommentEmitter
    implements CommentEmitter {
        protected DefaultCommentEmitter() {
        }

        @Override
        public void emit(FunctionEmitter emitter, PrintWriter writer) {
            this.emitBeginning((CMethodBindingEmitter)emitter, writer);
            this.emitEnding((CMethodBindingEmitter)emitter, writer);
        }

        protected void emitBeginning(CMethodBindingEmitter emitter, PrintWriter writer) {
            writer.println("  Java->C glue code:");
            writer.print(" *   Java package: ");
            writer.print(emitter.getJavaPackageName());
            writer.print(".");
            writer.println(emitter.getJavaClassName());
            writer.print(" *    Java method: ");
            MethodBinding binding = emitter.getBinding();
            writer.println(binding);
            writer.println(" *     C function: " + binding.getCSymbol());
        }

        protected void emitEnding(CMethodBindingEmitter emitter, PrintWriter writer) {
        }
    }
}

