/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen;

import com.sun.gluegen.CommentEmitter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class FunctionEmitter {
    public static final EmissionModifier STATIC = new EmissionModifier("static");
    private boolean isInterfaceVal;
    private ArrayList modifiers = new ArrayList();
    private CommentEmitter commentEmitter = null;
    private PrintWriter defaultOutput;

    public FunctionEmitter(PrintWriter defaultOutput, boolean isInterface) {
        assert (defaultOutput != null);
        this.defaultOutput = defaultOutput;
        this.isInterfaceVal = isInterface;
    }

    public FunctionEmitter(FunctionEmitter arg) {
        this.modifiers = (ArrayList)arg.modifiers.clone();
        this.commentEmitter = arg.commentEmitter;
        this.defaultOutput = arg.defaultOutput;
        this.isInterfaceVal = arg.isInterfaceVal;
    }

    public boolean isInterface() {
        return this.isInterfaceVal;
    }

    public PrintWriter getDefaultOutput() {
        return this.defaultOutput;
    }

    public void addModifiers(Iterator mi) {
        while (mi.hasNext()) {
            this.modifiers.add((EmissionModifier)mi.next());
        }
    }

    public void addModifier(EmissionModifier m) {
        this.modifiers.add(m);
    }

    public boolean removeModifier(EmissionModifier m) {
        return this.modifiers.remove(m);
    }

    public void clearModifiers() {
        this.modifiers.clear();
    }

    public boolean hasModifier(EmissionModifier m) {
        return this.modifiers.contains(m);
    }

    public Iterator getModifiers() {
        return this.modifiers.iterator();
    }

    public abstract String getName();

    public void emit(PrintWriter output) {
        this.emitDocComment(output);
        this.emitSignature(output);
        this.emitBody(output);
    }

    public final void emit() {
        this.emit(this.getDefaultOutput());
    }

    public String toString() {
        StringWriter sw = new StringWriter(500);
        PrintWriter w = new PrintWriter(sw);
        this.emit(w);
        return sw.toString();
    }

    public void setCommentEmitter(CommentEmitter cEmitter) {
        this.commentEmitter = cEmitter;
    }

    public CommentEmitter getCommentEmitter() {
        return this.commentEmitter;
    }

    protected void emitDocComment(PrintWriter writer) {
        if (this.commentEmitter != null) {
            writer.print(this.getBaseIndentString());
            writer.print(this.getCommentStartString());
            this.commentEmitter.emit(this, writer);
            writer.print(this.getBaseIndentString());
            writer.println(this.getCommentEndString());
        }
    }

    protected void emitSignature(PrintWriter writer) {
        writer.print(this.getBaseIndentString());
        int numEmitted = this.emitModifiers(writer);
        if (numEmitted > 0) {
            writer.print(" ");
        }
        this.emitReturnType(writer);
        writer.print(" ");
        this.emitName(writer);
        writer.print("(");
        this.emitArguments(writer);
        writer.print(")");
    }

    protected int emitModifiers(PrintWriter writer) {
        PrintWriter w = this.getDefaultOutput();
        int numEmitted = 0;
        Iterator it = this.getModifiers();
        while (it.hasNext()) {
            writer.print(it.next());
            ++numEmitted;
            if (!it.hasNext()) continue;
            writer.print(" ");
        }
        return numEmitted;
    }

    protected String getBaseIndentString() {
        return "";
    }

    protected String getCommentStartString() {
        return "/* ";
    }

    protected String getCommentEndString() {
        return " */";
    }

    protected abstract void emitReturnType(PrintWriter var1);

    protected abstract void emitName(PrintWriter var1);

    protected abstract int emitArguments(PrintWriter var1);

    protected abstract void emitBody(PrintWriter var1);

    public static class EmissionModifier {
        private String emittedForm;

        public final String toString() {
            return this.emittedForm;
        }

        public int hashCode() {
            return this.emittedForm.hashCode();
        }

        public boolean equals(Object arg) {
            if (arg == null || !(arg instanceof EmissionModifier)) {
                return false;
            }
            return this.emittedForm.equals(((EmissionModifier)arg).emittedForm);
        }

        protected EmissionModifier(String emittedForm) {
            this.emittedForm = emittedForm;
        }
    }
}

