/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen;

import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import com.sun.gluegen.ConstantDefinition;
import com.sun.gluegen.GlueEmitter;
import com.sun.gluegen.GlueEmitterControls;
import com.sun.gluegen.JavaEmitter;
import com.sun.gluegen.ReferencedStructs;
import com.sun.gluegen.SymbolFilter;
import com.sun.gluegen.cgram.CToken;
import com.sun.gluegen.cgram.Define;
import com.sun.gluegen.cgram.GNUCTokenTypes;
import com.sun.gluegen.cgram.GnuCLexer;
import com.sun.gluegen.cgram.GnuCParser;
import com.sun.gluegen.cgram.HeaderParser;
import com.sun.gluegen.cgram.TNode;
import com.sun.gluegen.cgram.types.CompoundType;
import com.sun.gluegen.cgram.types.EnumType;
import com.sun.gluegen.cgram.types.FunctionSymbol;
import com.sun.gluegen.cgram.types.MachineDescription;
import com.sun.gluegen.cgram.types.MachineDescription32Bit;
import com.sun.gluegen.cgram.types.MachineDescription64Bit;
import com.sun.gluegen.cgram.types.PointerType;
import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.cgram.types.TypeDictionary;
import com.sun.gluegen.cgram.types.TypeVisitor;
import com.sun.gluegen.pcpp.PCPP;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GlueGen
implements GlueEmitterControls {
    private List forcedStructNames = new ArrayList();
    private PCPP preprocessor;
    private List constants;
    private List functions;

    @Override
    public void forceStructEmission(String typedefName) {
        this.forcedStructNames.add(typedefName);
    }

    @Override
    public String findHeaderFile(String headerFileName) {
        return this.preprocessor.findFile(headerFileName);
    }

    @Override
    public void runSymbolFilter(SymbolFilter filter) {
        filter.filterSymbols(this.constants, this.functions);
        List newConstants = filter.getConstants();
        List newFunctions = filter.getFunctions();
        if (newConstants != null) {
            this.constants = newConstants;
        }
        if (newFunctions != null) {
            this.functions = newFunctions;
        }
    }

    public void run(String[] args) {
        try {
            CompoundType c;
            PointerType p;
            JavaEmitter jemit;
            Reader reader = null;
            String filename = null;
            String emitterClass = null;
            String outputRootDir = null;
            ArrayList<String> cfgFiles = new ArrayList<String>();
            if (args.length == 0) {
                GlueGen.usage();
            }
            ArrayList<String> includePaths = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                String arg;
                if (i < args.length - 1) {
                    arg = args[i];
                    if (arg.startsWith("-I")) {
                        String[] paths = arg.substring(2).split(System.getProperty("path.separator"));
                        for (int j = 0; j < paths.length; ++j) {
                            includePaths.add(paths[j]);
                        }
                        continue;
                    }
                    if (arg.startsWith("-O")) {
                        outputRootDir = arg.substring(2);
                        continue;
                    }
                    if (arg.startsWith("-E")) {
                        emitterClass = arg.substring(2);
                        continue;
                    }
                    if (arg.startsWith("-C")) {
                        cfgFiles.add(arg.substring(2));
                        continue;
                    }
                    GlueGen.usage();
                    continue;
                }
                arg = args[i];
                if (arg.equals("-")) {
                    reader = new InputStreamReader(System.in);
                    filename = "standard input";
                    continue;
                }
                if (arg.startsWith("-")) {
                    GlueGen.usage();
                }
                filename = arg;
                reader = new BufferedReader(new FileReader(filename));
            }
            this.preprocessor = new PCPP(includePaths);
            PipedInputStream ppIn = new PipedInputStream();
            final PipedOutputStream ppOut = new PipedOutputStream(ppIn);
            this.preprocessor.setOut(ppOut);
            final InputStreamReader rdr = reader;
            final String fn = filename;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        GlueGen.this.preprocessor.run(rdr, fn);
                        ppOut.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            DataInputStream dis = new DataInputStream(ppIn);
            GnuCLexer lexer = new GnuCLexer((InputStream)dis);
            lexer.setTokenObjectClass(CToken.class.getName());
            lexer.initialize();
            GnuCParser parser = new GnuCParser((TokenStream)lexer);
            parser.setASTNodeType(TNode.class.getName());
            TNode.setTokenVocabulary((String)GNUCTokenTypes.class.getName());
            try {
                parser.translationUnit();
            }
            catch (RecognitionException e) {
                System.err.println("Fatal IO error:\n" + (Object)((Object)e));
                System.exit(1);
            }
            catch (TokenStreamException e) {
                System.err.println("Fatal IO error:\n" + (Object)((Object)e));
                System.exit(1);
            }
            HeaderParser headerParser = new HeaderParser();
            TypeDictionary td = new TypeDictionary();
            headerParser.setTypedefDictionary(td);
            TypeDictionary sd = new TypeDictionary();
            headerParser.setStructDictionary(sd);
            headerParser.setASTNodeType(TNode.class.getName());
            headerParser.translationUnit(parser.getAST());
            GlueEmitter emit = null;
            if (emitterClass == null) {
                emit = new JavaEmitter();
            } else {
                try {
                    emit = (GlueEmitter)Class.forName(emitterClass).newInstance();
                }
                catch (Exception e) {
                    System.err.println("Exception occurred while instantiating emitter class. Exiting.");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            Iterator iter = cfgFiles.iterator();
            while (iter.hasNext()) {
                emit.readConfigurationFile((String)iter.next());
            }
            if (null != outputRootDir && outputRootDir.trim().length() > 0 && emit instanceof JavaEmitter && null != (jemit = (JavaEmitter)emit).getConfig()) {
                jemit.getConfig().setOutputRootDir(outputRootDir);
            }
            MachineDescription32Bit md32 = new MachineDescription32Bit();
            MachineDescription64Bit md64 = new MachineDescription64Bit();
            emit.setMachineDescription((MachineDescription)md32, (MachineDescription)md64);
            this.constants = new ArrayList();
            for (EnumType enumeration : headerParser.getEnums()) {
                String enumName = enumeration.getName();
                if (enumName.equals("<anonymous>")) {
                    enumName = null;
                }
                for (int i = 0; i < enumeration.getNumEnumerates(); ++i) {
                    String enumElementName = enumeration.getEnumName(i);
                    String value = String.valueOf(enumeration.getEnumValue(i));
                    this.constants.add(new ConstantDefinition(enumElementName, value, true, enumName));
                }
            }
            for (Define def : lexer.getDefines()) {
                this.constants.add(new ConstantDefinition(def.getName(), def.getValue(), false, null));
            }
            this.functions = headerParser.getParsedFunctions();
            emit.beginEmission(this);
            emit.beginDefines();
            HashSet<String> emittedDefines = new HashSet<String>(100);
            for (ConstantDefinition def : this.constants) {
                if (emittedDefines.contains(def.getName())) continue;
                emittedDefines.add(def.getName());
                String comment = null;
                Set aliases = def.getAliases();
                if (aliases != null) {
                    comment = "Alias for: <code>";
                    for (String alias : aliases) {
                        comment = comment + " " + alias;
                    }
                    comment = comment + "</code>";
                }
                if (def.getEnumName() != null) {
                    String enumName = "Defined as part of enum type \"" + def.getEnumName() + "\"";
                    comment = comment == null ? enumName : comment + "<br>\n" + enumName;
                }
                emit.emitDefine(def, comment);
            }
            emit.endDefines();
            ReferencedStructs referencedStructs = new ReferencedStructs();
            for (FunctionSymbol sym : this.functions) {
                sym.getType().visit((TypeVisitor)referencedStructs);
            }
            for (String name : this.forcedStructNames) {
                Type type = td.get(name);
                if (type == null) {
                    System.err.println("WARNING: during forced struct emission: struct \"" + name + "\" not found");
                    continue;
                }
                if (!type.isCompound()) {
                    System.err.println("WARNING: during forced struct emission: type \"" + name + "\" was not a struct");
                    continue;
                }
                type.visit((TypeVisitor)referencedStructs);
            }
            emit.beginStructLayout();
            Iterator iter2 = referencedStructs.results();
            while (iter2.hasNext()) {
                Type t = (Type)iter2.next();
                if (t.isCompound()) {
                    emit.layoutStruct(t.asCompound());
                    continue;
                }
                if (!t.isPointer()) continue;
                p = t.asPointer();
                c = p.getTargetType().asCompound();
                emit.layoutStruct(c);
            }
            emit.endStructLayout();
            emit.beginStructs(td, sd, headerParser.getCanonMap());
            iter2 = referencedStructs.results();
            while (iter2.hasNext()) {
                Type t = (Type)iter2.next();
                if (t.isCompound()) {
                    emit.emitStruct(t.asCompound(), null);
                    continue;
                }
                if (!t.isPointer()) continue;
                p = t.asPointer();
                c = p.getTargetType().asCompound();
                assert (p.hasTypedefedName() && c.getName() == null) : "ReferencedStructs incorrectly recorded pointer type " + p;
                emit.emitStruct(c, p.getName());
            }
            emit.endStructs();
            emit.beginFunctions(td, sd, headerParser.getCanonMap());
            emit.emitFunctions(this.functions);
            emit.endFunctions();
            emit.endEmission();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Exception occurred while generating glue code. Exiting.");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        new GlueGen().run(args);
    }

    private static void usage() {
        System.out.println("Usage: java GlueGen [-I...] [-Eemitter_class_name] [-Ccfg_file_name...] <filename | ->");
        System.out.println();
        System.out.println("Runs C header parser on input file or standard input, first");
        System.out.println("passing input through minimal pseudo-C-preprocessor. Use -I");
        System.out.println("command-line arguments to specify the search path for #includes.");
        System.out.println("Emitter class name can be specified with -E option: i.e.,");
        System.out.println("-Ecom.sun.gluegen.JavaEmitter (the default). Use");
        System.out.println("-Ecom.sun.gluegen.DebugEmitter to print recognized entities");
        System.out.println("(#define directives to constant numbers, typedefs, and function");
        System.out.println("declarations) to standard output. Emitter-specific configuration");
        System.out.println("file or files can be specified with -C option; e.g,");
        System.out.println("-Cjava-emitter.cfg.");
        System.exit(1);
    }
}

