/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen;

import antlr.TokenStream;
import com.sun.gluegen.JavaType;
import com.sun.gluegen.MethodBinding;
import com.sun.gluegen.TypeInfo;
import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.cgram.types.TypeDictionary;
import com.sun.gluegen.jgram.JavaLexer;
import com.sun.gluegen.jgram.JavaParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaConfiguration {
    private int nestedReads;
    private String packageName;
    private String implPackageName;
    private String className;
    private String implClassName;
    private String javaOutputDir = ".";
    private String outputRootDir = null;
    private String nativeOutputDir = ".";
    private boolean nativeOutputUsesJavaHierarchy;
    private boolean tagNativeBinding;
    private int emissionStyle = 1;
    private List imports = new ArrayList();
    private String gluegenRuntimePackage = "com.sun.gluegen.runtime";
    private String runtimeExceptionType = "RuntimeException";
    private String unsupportedExceptionType = "UnsupportedOperationException";
    private Map accessControl = new HashMap();
    private Map typeInfoMap = new HashMap();
    private Set returnsString = new HashSet();
    private Map returnedArrayLengths = new HashMap();
    private Map argumentsAreString = new HashMap();
    private Set extendedIntfSymbolsIgnore = new HashSet();
    private Set extendedIntfSymbolsOnly = new HashSet();
    private Set ignores = new HashSet();
    private Map ignoreMap = new HashMap();
    private Set ignoreNots = new HashSet();
    private Set unignores = new HashSet();
    private Set unimplemented = new HashSet();
    private boolean forceNioOnly4All = false;
    private Set nioOnly = new HashSet();
    private boolean forceNioDirectOnly4All = false;
    private Set nioDirectOnly = new HashSet();
    private Set manuallyImplement = new HashSet();
    private Map customJavaCode = new HashMap();
    private Map classJavadoc = new HashMap();
    private Map structPackages = new HashMap();
    private List customCCode = new ArrayList();
    private List forcedStructs = new ArrayList();
    private Map returnValueCapacities = new HashMap();
    private Map returnValueLengths = new HashMap();
    private Map temporaryCVariableDeclarations = new HashMap();
    private Map temporaryCVariableAssignments = new HashMap();
    private Map extendedInterfaces = new HashMap();
    private Map implementedInterfaces = new HashMap();
    private Map parentClass = new HashMap();
    private Map javaTypeRenames = new HashMap();
    private Map javaSymbolRenames = new HashMap();
    private Map javaPrologues = new HashMap();
    private Map javaEpilogues = new HashMap();
    private static final boolean DEBUG_TYPE_INFO = false;
    public static final boolean DEBUG_IGNORES = false;
    public static boolean dumpedIgnores = false;

    public final void read(String filename) throws IOException {
        this.read(filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void read(String filename, String linePrefix) throws IOException {
        File file = new File(filename);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException("Could not read file \"" + file + "\"", fnfe);
        }
        int lineNo = 0;
        String line = null;
        boolean hasPrefix = linePrefix != null && linePrefix.length() > 0;
        try {
            ++this.nestedReads;
            while ((line = reader.readLine()) != null) {
                StringTokenizer tok;
                ++lineNo;
                if (hasPrefix) {
                    line = linePrefix + " " + line;
                }
                if (line.trim().startsWith("#") || !(tok = new StringTokenizer(line)).hasMoreTokens()) continue;
                String cmd = tok.nextToken(" \t\n\r\f");
                this.dispatch(cmd, tok, file, filename, lineNo);
            }
            reader.close();
        }
        finally {
            --this.nestedReads;
        }
        if (this.nestedReads == 0) {
            if (this.allStatic() && this.implClassName != null) {
                throw new IllegalStateException("Error in configuration file \"" + filename + "\": Cannot use " + "directive \"ImplJavaClass\" in conjunction with " + "\"Style AllStatic\"");
            }
            if (this.className == null && this.emissionStyle() != 4) {
                throw new RuntimeException("Output class name was not specified in configuration file \"" + filename + "\"");
            }
            if (this.packageName == null && this.emissionStyle() != 4) {
                throw new RuntimeException("Output package name was not specified in configuration file \"" + filename + "\"");
            }
            if (this.allStatic()) {
                this.implClassName = this.className;
                this.implPackageName = this.packageName;
            } else {
                if (this.implClassName == null) {
                    if (this.className == null) {
                        throw new RuntimeException("If ImplJavaClass is not specified, must specify JavaClass");
                    }
                    this.implClassName = this.className + "Impl";
                }
                if (this.implPackageName == null) {
                    if (this.packageName == null) {
                        throw new RuntimeException("If ImplPackageName is not specified, must specify PackageName");
                    }
                    this.implPackageName = this.packageName + ".impl";
                }
            }
        }
    }

    public void setOutputRootDir(String s) {
        this.outputRootDir = s;
    }

    public String packageName() {
        return this.packageName;
    }

    public String implPackageName() {
        return this.implPackageName;
    }

    public String className() {
        return this.className;
    }

    public String implClassName() {
        return this.implClassName;
    }

    public String javaOutputDir() {
        return null != this.outputRootDir ? this.outputRootDir + "/" + this.javaOutputDir : this.javaOutputDir;
    }

    public String nativeOutputDir() {
        return null != this.outputRootDir ? this.outputRootDir + "/" + this.nativeOutputDir : this.nativeOutputDir;
    }

    public boolean nativeOutputUsesJavaHierarchy() {
        return this.nativeOutputUsesJavaHierarchy;
    }

    public boolean tagNativeBinding() {
        return this.tagNativeBinding;
    }

    public int emissionStyle() {
        return this.emissionStyle;
    }

    public int accessControl(String methodName) {
        Integer ret = (Integer)this.accessControl.get(methodName);
        if (ret != null) {
            return ret;
        }
        return 1;
    }

    public String gluegenRuntimePackage() {
        return this.gluegenRuntimePackage;
    }

    public String runtimeExceptionType() {
        return this.runtimeExceptionType;
    }

    public String unsupportedExceptionType() {
        return this.unsupportedExceptionType;
    }

    public List imports() {
        return this.imports;
    }

    public TypeInfo typeInfo(Type type, TypeDictionary typedefDictionary) {
        int pointerDepth = type.pointerDepth();
        for (int i = 0; i <= pointerDepth; ++i) {
            TypeInfo info;
            String name = type.getName();
            if (name != null && (info = this.closestTypeInfo(name, i + type.pointerDepth())) != null) {
                return this.promoteTypeInfo(info, i);
            }
            if (type.isCompound() && (name = type.asCompound().getStructName()) != null && (info = this.closestTypeInfo(name, i + type.pointerDepth())) != null) {
                return this.promoteTypeInfo(info, i);
            }
            Set entrySet = typedefDictionary.entrySet();
            for (Map.Entry entry : entrySet) {
                TypeInfo info2;
                if (entry.getValue() != type || (info2 = this.closestTypeInfo(name = (String)entry.getKey(), i + type.pointerDepth())) == null) continue;
                return this.promoteTypeInfo(info2, i);
            }
            if (!type.isPointer()) continue;
            type = type.asPointer().getTargetType();
        }
        return null;
    }

    private TypeInfo closestTypeInfo(String name, int pointerDepth) {
        TypeInfo closest = null;
        for (TypeInfo info = (TypeInfo)this.typeInfoMap.get(name); info != null; info = info.next()) {
            if (info.pointerDepth() > pointerDepth || closest != null && info.pointerDepth() <= closest.pointerDepth()) continue;
            closest = info;
        }
        return closest;
    }

    private TypeInfo promoteTypeInfo(TypeInfo info, int numPointersStripped) {
        int diff = numPointersStripped - info.pointerDepth();
        if (diff == 0) {
            return info;
        }
        if (diff < 0) {
            throw new RuntimeException("TypeInfo for " + info.name() + " and pointerDepth " + info.pointerDepth() + " should not have matched for depth " + numPointersStripped);
        }
        Class<?> c = info.javaType().getJavaClass();
        int pd = info.pointerDepth();
        if (diff == 1) {
            JavaType jt = null;
            if (c == Boolean.TYPE) {
                jt = JavaType.createForCCharPointer();
            } else if (c == Byte.TYPE) {
                jt = JavaType.createForCCharPointer();
            } else if (c == Short.TYPE) {
                jt = JavaType.createForCShortPointer();
            } else if (c == Integer.TYPE) {
                jt = JavaType.createForCInt32Pointer();
            } else if (c == Long.TYPE) {
                jt = JavaType.createForCInt64Pointer();
            } else if (c == Float.TYPE) {
                jt = JavaType.createForCFloatPointer();
            } else if (c == Double.TYPE) {
                jt = JavaType.createForCDoublePointer();
            }
            if (jt != null) {
                return new TypeInfo(info.name(), pd + numPointersStripped, jt);
            }
        }
        while (diff > 0) {
            c = Array.newInstance(c, 0).getClass();
            --diff;
        }
        return new TypeInfo(info.name(), numPointersStripped, JavaType.createForClass(c));
    }

    public boolean returnsString(String functionName) {
        return this.returnsString.contains(functionName);
    }

    public String returnedArrayLength(String functionName) {
        return (String)this.returnedArrayLengths.get(functionName);
    }

    public List stringArguments(String functionName) {
        return (List)this.argumentsAreString.get(functionName);
    }

    public boolean isForceNioOnly4All() {
        return this.forceNioOnly4All;
    }

    public void addNioOnly(String fname) {
        this.nioOnly.add(fname);
    }

    public boolean nioOnly(String functionName) {
        return this.forceNioOnly4All || this.nioOnly.contains(functionName);
    }

    public boolean isForceNioDirectOnly4All() {
        return this.forceNioDirectOnly4All;
    }

    public void addNioDirectOnly(String fname) {
        this.nioDirectOnly.add(fname);
    }

    public boolean nioDirectOnly(String functionName) {
        return this.forceNioDirectOnly4All || this.nioDirectOnly.contains(functionName);
    }

    public boolean manuallyImplement(String functionName) {
        return this.manuallyImplement.contains(functionName);
    }

    public List customJavaCodeForClass(String className) {
        ArrayList res = (ArrayList)this.customJavaCode.get(className);
        if (res == null) {
            res = new ArrayList();
            this.customJavaCode.put(className, res);
        }
        return res;
    }

    public List javadocForClass(String className) {
        ArrayList res = (ArrayList)this.classJavadoc.get(className);
        if (res == null) {
            res = new ArrayList();
            this.classJavadoc.put(className, res);
        }
        return res;
    }

    public String packageForStruct(String structName) {
        String res = (String)this.structPackages.get(structName);
        if (res == null) {
            res = this.packageName;
        }
        return res;
    }

    public List customCCode() {
        return this.customCCode;
    }

    public List forcedStructs() {
        return this.forcedStructs;
    }

    public String returnValueCapacity(String functionName) {
        return (String)this.returnValueCapacities.get(functionName);
    }

    public String returnValueLength(String functionName) {
        return (String)this.returnValueLengths.get(functionName);
    }

    public List temporaryCVariableDeclarations(String functionName) {
        return (List)this.temporaryCVariableDeclarations.get(functionName);
    }

    public List temporaryCVariableAssignments(String functionName) {
        return (List)this.temporaryCVariableAssignments.get(functionName);
    }

    public List extendedInterfaces(String interfaceName) {
        ArrayList res = (ArrayList)this.extendedInterfaces.get(interfaceName);
        if (res == null) {
            res = new ArrayList();
            this.extendedInterfaces.put(interfaceName, res);
        }
        return res;
    }

    public List implementedInterfaces(String className) {
        ArrayList res = (ArrayList)this.implementedInterfaces.get(className);
        if (res == null) {
            res = new ArrayList();
            this.implementedInterfaces.put(className, res);
        }
        return res;
    }

    public String extendedParentClass(String className) {
        return (String)this.parentClass.get(className);
    }

    public void dumpIgnoresOnce() {
        if (!dumpedIgnores) {
            dumpedIgnores = true;
            this.dumpIgnores();
        }
    }

    public void dumpIgnores() {
        System.err.println("Extended Intf: ");
        Iterator iter = this.extendedIntfSymbolsIgnore.iterator();
        while (iter.hasNext()) {
            System.err.println("\t" + (String)iter.next());
        }
        System.err.println("Ignores (All): ");
        iter = this.ignores.iterator();
        while (iter.hasNext()) {
            System.err.println("\t" + iter.next());
        }
    }

    public void dumpRenames() {
        System.err.println("Symbol Renames: ");
        for (String key : this.javaSymbolRenames.keySet()) {
            System.err.println("\t" + key + " -> " + this.javaSymbolRenames.get(key));
        }
    }

    public boolean shouldIgnoreInInterface(String symbol) {
        if (this.extendedIntfSymbolsIgnore.contains(symbol) || this.extendedIntfSymbolsIgnore.contains(this.getJavaSymbolRename(symbol))) {
            return true;
        }
        return this.shouldIgnoreInImpl_Int(symbol);
    }

    public boolean shouldIgnoreInImpl(String symbol) {
        return this.shouldIgnoreInImpl_Int(symbol);
    }

    private boolean shouldIgnoreInImpl_Int(String symbol) {
        Matcher matcher;
        if (!(this.extendedIntfSymbolsOnly.isEmpty() || this.extendedIntfSymbolsOnly.contains(symbol) || this.extendedIntfSymbolsOnly.contains(this.getJavaSymbolRename(symbol)))) {
            return true;
        }
        if (this.ignores.contains(symbol)) {
            return true;
        }
        for (Pattern regexp : this.ignores) {
            matcher = regexp.matcher(symbol);
            if (!matcher.matches()) continue;
            return true;
        }
        if (this.ignoreNots.size() > 0) {
            for (Pattern regexp : this.ignoreNots) {
                matcher = regexp.matcher(symbol);
                if (matcher.matches()) continue;
                if (this.unignores.size() == 0) {
                    return true;
                }
                boolean unignoreFound = false;
                for (Pattern unignoreRegexp : this.unignores) {
                    Matcher unignoreMatcher = unignoreRegexp.matcher(symbol);
                    if (!unignoreMatcher.matches()) continue;
                    unignoreFound = true;
                    break;
                }
                if (!unignoreFound) {
                    // empty if block
                }
                return true;
            }
        }
        return false;
    }

    public boolean isUnimplemented(String symbol) {
        if (this.unimplemented.contains(symbol)) {
            return true;
        }
        for (Pattern regexp : this.unimplemented) {
            Matcher matcher = regexp.matcher(symbol);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public String renameJavaType(String javaTypeName) {
        String rename = (String)this.javaTypeRenames.get(javaTypeName);
        if (rename != null) {
            return rename;
        }
        return javaTypeName;
    }

    public String getJavaSymbolRename(String symbolName) {
        return (String)this.javaSymbolRenames.get(symbolName);
    }

    public void addJavaSymbolRename(String origName, String newName) {
        this.javaSymbolRenames.put(origName, newName);
    }

    public boolean allStatic() {
        return this.emissionStyle == 1;
    }

    public boolean emitInterface() {
        return this.emissionStyle() == 2 || this.emissionStyle() == 3;
    }

    public boolean emitImpl() {
        return this.emissionStyle() == 1 || this.emissionStyle() == 2 || this.emissionStyle() == 4;
    }

    public List javaPrologueForMethod(MethodBinding binding, boolean forImplementingMethodCall, boolean eraseBufferAndArrayTypes) {
        List res = (List)this.javaPrologues.get(binding.getName());
        if (res == null) {
            res = (List)this.javaPrologues.get(binding.getName() + binding.getDescriptor(forImplementingMethodCall, eraseBufferAndArrayTypes));
        }
        return res;
    }

    public List javaEpilogueForMethod(MethodBinding binding, boolean forImplementingMethodCall, boolean eraseBufferAndArrayTypes) {
        List res = (List)this.javaEpilogues.get(binding.getName());
        if (res == null) {
            res = (List)this.javaEpilogues.get(binding.getName() + binding.getDescriptor(forImplementingMethodCall, eraseBufferAndArrayTypes));
        }
        return res;
    }

    protected void dispatch(String cmd, StringTokenizer tok, File file, String filename, int lineNo) throws IOException {
        if (cmd.equalsIgnoreCase("Package")) {
            this.packageName = this.readString("package", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("GlueGenRuntimePackage")) {
            this.gluegenRuntimePackage = this.readString("GlueGenRuntimePackage", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ImplPackage")) {
            this.implPackageName = this.readString("ImplPackage", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("JavaClass")) {
            this.className = this.readString("JavaClass", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ImplJavaClass")) {
            this.implClassName = this.readString("ImplJavaClass", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("JavaOutputDir")) {
            this.javaOutputDir = this.readString("JavaOutputDir", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("NativeOutputDir")) {
            this.nativeOutputDir = this.readString("NativeOutputDir", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("HierarchicalNativeOutput")) {
            String tmp = this.readString("HierarchicalNativeOutput", tok, filename, lineNo);
            this.nativeOutputUsesJavaHierarchy = Boolean.valueOf(tmp);
        } else if (cmd.equalsIgnoreCase("TagNativeBinding")) {
            this.tagNativeBinding = this.readBoolean("TagNativeBinding", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("Style")) {
            String style = this.readString("Style", tok, filename, lineNo);
            if (style.equalsIgnoreCase("AllStatic")) {
                this.emissionStyle = 1;
            } else if (style.equalsIgnoreCase("InterfaceAndImpl")) {
                this.emissionStyle = 2;
            } else if (style.equalsIgnoreCase("InterfaceOnly")) {
                this.emissionStyle = 3;
            } else if (style.equalsIgnoreCase("ImplOnly")) {
                this.emissionStyle = 4;
            } else {
                System.err.println("WARNING: Error parsing \"style\" command at line " + lineNo + " in file \"" + filename + "\"");
            }
        } else if (cmd.equalsIgnoreCase("AccessControl")) {
            this.readAccessControl(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("Import")) {
            this.imports.add(this.readString("Import", tok, filename, lineNo));
        } else if (cmd.equalsIgnoreCase("Opaque")) {
            this.readOpaque(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ReturnsString")) {
            this.readReturnsString(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ReturnedArrayLength")) {
            this.readReturnedArrayLength(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ArgumentIsString")) {
            this.readArgumentIsString(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ExtendedInterfaceSymbolsIgnore")) {
            this.readExtendedInterfaceSymbols(tok, filename, lineNo, false);
        } else if (cmd.equalsIgnoreCase("ExtendedInterfaceSymbolsOnly")) {
            this.readExtendedInterfaceSymbols(tok, filename, lineNo, true);
        } else if (cmd.equalsIgnoreCase("Ignore")) {
            this.readIgnore(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("Unignore")) {
            this.readUnignore(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("IgnoreNot")) {
            this.readIgnoreNot(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("Unimplemented")) {
            this.readUnimplemented(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("IgnoreField")) {
            this.readIgnoreField(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ManuallyImplement")) {
            this.readManuallyImplement(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("CustomJavaCode")) {
            this.readCustomJavaCode(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("CustomCCode")) {
            this.readCustomCCode(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ClassJavadoc")) {
            this.readClassJavadoc(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("NioOnly")) {
            String funcName = this.readString("NioOnly", tok, filename, lineNo);
            if (funcName.equals("__ALL__")) {
                this.forceNioOnly4All = true;
            } else {
                this.addNioOnly(funcName);
            }
        } else if (cmd.equalsIgnoreCase("NioDirectOnly")) {
            String funcName = this.readString("NioDirectOnly", tok, filename, lineNo);
            if (funcName.equals("__ALL__")) {
                this.forceNioDirectOnly4All = true;
            } else {
                this.addNioDirectOnly(funcName);
            }
        } else if (cmd.equalsIgnoreCase("EmitStruct")) {
            this.forcedStructs.add(this.readString("EmitStruct", tok, filename, lineNo));
        } else if (cmd.equalsIgnoreCase("StructPackage")) {
            this.readStructPackage(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("TemporaryCVariableDeclaration")) {
            this.readTemporaryCVariableDeclaration(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("TemporaryCVariableAssignment")) {
            this.readTemporaryCVariableAssignment(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ReturnValueCapacity")) {
            this.readReturnValueCapacity(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ReturnValueLength")) {
            this.readReturnValueLength(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("Include")) {
            this.doInclude(tok, file, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("IncludeAs")) {
            this.doIncludeAs(tok, file, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("Extends")) {
            this.readExtend(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("Implements")) {
            this.readImplements(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ParentClass")) {
            this.readParentClass(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("RenameJavaType")) {
            this.readRenameJavaType(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("RenameJavaSymbol") || cmd.equalsIgnoreCase("RenameJavaMethod")) {
            this.readRenameJavaSymbol(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("RuntimeExceptionType")) {
            this.runtimeExceptionType = this.readString("RuntimeExceptionType", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("UnsupportedExceptionType")) {
            this.unsupportedExceptionType = this.readString("UnsupportedExceptionType", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("JavaPrologue")) {
            this.readJavaPrologueOrEpilogue(tok, filename, lineNo, true);
        } else if (cmd.equalsIgnoreCase("JavaEpilogue")) {
            this.readJavaPrologueOrEpilogue(tok, filename, lineNo, false);
        } else if (cmd.equalsIgnoreCase("RangeCheck")) {
            this.readRangeCheck(tok, filename, lineNo, false);
        } else if (cmd.equalsIgnoreCase("RangeCheckBytes")) {
            this.readRangeCheck(tok, filename, lineNo, true);
        } else {
            throw new RuntimeException("Unknown command \"" + cmd + "\" in command file " + filename + " at line number " + lineNo);
        }
    }

    protected String readString(String cmd, StringTokenizer tok, String filename, int lineNo) {
        try {
            return tok.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"" + cmd + "\" command at line " + lineNo + " in file \"" + filename + "\": missing expected parameter", e);
        }
    }

    protected Boolean readBoolean(String cmd, StringTokenizer tok, String filename, int lineNo) {
        try {
            return Boolean.valueOf(tok.nextToken());
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"" + cmd + "\" command at line " + lineNo + " in file \"" + filename + "\": missing expected boolean value", e);
        }
    }

    protected Class stringToPrimitiveType(String type) throws ClassNotFoundException {
        if (type.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("byte")) {
            return Byte.TYPE;
        }
        if (type.equals("char")) {
            return Character.TYPE;
        }
        if (type.equals("short")) {
            return Short.TYPE;
        }
        if (type.equals("int")) {
            return Integer.TYPE;
        }
        if (type.equals("long")) {
            return Long.TYPE;
        }
        if (type.equals("float")) {
            return Float.TYPE;
        }
        if (type.equals("double")) {
            return Double.TYPE;
        }
        throw new RuntimeException("Only primitive types are supported here");
    }

    protected void readAccessControl(StringTokenizer tok, String filename, int lineNo) {
        try {
            String methodName = tok.nextToken();
            String style = tok.nextToken();
            int acc = 0;
            if (style.equalsIgnoreCase("PUBLIC")) {
                acc = 1;
            } else if (style.equalsIgnoreCase("PROTECTED")) {
                acc = 2;
            } else if (style.equalsIgnoreCase("PRIVATE")) {
                acc = 3;
            } else if (style.equalsIgnoreCase("PACKAGE_PRIVATE")) {
                acc = 4;
            } else if (style.equalsIgnoreCase("PUBLIC_ABSTRACT")) {
                acc = 5;
            } else {
                throw new RuntimeException("Error parsing \"AccessControl\" command at line " + lineNo + " in file \"" + filename + "\"");
            }
            this.accessControl.put(methodName, new Integer(acc));
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing \"AccessControl\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readOpaque(StringTokenizer tok, String filename, int lineNo) {
        try {
            JavaType javaType = JavaType.createForClass(this.stringToPrimitiveType(tok.nextToken()));
            String cType = null;
            while (tok.hasMoreTokens()) {
                if (cType == null) {
                    cType = tok.nextToken();
                    continue;
                }
                cType = cType + " " + tok.nextToken();
            }
            if (cType == null) {
                throw new RuntimeException("No C type for \"Opaque\" command at line " + lineNo + " in file \"" + filename + "\"");
            }
            TypeInfo info = JavaConfiguration.parseTypeInfo(cType, javaType);
            this.addTypeInfo(info);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing \"Opaque\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readReturnsString(StringTokenizer tok, String filename, int lineNo) {
        try {
            String name = tok.nextToken();
            this.returnsString.add(name);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"ReturnsString\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readReturnedArrayLength(StringTokenizer tok, String filename, int lineNo) {
        try {
            String functionName = tok.nextToken();
            String restOfLine = tok.nextToken("\n\r\f");
            restOfLine = restOfLine.trim();
            this.returnedArrayLengths.put(functionName, restOfLine);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"ReturnedArrayLength\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readExtendedInterfaceSymbols(StringTokenizer tok, String filename, int lineNo, boolean onlyList) {
        BufferedReader javaReader;
        File javaFile;
        try {
            javaFile = new File(tok.nextToken());
            javaReader = new BufferedReader(new FileReader(javaFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        JavaLexer lexer = new JavaLexer((Reader)javaReader);
        lexer.setFilename(javaFile.getName());
        JavaParser parser = new JavaParser((TokenStream)lexer);
        parser.setFilename(javaFile.getName());
        try {
            parser.compilationUnit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (onlyList) {
            this.extendedIntfSymbolsOnly.addAll(parser.getParsedEnumNames());
            this.extendedIntfSymbolsOnly.addAll(parser.getParsedFunctionNames());
        } else {
            this.extendedIntfSymbolsIgnore.addAll(parser.getParsedEnumNames());
            this.extendedIntfSymbolsIgnore.addAll(parser.getParsedFunctionNames());
        }
    }

    protected void readIgnore(StringTokenizer tok, String filename, int lineNo) {
        try {
            String regex = tok.nextToken();
            Pattern pattern = Pattern.compile(regex);
            this.ignores.add(pattern);
            this.ignoreMap.put(regex, pattern);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"Ignore\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readUnignore(StringTokenizer tok, String filename, int lineNo) {
        try {
            String regex = tok.nextToken();
            Pattern pattern = (Pattern)this.ignoreMap.get(regex);
            this.ignoreMap.remove(regex);
            this.ignores.remove(pattern);
            if (pattern == null) {
                pattern = Pattern.compile(regex);
            }
            this.unignores.add(pattern);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"Unignore\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readIgnoreNot(StringTokenizer tok, String filename, int lineNo) {
        try {
            String regex = tok.nextToken();
            this.ignoreNots.add(Pattern.compile(regex));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"IgnoreNot\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readUnimplemented(StringTokenizer tok, String filename, int lineNo) {
        try {
            String regex = tok.nextToken();
            this.unimplemented.add(Pattern.compile(regex));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"Unimplemented\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readIgnoreField(StringTokenizer tok, String filename, int lineNo) {
        try {
            String containingStruct = tok.nextToken();
            String name = tok.nextToken();
            this.ignores.add(Pattern.compile(containingStruct + " " + name));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"IgnoreField\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readManuallyImplement(StringTokenizer tok, String filename, int lineNo) {
        try {
            String name = tok.nextToken();
            this.manuallyImplement.add(name);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"ManuallyImplement\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readCustomJavaCode(StringTokenizer tok, String filename, int lineNo) {
        try {
            String className = tok.nextToken();
            try {
                String restOfLine = tok.nextToken("\n\r\f");
                this.addCustomJavaCode(className, restOfLine);
            }
            catch (NoSuchElementException e) {
                this.addCustomJavaCode(className, "");
            }
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"CustomJavaCode\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void addCustomJavaCode(String className, String code) {
        List codeList = this.customJavaCodeForClass(className);
        codeList.add(code);
    }

    protected void readCustomCCode(StringTokenizer tok, String filename, int lineNo) {
        try {
            String restOfLine = tok.nextToken("\n\r\f");
            this.customCCode.add(restOfLine);
        }
        catch (NoSuchElementException e) {
            this.customCCode.add("");
        }
    }

    protected void readClassJavadoc(StringTokenizer tok, String filename, int lineNo) {
        try {
            String className = tok.nextToken();
            String restOfLine = tok.nextToken("\n\r\f");
            this.addClassJavadoc(className, restOfLine);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"ClassJavadoc\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void addClassJavadoc(String className, String code) {
        List codeList = this.javadocForClass(className);
        codeList.add(code);
    }

    protected void readArgumentIsString(StringTokenizer tok, String filename, int lineNo) {
        try {
            String methodName = tok.nextToken();
            ArrayList<Integer> argIndices = new ArrayList<Integer>(2);
            while (tok.hasMoreTokens()) {
                Integer idx = Integer.valueOf(tok.nextToken());
                argIndices.add(idx);
            }
            if (argIndices.size() <= 0) {
                throw new RuntimeException("ERROR: Error parsing \"ArgumentIsString\" command at line " + lineNo + " in file \"" + filename + "\": directive requires specification of at least 1 index");
            }
            this.argumentsAreString.put(methodName, argIndices);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"ArgumentIsString\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readStructPackage(StringTokenizer tok, String filename, int lineNo) {
        try {
            String struct = tok.nextToken();
            String pkg = tok.nextToken();
            this.structPackages.put(struct, pkg);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"StructPackage\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readReturnValueCapacity(StringTokenizer tok, String filename, int lineNo) {
        try {
            String functionName = tok.nextToken();
            String restOfLine = tok.nextToken("\n\r\f");
            restOfLine = restOfLine.trim();
            this.returnValueCapacities.put(functionName, restOfLine);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"ReturnValueCapacity\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readReturnValueLength(StringTokenizer tok, String filename, int lineNo) {
        try {
            String functionName = tok.nextToken();
            String restOfLine = tok.nextToken("\n\r\f");
            restOfLine = restOfLine.trim();
            this.returnValueLengths.put(functionName, restOfLine);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"ReturnValueLength\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readTemporaryCVariableDeclaration(StringTokenizer tok, String filename, int lineNo) {
        try {
            String functionName = tok.nextToken();
            String restOfLine = tok.nextToken("\n\r\f");
            restOfLine = restOfLine.trim();
            ArrayList<String> list = (ArrayList<String>)this.temporaryCVariableDeclarations.get(functionName);
            if (list == null) {
                list = new ArrayList<String>();
                this.temporaryCVariableDeclarations.put(functionName, list);
            }
            list.add(restOfLine);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"TemporaryCVariableDeclaration\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readTemporaryCVariableAssignment(StringTokenizer tok, String filename, int lineNo) {
        try {
            String functionName = tok.nextToken();
            String restOfLine = tok.nextToken("\n\r\f");
            restOfLine = restOfLine.trim();
            ArrayList<String> list = (ArrayList<String>)this.temporaryCVariableAssignments.get(functionName);
            if (list == null) {
                list = new ArrayList<String>();
                this.temporaryCVariableAssignments.put(functionName, list);
            }
            list.add(restOfLine);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"TemporaryCVariableAssignment\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void doInclude(StringTokenizer tok, File file, String filename, int lineNo) throws IOException {
        try {
            String includedFilename = tok.nextToken();
            File includedFile = new File(includedFilename);
            if (!includedFile.isAbsolute()) {
                includedFile = new File(file.getParentFile(), includedFilename);
            }
            this.read(includedFile.getAbsolutePath());
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"Include\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void doIncludeAs(StringTokenizer tok, File file, String filename, int lineNo) throws IOException {
        try {
            StringBuffer linePrefix = new StringBuffer(128);
            while (tok.countTokens() > 1) {
                linePrefix.append(tok.nextToken());
                linePrefix.append(" ");
            }
            String includedFilename = tok.nextToken();
            File includedFile = new File(includedFilename);
            if (!includedFile.isAbsolute()) {
                includedFile = new File(file.getParentFile(), includedFilename);
            }
            this.read(includedFile.getAbsolutePath(), linePrefix.toString());
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"IncludeAs\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readExtend(StringTokenizer tok, String filename, int lineNo) {
        try {
            String interfaceName = tok.nextToken();
            List intfs = this.extendedInterfaces(interfaceName);
            intfs.add(tok.nextToken());
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"Extends\" command at line " + lineNo + " in file \"" + filename + "\": missing expected parameter", e);
        }
    }

    protected void readImplements(StringTokenizer tok, String filename, int lineNo) {
        try {
            String className = tok.nextToken();
            List intfs = this.implementedInterfaces(className);
            intfs.add(tok.nextToken());
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"Implements\" command at line " + lineNo + " in file \"" + filename + "\": missing expected parameter", e);
        }
    }

    protected void readParentClass(StringTokenizer tok, String filename, int lineNo) {
        try {
            String className = tok.nextToken();
            this.parentClass.put(className, tok.nextToken());
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"ParentClass\" command at line " + lineNo + " in file \"" + filename + "\": missing expected parameter", e);
        }
    }

    protected void readRenameJavaType(StringTokenizer tok, String filename, int lineNo) {
        try {
            String fromName = tok.nextToken();
            String toName = tok.nextToken();
            this.javaTypeRenames.put(fromName, toName);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"RenameJavaType\" command at line " + lineNo + " in file \"" + filename + "\": missing expected parameter", e);
        }
    }

    protected void readRenameJavaSymbol(StringTokenizer tok, String filename, int lineNo) {
        try {
            String fromName = tok.nextToken();
            String toName = tok.nextToken();
            this.javaSymbolRenames.put(fromName, toName);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"RenameJavaSymbol\" command at line " + lineNo + " in file \"" + filename + "\": missing expected parameter", e);
        }
    }

    protected void readJavaPrologueOrEpilogue(StringTokenizer tok, String filename, int lineNo, boolean prologue) {
        try {
            int spaceIdx;
            String methodName = tok.nextToken();
            String restOfLine = tok.nextToken("\n\r\f");
            restOfLine = restOfLine.trim();
            if (JavaConfiguration.startsWithDescriptor(restOfLine) && (spaceIdx = restOfLine.indexOf(32)) > 0) {
                String descriptor = restOfLine.substring(0, spaceIdx);
                restOfLine = restOfLine.substring(spaceIdx + 1, restOfLine.length());
                methodName = methodName + descriptor;
            }
            this.addJavaPrologueOrEpilogue(methodName, restOfLine, prologue);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"" + (prologue ? "JavaPrologue" : "JavaEpilogue") + "\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void addJavaPrologueOrEpilogue(String methodName, String code, boolean prologue) {
        Map codes = prologue ? this.javaPrologues : this.javaEpilogues;
        ArrayList<String> data = (ArrayList<String>)codes.get(methodName);
        if (data == null) {
            data = new ArrayList<String>();
            codes.put(methodName, data);
        }
        data.add(code);
    }

    protected void readRangeCheck(StringTokenizer tok, String filename, int lineNo, boolean inBytes) {
        try {
            String functionName = tok.nextToken();
            int argNum = Integer.parseInt(tok.nextToken());
            String restOfLine = tok.nextToken("\n\r\f");
            restOfLine = restOfLine.trim();
            this.addJavaPrologueOrEpilogue(functionName, "BufferFactory.rangeCheck" + (inBytes ? "Bytes" : "") + "({" + argNum + "}, " + restOfLine + ");", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing \"RangeCheck" + (inBytes ? "Bytes" : "") + "\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected static TypeInfo parseTypeInfo(String cType, JavaType javaType) {
        int idx;
        String typeName = null;
        int pointerDepth = 0;
        for (idx = 0; idx < cType.length() && cType.charAt(idx) != ' ' && cType.charAt(idx) != '*'; ++idx) {
        }
        typeName = cType.substring(0, idx);
        while (idx < cType.length()) {
            if (cType.charAt(idx) == '*') {
                ++pointerDepth;
            }
            ++idx;
        }
        return new TypeInfo(typeName, pointerDepth, javaType);
    }

    protected void addTypeInfo(TypeInfo info) {
        TypeInfo tmp = (TypeInfo)this.typeInfoMap.get(info.name());
        if (tmp == null) {
            this.typeInfoMap.put(info.name(), info);
            return;
        }
        while (tmp.next() != null) {
            tmp = tmp.next();
        }
        tmp.setNext(info);
    }

    private static int nextIndexAfterType(String s, int idx) {
        int len = s.length();
        while (idx < len) {
            char c = s.charAt(idx);
            if (Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(c) || c == '/') {
                ++idx;
                continue;
            }
            if (c == ';') {
                return idx + 1;
            }
            return -1;
        }
        return -1;
    }

    private static int nextIndexAfterDescriptor(String s, int idx) {
        char c = s.charAt(idx);
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 1 + idx;
            }
            case 'L': {
                return JavaConfiguration.nextIndexAfterType(s, idx + 1);
            }
            case ')': {
                return idx;
            }
        }
        return -1;
    }

    protected static boolean startsWithDescriptor(String s) {
        int nextIdx;
        int idx;
        int len = s.length();
        for (idx = 0; idx < len && s.charAt(idx) == ' '; ++idx) {
        }
        if (idx >= len) {
            return false;
        }
        if (s.charAt(idx++) != '(') {
            return false;
        }
        while (idx < len) {
            nextIdx = JavaConfiguration.nextIndexAfterDescriptor(s, idx);
            if (nextIdx < 0) {
                return false;
            }
            if (nextIdx == idx) break;
            idx = nextIdx;
        }
        return (nextIdx = JavaConfiguration.nextIndexAfterDescriptor(s, idx + 1)) >= 0;
    }
}

