/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen;

import com.sun.gluegen.ArrayTypes;
import com.sun.gluegen.CMethodBindingEmitter;
import com.sun.gluegen.CodeGenUtils;
import com.sun.gluegen.ConstantDefinition;
import com.sun.gluegen.FunctionEmitter;
import com.sun.gluegen.GlueEmitter;
import com.sun.gluegen.GlueEmitterControls;
import com.sun.gluegen.JavaConfiguration;
import com.sun.gluegen.JavaMethodBindingEmitter;
import com.sun.gluegen.JavaType;
import com.sun.gluegen.MethodBinding;
import com.sun.gluegen.StructLayout;
import com.sun.gluegen.SymbolFilter;
import com.sun.gluegen.TypeInfo;
import com.sun.gluegen.cgram.types.CompoundType;
import com.sun.gluegen.cgram.types.Field;
import com.sun.gluegen.cgram.types.FunctionSymbol;
import com.sun.gluegen.cgram.types.FunctionType;
import com.sun.gluegen.cgram.types.MachineDescription;
import com.sun.gluegen.cgram.types.PointerType;
import com.sun.gluegen.cgram.types.SizeThunk;
import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.cgram.types.TypeDictionary;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class JavaEmitter
implements GlueEmitter {
    private StructLayout layout;
    private TypeDictionary typedefDictionary;
    private TypeDictionary structDictionary;
    private Map canonMap;
    protected JavaConfiguration cfg;
    public static final int ALL_STATIC = 1;
    public static final int INTERFACE_AND_IMPL = 2;
    public static final int INTERFACE_ONLY = 3;
    public static final int IMPL_ONLY = 4;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PROTECTED = 2;
    public static final int ACC_PRIVATE = 3;
    public static final int ACC_PACKAGE_PRIVATE = 4;
    public static final int ACC_PUBLIC_ABSTRACT = 5;
    private PrintWriter javaWriter;
    private PrintWriter javaImplWriter;
    private PrintWriter cWriter;
    private MachineDescription machDesc32;
    private MachineDescription machDesc64;

    @Override
    public void readConfigurationFile(String filename) throws Exception {
        this.cfg = this.createConfig();
        this.cfg.read(filename);
    }

    @Override
    public void setMachineDescription(MachineDescription md32, MachineDescription md64) {
        if (md32 == null && md64 == null) {
            throw new RuntimeException("Must specify at least one MachineDescription");
        }
        this.machDesc32 = md32;
        this.machDesc64 = md64;
    }

    @Override
    public void beginEmission(GlueEmitterControls controls) throws IOException {
        try {
            this.openWriters();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to open files for writing", e);
        }
        this.emitAllFileHeaders();
        Iterator iter = this.cfg.forcedStructs().iterator();
        while (iter.hasNext()) {
            controls.forceStructEmission((String)iter.next());
        }
        controls.runSymbolFilter(new ConstantRenamer());
    }

    @Override
    public void endEmission() {
        this.emitAllFileFooters();
        try {
            this.closeWriters();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to close open files", e);
        }
    }

    @Override
    public void beginDefines() throws Exception {
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.javaWriter().println();
        }
    }

    protected static int getJavaRadix(String name, String value) {
        try {
            String parseValue;
            int radix;
            if (value.startsWith("0x") || value.startsWith("0X")) {
                radix = 16;
                parseValue = value.substring(2);
            } else if (value.startsWith("0") && value.length() > 1) {
                radix = 8;
                parseValue = value.substring(1);
            } else {
                radix = 10;
                parseValue = value;
            }
            long longVal = Long.parseLong(parseValue, radix);
            return radix;
        }
        catch (NumberFormatException e) {
            try {
                double dVal = Double.parseDouble(value);
                return 10;
            }
            catch (NumberFormatException e2) {
                throw new RuntimeException("Cannot emit define \"" + name + "\": value \"" + value + "\" cannot be assigned to a int, long, float, or double", e2);
            }
        }
    }

    protected static Object getJavaValue(String name, String value) {
        Scanner scanner = new Scanner(value).useDelimiter("[+-/*/></(/)]");
        Object resultType = null;
        while (scanner.hasNext()) {
            String t = scanner.next().trim();
            if (0 >= t.length()) continue;
            Object type = JavaEmitter.getJavaValue2(name, t);
            if (type instanceof Double) {
                return type;
            }
            if (resultType != null) {
                if (resultType instanceof Integer) {
                    if (type instanceof Long || type instanceof Float || type instanceof Double) {
                        resultType = type;
                    }
                } else if (resultType instanceof Long) {
                    if (type instanceof Float || type instanceof Double) {
                        resultType = type;
                    }
                } else if (resultType instanceof Float && type instanceof Float) {
                    resultType = type;
                }
            } else {
                resultType = type;
            }
            if (!(resultType instanceof Double)) continue;
            return type;
        }
        return resultType;
    }

    private static Object getJavaValue2(String name, String value) {
        try {
            String parseValue;
            int radix;
            if (value.startsWith("0x") || value.startsWith("0X")) {
                radix = 16;
                parseValue = value.substring(2);
            } else if (value.startsWith("0") && value.length() > 1) {
                radix = 8;
                parseValue = value.substring(1);
            } else {
                radix = 10;
                parseValue = value;
            }
            long longVal = Long.parseLong(parseValue, radix);
            if (longVal > Integer.MIN_VALUE && longVal < Integer.MAX_VALUE) {
                return new Integer((int)longVal);
            }
            return new Long(longVal);
        }
        catch (NumberFormatException e) {
            try {
                double dVal = Double.parseDouble(value);
                double absVal = Math.abs(dVal);
                if (absVal < (double)1.4E-45f || absVal > 3.4028234663852886E38) {
                    return new Double(dVal);
                }
                return new Float((float)dVal);
            }
            catch (NumberFormatException e2) {
                throw new RuntimeException("Cannot emit define \"" + name + "\": value \"" + value + "\" cannot be assigned to a int, long, float, or double", e2);
            }
        }
    }

    protected static String getJavaType(String name, String value) {
        Object oval = JavaEmitter.getJavaValue(name, value);
        return JavaEmitter.getJavaType(name, oval);
    }

    protected static String getJavaType(String name, Object oval) {
        if (oval instanceof Integer) {
            return "int";
        }
        if (oval instanceof Long) {
            return "long";
        }
        if (oval instanceof Float) {
            return "float";
        }
        if (oval instanceof Double) {
            return "double";
        }
        throw new RuntimeException("Cannot emit define (2) \"" + name + "\": value \"" + oval + "\" cannot be assigned to a int, long, float, or double");
    }

    @Override
    public void emitDefine(ConstantDefinition def, String optionalComment) throws Exception {
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            String name = def.getName();
            String value = def.getValue();
            if (!this.cfg.shouldIgnoreInInterface(name)) {
                String type = JavaEmitter.getJavaType(name, value);
                if (optionalComment != null && optionalComment.length() != 0) {
                    this.javaWriter().println("  /** " + optionalComment + " */");
                }
                String suffix = "";
                if (type.equals("float") && !value.endsWith("f")) {
                    suffix = "f";
                }
                this.javaWriter().println("  public static final " + type + " " + name + " = " + value + suffix + ";");
            }
        }
    }

    @Override
    public void endDefines() throws Exception {
    }

    @Override
    public void beginFunctions(TypeDictionary typedefDictionary, TypeDictionary structDictionary, Map canonMap) throws Exception {
        this.typedefDictionary = typedefDictionary;
        this.structDictionary = structDictionary;
        this.canonMap = canonMap;
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.javaWriter().println();
        }
    }

    @Override
    public Iterator emitFunctions(List originalCFunctions) throws Exception {
        HashSet<FunctionSymbol> funcsToBindSet = new HashSet<FunctionSymbol>(100);
        for (FunctionSymbol cFunc : originalCFunctions) {
            if (funcsToBindSet.contains(cFunc)) continue;
            funcsToBindSet.add(cFunc);
        }
        ArrayList<FunctionSymbol> funcsToBind = new ArrayList<FunctionSymbol>(funcsToBindSet.size());
        funcsToBind.addAll(funcsToBindSet);
        Collections.sort(funcsToBind, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((FunctionSymbol)o1).getName().compareTo(((FunctionSymbol)o2).getName());
            }

            @Override
            public boolean equals(Object obj) {
                return obj.getClass() == this.getClass();
            }
        });
        HashSet methodBindingSet = new HashSet();
        ArrayList methodBindingEmitters = new ArrayList(2 * funcsToBind.size());
        for (FunctionSymbol cFunc : funcsToBind) {
            if (this.cfg.shouldIgnoreInImpl(cFunc.getName())) continue;
            List allBindings = this.generateMethodBindingEmitters(methodBindingSet, cFunc);
            methodBindingEmitters.addAll(allBindings);
        }
        for (int i = 0; i < methodBindingEmitters.size(); ++i) {
            FunctionEmitter emitter = (FunctionEmitter)methodBindingEmitters.get(i);
            try {
                if (emitter.isInterface() && this.cfg.shouldIgnoreInInterface(emitter.getName())) continue;
                emitter.emit();
                emitter.getDefaultOutput().println();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while emitting binding for \"" + emitter.getName() + "\"", e);
            }
        }
        return funcsToBind.iterator();
    }

    protected JavaConfiguration createConfig() {
        return new JavaConfiguration();
    }

    protected JavaConfiguration getConfig() {
        return this.cfg;
    }

    protected void generatePublicEmitters(MethodBinding binding, List allEmitters, boolean signatureOnly) {
        PrintWriter writer;
        PrintWriter printWriter = writer = signatureOnly || this.cfg.allStatic() ? this.javaWriter() : this.javaImplWriter();
        if (this.cfg.manuallyImplement(binding.getName()) && !signatureOnly) {
            return;
        }
        int accessControl = this.cfg.accessControl(binding.getName());
        if (signatureOnly && accessControl != 1) {
            return;
        }
        boolean isUnimplemented = this.cfg.isUnimplemented(binding.getName());
        List prologue = this.cfg.javaPrologueForMethod(binding, false, false);
        List epilogue = this.cfg.javaEpilogueForMethod(binding, false, false);
        boolean needsBody = isUnimplemented || binding.needsNIOWrappingOrUnwrapping() || binding.signatureUsesJavaPrimitiveArrays() || prologue != null || epilogue != null;
        JavaMethodBindingEmitter emitter = new JavaMethodBindingEmitter(binding, writer, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), !signatureOnly && needsBody, this.cfg.tagNativeBinding(), false, this.cfg.nioDirectOnly(binding.getName()), false, false, false, isUnimplemented, signatureOnly, this.cfg);
        switch (accessControl) {
            case 1: {
                emitter.addModifier(JavaMethodBindingEmitter.PUBLIC);
                break;
            }
            case 2: {
                emitter.addModifier(JavaMethodBindingEmitter.PROTECTED);
                break;
            }
            case 3: {
                emitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                break;
            }
        }
        if (this.cfg.allStatic()) {
            emitter.addModifier(JavaMethodBindingEmitter.STATIC);
        }
        if (!(isUnimplemented || needsBody || signatureOnly)) {
            emitter.addModifier(JavaMethodBindingEmitter.NATIVE);
        }
        emitter.setReturnedArrayLengthExpression(this.cfg.returnedArrayLength(binding.getName()));
        emitter.setPrologue(prologue);
        emitter.setEpilogue(epilogue);
        allEmitters.add(emitter);
    }

    protected void generatePrivateEmitters(MethodBinding binding, List allEmitters) {
        boolean hasPrologueOrEpilogue;
        if (this.cfg.manuallyImplement(binding.getName())) {
            return;
        }
        boolean bl = hasPrologueOrEpilogue = this.cfg.javaPrologueForMethod(binding, false, false) != null || this.cfg.javaEpilogueForMethod(binding, false, false) != null;
        if (!this.cfg.isUnimplemented(binding.getName()) && (binding.needsNIOWrappingOrUnwrapping() || binding.signatureUsesJavaPrimitiveArrays() || hasPrologueOrEpilogue)) {
            PrintWriter writer;
            PrintWriter printWriter = writer = this.cfg.allStatic() ? this.javaWriter() : this.javaImplWriter();
            if (!binding.signatureUsesJavaPrimitiveArrays()) {
                JavaMethodBindingEmitter emitter = new JavaMethodBindingEmitter(binding, writer, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, this.cfg.nioDirectOnly(binding.getName()), true, true, false, false, false, this.cfg);
                emitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                if (this.cfg.allStatic()) {
                    emitter.addModifier(JavaMethodBindingEmitter.STATIC);
                }
                emitter.addModifier(JavaMethodBindingEmitter.NATIVE);
                emitter.setReturnedArrayLengthExpression(this.cfg.returnedArrayLength(binding.getName()));
                allEmitters.add(emitter);
                if (!this.cfg.nioDirectOnly(binding.getName()) && binding.signatureCanUseIndirectNIO()) {
                    emitter = new JavaMethodBindingEmitter(binding, writer, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, false, true, false, true, false, false, this.cfg);
                    emitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                    if (this.cfg.allStatic()) {
                        emitter.addModifier(JavaMethodBindingEmitter.STATIC);
                    }
                    emitter.addModifier(JavaMethodBindingEmitter.NATIVE);
                    emitter.setReturnedArrayLengthExpression(this.cfg.returnedArrayLength(binding.getName()));
                    allEmitters.add(emitter);
                }
            }
        }
        if (!this.cfg.isUnimplemented(binding.getName()) && !binding.signatureUsesJavaPrimitiveArrays()) {
            MessageFormat returnValueCapacityFormat = null;
            MessageFormat returnValueLengthFormat = null;
            JavaType javaReturnType = binding.getJavaReturnType();
            if (javaReturnType.isNIOBuffer() || javaReturnType.isCompoundTypeWrapper()) {
                String capacity = this.cfg.returnValueCapacity(binding.getName());
                if (capacity != null) {
                    returnValueCapacityFormat = new MessageFormat(capacity);
                }
            } else if (javaReturnType.isArray() || javaReturnType.isArrayOfCompoundTypeWrappers()) {
                if (javaReturnType.isPrimitiveArray()) {
                    throw new RuntimeException("Primitive array return types not yet supported");
                }
                String len = this.cfg.returnValueLength(binding.getName());
                if (len != null) {
                    returnValueLengthFormat = new MessageFormat(len);
                }
            }
            CMethodBindingEmitter cEmitter = new CMethodBindingEmitter(binding, this.cWriter(), this.cfg.implPackageName(), this.cfg.implClassName(), true, this.cfg.allStatic(), binding.needsNIOWrappingOrUnwrapping() || hasPrologueOrEpilogue, false, this.machDesc64);
            if (returnValueCapacityFormat != null) {
                cEmitter.setReturnValueCapacityExpression(returnValueCapacityFormat);
            }
            if (returnValueLengthFormat != null) {
                cEmitter.setReturnValueLengthExpression(returnValueLengthFormat);
            }
            cEmitter.setTemporaryCVariableDeclarations(this.cfg.temporaryCVariableDeclarations(binding.getName()));
            cEmitter.setTemporaryCVariableAssignments(this.cfg.temporaryCVariableAssignments(binding.getName()));
            allEmitters.add(cEmitter);
            if (binding.argumentsUseNIO() && binding.signatureCanUseIndirectNIO() && !this.cfg.nioDirectOnly(binding.getName())) {
                cEmitter = new CMethodBindingEmitter(binding, this.cWriter(), this.cfg.implPackageName(), this.cfg.implClassName(), true, this.cfg.allStatic(), binding.needsNIOWrappingOrUnwrapping(), true, this.machDesc64);
                if (returnValueCapacityFormat != null) {
                    cEmitter.setReturnValueCapacityExpression(returnValueCapacityFormat);
                }
                if (returnValueLengthFormat != null) {
                    cEmitter.setReturnValueLengthExpression(returnValueLengthFormat);
                }
                cEmitter.setTemporaryCVariableDeclarations(this.cfg.temporaryCVariableDeclarations(binding.getName()));
                cEmitter.setTemporaryCVariableAssignments(this.cfg.temporaryCVariableAssignments(binding.getName()));
                allEmitters.add(cEmitter);
            }
        }
    }

    protected List generateMethodBindingEmitters(HashSet methodBindingSet, FunctionSymbol sym) throws Exception {
        ArrayList allEmitters = new ArrayList();
        try {
            MethodBinding mb = this.bindFunction(sym, null, null, this.machDesc64);
            List bindings = this.expandMethodBinding(mb);
            for (MethodBinding binding : bindings) {
                if (!methodBindingSet.add(binding)) continue;
                if (this.cfg.allStatic() && binding.hasContainingType()) {
                    throw new IllegalArgumentException("Cannot create binding in AllStatic mode because method has containing type: \"" + binding + "\"");
                }
                if (this.cfg.emitInterface()) {
                    this.generatePublicEmitters(binding, allEmitters, true);
                }
                if (!this.cfg.emitImpl()) continue;
                this.generatePublicEmitters(binding, allEmitters, false);
                this.generatePrivateEmitters(binding, allEmitters);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while generating bindings for \"" + sym + "\"", e);
        }
        return allEmitters;
    }

    @Override
    public void endFunctions() throws Exception {
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.emitCustomJavaCode(this.javaWriter(), this.cfg.className());
        }
        if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
            this.emitCustomJavaCode(this.javaImplWriter(), this.cfg.implClassName());
        }
    }

    @Override
    public void beginStructLayout() throws Exception {
    }

    @Override
    public void layoutStruct(CompoundType t) throws Exception {
        this.getLayout().layout(t);
    }

    @Override
    public void endStructLayout() throws Exception {
    }

    @Override
    public void beginStructs(TypeDictionary typedefDictionary, TypeDictionary structDictionary, Map canonMap) throws Exception {
        this.typedefDictionary = typedefDictionary;
        this.structDictionary = structDictionary;
        this.canonMap = canonMap;
    }

    @Override
    public void emitStruct(CompoundType structType, String alternateName) throws Exception {
        this.emitStructImpl(structType, alternateName, this.machDesc32, this.machDesc64, true, false);
        this.emitStructImpl(structType, alternateName, this.machDesc32, this.machDesc64, false, true);
        this.emitStructImpl(structType, alternateName, this.machDesc32, this.machDesc64, false, false);
    }

    public void emitStructImpl(CompoundType structType, String alternateName, MachineDescription md32, MachineDescription md64, boolean doBaseClass, boolean do32Bit) throws Exception {
        String name = structType.getName();
        if (name == null && alternateName != null) {
            name = alternateName;
        }
        if (name == null) {
            System.err.println("WARNING: skipping emission of unnamed struct \"" + structType + "\"");
            return;
        }
        if (this.cfg.shouldIgnoreInInterface(name)) {
            return;
        }
        Type containingCType = this.canonicalize((Type)new PointerType(SizeThunk.POINTER, (Type)structType, 0));
        JavaType containingType = this.typeToJavaType(containingCType, false, null);
        if (!containingType.isCompoundTypeWrapper()) {
            return;
        }
        String containingTypeName = containingType.getName();
        if (md32 == null || md64 == null) {
            throw new RuntimeException("Must supply both 32- and 64-bit MachineDescriptions to emitStructImpl");
        }
        String suffix = "";
        MachineDescription extMachDesc = md64;
        MachineDescription intMachDesc = null;
        if (!doBaseClass) {
            if (do32Bit) {
                intMachDesc = md32;
                suffix = "32";
            } else {
                intMachDesc = md64;
                suffix = "64";
            }
        }
        boolean needsNativeCode = false;
        if (doBaseClass) {
            for (int i = 0; i < structType.getNumFields(); ++i) {
                if (!structType.getField(i).getType().isFunctionPointer()) continue;
                needsNativeCode = true;
                break;
            }
        }
        String structClassPkg = this.cfg.packageForStruct(name);
        PrintWriter writer = null;
        PrintWriter cWriter = null;
        try {
            writer = this.openFile(this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(structClassPkg) + File.separator + containingTypeName + suffix + ".java");
            CodeGenUtils.emitAutogeneratedWarning(writer, this);
            if (needsNativeCode) {
                String nRoot = this.cfg.nativeOutputDir();
                if (this.cfg.nativeOutputUsesJavaHierarchy()) {
                    nRoot = nRoot + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
                }
                cWriter = this.openFile(nRoot + File.separator + containingTypeName + "_JNI.c");
                CodeGenUtils.emitAutogeneratedWarning(cWriter, this);
                this.emitCHeader(cWriter, containingTypeName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to open files for emission of struct class", e);
        }
        writer.println();
        writer.println("package " + structClassPkg + ";");
        writer.println();
        writer.println("import java.nio.*;");
        writer.println();
        writer.println("import " + this.cfg.gluegenRuntimePackage() + ".*;");
        writer.println();
        List imports = this.cfg.imports();
        Iterator iter = imports.iterator();
        while (iter.hasNext()) {
            writer.print("import ");
            writer.print(iter.next());
            writer.println(";");
        }
        List javadoc = this.cfg.javadocForClass(containingTypeName);
        Iterator iter2 = javadoc.iterator();
        while (iter2.hasNext()) {
            writer.println((String)iter2.next());
        }
        writer.println();
        writer.print((doBaseClass ? "public " : "") + (doBaseClass ? "abstract " : "") + "class " + containingTypeName + suffix + " ");
        if (!doBaseClass) {
            writer.print("extends " + containingTypeName + " ");
        }
        boolean firstIteration = true;
        List userSpecifiedInterfaces = this.cfg.implementedInterfaces(containingTypeName);
        Iterator iter3 = userSpecifiedInterfaces.iterator();
        while (iter3.hasNext()) {
            if (firstIteration) {
                writer.print("implements ");
            }
            firstIteration = false;
            writer.print(iter3.next());
            writer.print(" ");
        }
        writer.println("{");
        if (doBaseClass) {
            writer.println("  StructAccessor accessor;");
            writer.println();
        }
        writer.println("  public static int size() {");
        if (doBaseClass) {
            writer.println("    if (CPU.is32Bit()) {");
            writer.println("      return " + containingTypeName + "32" + ".size();");
            writer.println("    } else {");
            writer.println("      return " + containingTypeName + "64" + ".size();");
            writer.println("    }");
        } else {
            writer.println("    return " + structType.getSize(intMachDesc) + ";");
        }
        writer.println("  }");
        writer.println();
        if (doBaseClass) {
            writer.println("  public static " + containingTypeName + " create() {");
            writer.println("    return create(BufferFactory.newDirectByteBuffer(size()));");
            writer.println("  }");
            writer.println();
            writer.println("  public static " + containingTypeName + " create(java.nio.ByteBuffer buf) {");
            writer.println("    if (CPU.is32Bit()) {");
            writer.println("      return new " + containingTypeName + "32(buf);");
            writer.println("    } else {");
            writer.println("      return new " + containingTypeName + "64(buf);");
            writer.println("    }");
            writer.println("  }");
            writer.println();
            writer.println("  " + containingTypeName + "(java.nio.ByteBuffer buf) {");
            writer.println("    accessor = new StructAccessor(buf);");
            writer.println("  }");
            writer.println();
            writer.println("  public java.nio.ByteBuffer getBuffer() {");
            writer.println("    return accessor.getBuffer();");
            writer.println("  }");
        } else {
            writer.println("  " + containingTypeName + suffix + "(java.nio.ByteBuffer buf) {");
            writer.println("    super(buf);");
            writer.println("  }");
            writer.println();
        }
        for (int i = 0; i < structType.getNumFields(); ++i) {
            Field field = structType.getField(i);
            Type fieldType = field.getType();
            if (this.cfg.shouldIgnoreInInterface(name + " " + field.getName())) continue;
            if (fieldType.isFunctionPointer()) {
                if (!doBaseClass) continue;
                try {
                    FunctionType funcType = fieldType.asPointer().getTargetType().asFunction();
                    FunctionSymbol funcSym = new FunctionSymbol(field.getName(), funcType);
                    MethodBinding binding = this.bindFunction(funcSym, containingType, containingCType, this.machDesc64);
                    binding.findThisPointer();
                    writer.println();
                    JavaMethodBindingEmitter emitter = new JavaMethodBindingEmitter(binding, writer, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), true, this.cfg.tagNativeBinding(), false, true, false, false, false, false, false, this.cfg);
                    emitter.addModifier(JavaMethodBindingEmitter.PUBLIC);
                    emitter.emit();
                    emitter = new JavaMethodBindingEmitter(binding, writer, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, true, true, true, false, false, false, this.cfg);
                    emitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                    emitter.addModifier(JavaMethodBindingEmitter.NATIVE);
                    emitter.emit();
                    CMethodBindingEmitter cEmitter = new CMethodBindingEmitter(binding, cWriter, structClassPkg, containingTypeName, true, false, true, false, this.machDesc64);
                    cEmitter.emit();
                    continue;
                }
                catch (Exception e) {
                    System.err.println("While processing field " + field + " of type " + name + ":");
                    throw e;
                }
            }
            if (fieldType.isCompound()) {
                if (fieldType.getName() == null) {
                    throw new RuntimeException("Anonymous structs as fields not supported yet (field \"" + field + "\" in type \"" + name + "\")");
                }
                writer.println();
                writer.print("  public " + (doBaseClass ? "abstract " : "") + fieldType.getName() + " " + field.getName() + "()");
                if (doBaseClass) {
                    writer.println(";");
                    continue;
                }
                writer.println(" {");
                writer.println("    return " + fieldType.getName() + ".create(accessor.slice(" + field.getOffset(intMachDesc) + ", " + fieldType.getSize(intMachDesc) + "));");
                writer.println("  }");
                continue;
            }
            if (fieldType.isArray()) {
                if (doBaseClass) continue;
                System.err.println("WARNING: Array fields (field \"" + field + "\" of type \"" + name + "\") not implemented yet");
                continue;
            }
            JavaType internalJavaType = null;
            JavaType externalJavaType = null;
            try {
                externalJavaType = this.typeToJavaType(fieldType, false, extMachDesc);
                if (!doBaseClass) {
                    internalJavaType = this.typeToJavaType(fieldType, false, intMachDesc);
                }
            }
            catch (Exception e) {
                System.err.println("Error occurred while creating accessor for field \"" + field.getName() + "\" in type \"" + name + "\"");
                e.printStackTrace();
                throw e;
            }
            if (externalJavaType.isPrimitive()) {
                String externalJavaTypeName = null;
                String internalJavaTypeName = null;
                externalJavaTypeName = externalJavaType.getName();
                if (!doBaseClass) {
                    internalJavaTypeName = internalJavaType.getName();
                }
                if (this.isOpaque(fieldType)) {
                    externalJavaTypeName = this.compatiblePrimitiveJavaTypeName(fieldType, externalJavaType, extMachDesc);
                    if (!doBaseClass) {
                        internalJavaTypeName = this.compatiblePrimitiveJavaTypeName(fieldType, internalJavaType, intMachDesc);
                    }
                }
                String capitalized = null;
                if (!doBaseClass) {
                    capitalized = "" + Character.toUpperCase(internalJavaTypeName.charAt(0)) + internalJavaTypeName.substring(1);
                }
                int slot = -1;
                if (!doBaseClass) {
                    slot = this.slot(fieldType, (int)field.getOffset(intMachDesc), intMachDesc);
                }
                writer.println();
                writer.print("  public " + (doBaseClass ? "abstract " : "") + containingTypeName + " " + field.getName() + "(" + externalJavaTypeName + " val)");
                if (doBaseClass) {
                    writer.println(";");
                } else {
                    writer.println(" {");
                    writer.print("    accessor.set" + capitalized + "At(" + slot + ", ");
                    if (!externalJavaTypeName.equals(internalJavaTypeName)) {
                        writer.print("(" + internalJavaTypeName + ") ");
                    }
                    writer.println("val);");
                    writer.println("    return this;");
                    writer.println("  }");
                }
                writer.println();
                writer.print("  public " + (doBaseClass ? "abstract " : "") + externalJavaTypeName + " " + field.getName() + "()");
                if (doBaseClass) {
                    writer.println(";");
                    continue;
                }
                writer.println(" {");
                writer.print("    return ");
                if (!externalJavaTypeName.equals(internalJavaTypeName)) {
                    writer.print("(" + externalJavaTypeName + ") ");
                }
                writer.println("accessor.get" + capitalized + "At(" + slot + ");");
                writer.println("  }");
                continue;
            }
            System.err.println("WARNING: Complicated fields (field \"" + field + "\" of type \"" + name + "\") not implemented yet");
        }
        if (doBaseClass) {
            this.emitCustomJavaCode(writer, containingTypeName);
        }
        writer.println("}");
        writer.flush();
        writer.close();
        if (needsNativeCode) {
            cWriter.flush();
            cWriter.close();
        }
    }

    @Override
    public void endStructs() throws Exception {
    }

    public static int addStrings2Buffer(StringBuffer buf, String sep, String first, Collection col) {
        int num = 0;
        if (null == buf) {
            buf = new StringBuffer();
        }
        Iterator iter = col.iterator();
        if (null != first) {
            buf.append(first);
            if (iter.hasNext()) {
                buf.append(sep);
            }
            ++num;
        }
        while (iter.hasNext()) {
            buf.append((String)iter.next());
            if (iter.hasNext()) {
                buf.append(sep);
            }
            ++num;
        }
        return num;
    }

    private JavaType typeToJavaType(Type cType, boolean outgoingArgument, MachineDescription curMachDesc) {
        PointerType opt = cType.asPointer();
        if (opt != null && opt.getTargetType().getName() != null && opt.getTargetType().getName().equals("JNIEnv")) {
            return JavaType.createForJNIEnv();
        }
        TypeInfo info = this.cfg.typeInfo(cType, this.typedefDictionary);
        if (info != null) {
            return info.javaType();
        }
        Type t = cType;
        if (t.isInt() || t.isEnum()) {
            switch ((int)t.getSize(curMachDesc)) {
                case 1: {
                    return this.javaType(Byte.TYPE);
                }
                case 2: {
                    return this.javaType(Short.TYPE);
                }
                case 4: {
                    return this.javaType(Integer.TYPE);
                }
                case 8: {
                    return this.javaType(Long.TYPE);
                }
            }
            throw new RuntimeException("Unknown integer type of size " + t.getSize(curMachDesc) + " and name " + t.getName());
        }
        if (t.isFloat()) {
            return this.javaType(Float.TYPE);
        }
        if (t.isDouble()) {
            return this.javaType(Double.TYPE);
        }
        if (t.isVoid()) {
            return this.javaType(Void.TYPE);
        }
        if (t.pointerDepth() > 0 || t.arrayDimension() > 0) {
            Type targetType = t.isPointer() ? t.asPointer().getTargetType() : t.asArray().getElementType();
            if (t.pointerDepth() == 1 || t.arrayDimension() == 1) {
                if (targetType.isVoid()) {
                    return JavaType.createForVoidPointer();
                }
                if (targetType.isInt()) {
                    switch ((int)targetType.getSize(curMachDesc)) {
                        case 1: {
                            return JavaType.createForCCharPointer();
                        }
                        case 2: {
                            return JavaType.createForCShortPointer();
                        }
                        case 4: {
                            return JavaType.createForCInt32Pointer();
                        }
                        case 8: {
                            return JavaType.createForCInt64Pointer();
                        }
                    }
                    throw new RuntimeException("Unknown integer array type of size " + t.getSize(curMachDesc) + " and name " + t.getName());
                }
                if (targetType.isFloat()) {
                    return JavaType.createForCFloatPointer();
                }
                if (targetType.isDouble()) {
                    return JavaType.createForCDoublePointer();
                }
                if (targetType.isCompound()) {
                    if (t.isArray()) {
                        throw new RuntimeException("Arrays of compound types not handled yet");
                    }
                    if (t.getName() != null && t.getName().equals("jobject")) {
                        return this.javaType(Object.class);
                    }
                    String name = targetType.getName();
                    if (name == null && (name = t.getName()) == null) {
                        throw new RuntimeException("Couldn't find a proper type name for pointer type " + t);
                    }
                    return JavaType.createForCStruct(this.cfg.renameJavaType(name));
                }
                throw new RuntimeException("Don't know how to convert pointer/array type \"" + t + "\"");
            }
            if (t.pointerDepth() == 2 || t.arrayDimension() == 2) {
                Type bottomType = targetType.isPointer() ? targetType.asPointer().getTargetType() : targetType.asArray().getElementType();
                if (bottomType.isPrimitive()) {
                    if (bottomType.isInt()) {
                        switch ((int)bottomType.getSize(curMachDesc)) {
                            case 1: {
                                return this.javaType(ArrayTypes.byteBufferArrayClass);
                            }
                            case 2: {
                                return this.javaType(ArrayTypes.shortBufferArrayClass);
                            }
                            case 4: {
                                return this.javaType(ArrayTypes.intBufferArrayClass);
                            }
                            case 8: {
                                return this.javaType(ArrayTypes.longBufferArrayClass);
                            }
                        }
                        throw new RuntimeException("Unknown two-dimensional integer array type of element size " + bottomType.getSize(curMachDesc) + " and name " + bottomType.getName());
                    }
                    if (bottomType.isFloat()) {
                        return this.javaType(ArrayTypes.floatBufferArrayClass);
                    }
                    if (bottomType.isDouble()) {
                        return this.javaType(ArrayTypes.doubleBufferArrayClass);
                    }
                    throw new RuntimeException("Unexpected primitive type " + bottomType.getName() + " in two-dimensional array");
                }
                if (bottomType.isVoid()) {
                    return this.javaType(ArrayTypes.bufferArrayClass);
                }
                if (targetType.isPointer() && targetType.pointerDepth() == 1 && targetType.asPointer().getTargetType().isCompound()) {
                    return JavaType.createForCArray(bottomType);
                }
                throw new RuntimeException("Could not convert C type \"" + t + "\" " + "to appropriate Java type; need to add more support for " + "depth=2 pointer/array types [debug info: targetType=\"" + targetType + "\"]");
            }
            throw new RuntimeException("Could not convert C pointer/array \"" + t + "\" to " + "appropriate Java type; types with pointer/array depth " + "greater than 2 are not yet supported [debug info: " + "pointerDepth=" + t.pointerDepth() + " arrayDimension=" + t.arrayDimension() + " targetType=\"" + targetType + "\"]");
        }
        throw new RuntimeException("Could not convert C type \"" + t + "\" (class " + t.getClass().getName() + ") to appropriate Java type");
    }

    private static boolean isIntegerType(Class c) {
        return c == Byte.TYPE || c == Short.TYPE || c == Character.TYPE || c == Integer.TYPE || c == Long.TYPE;
    }

    private int slot(Type t, int byteOffset, MachineDescription curMachDesc) {
        if (t.isInt()) {
            switch ((int)t.getSize(curMachDesc)) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return byteOffset / (int)t.getSize(curMachDesc);
                }
            }
            throw new RuntimeException("Illegal type");
        }
        if (t.isFloat()) {
            return byteOffset / 4;
        }
        if (t.isDouble()) {
            return byteOffset / 8;
        }
        if (t.isPointer()) {
            return byteOffset / curMachDesc.pointerSizeInBytes();
        }
        throw new RuntimeException("Illegal type " + t);
    }

    private StructLayout getLayout() {
        if (this.layout == null) {
            this.layout = StructLayout.createForCurrentPlatform();
        }
        return this.layout;
    }

    protected PrintWriter openFile(String filename) throws IOException {
        File file = new File(filename);
        String parentDir = file.getParent();
        if (parentDir != null) {
            File pDirFile = new File(parentDir);
            pDirFile.mkdirs();
        }
        return new PrintWriter(new BufferedWriter(new FileWriter(file)));
    }

    private boolean isOpaque(Type type) {
        return this.cfg.typeInfo(type, this.typedefDictionary) != null;
    }

    private String compatiblePrimitiveJavaTypeName(Type fieldType, JavaType javaType, MachineDescription curMachDesc) {
        Class c = javaType.getJavaClass();
        if (!JavaEmitter.isIntegerType(c)) {
            throw new RuntimeException("Can't yet handle opaque definitions of structs' fields to non-integer types (byte, short, int, long, etc.)");
        }
        switch ((int)fieldType.getSize(curMachDesc)) {
            case 1: {
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 8: {
                return "long";
            }
        }
        throw new RuntimeException("Can't handle opaque definitions if the starting type isn't compatible with integral types");
    }

    private void openWriters() throws IOException {
        String jRoot = null;
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            jRoot = this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
        }
        String jImplRoot = null;
        if (!this.cfg.allStatic()) {
            jImplRoot = this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(this.cfg.implPackageName());
        }
        String nRoot = this.cfg.nativeOutputDir();
        if (this.cfg.nativeOutputUsesJavaHierarchy()) {
            nRoot = nRoot + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
        }
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.javaWriter = this.openFile(jRoot + File.separator + this.cfg.className() + ".java");
        }
        if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
            this.javaImplWriter = this.openFile(jImplRoot + File.separator + this.cfg.implClassName() + ".java");
        }
        if (this.cfg.emitImpl()) {
            this.cWriter = this.openFile(nRoot + File.separator + this.cfg.implClassName() + "_JNI.c");
        }
        if (this.javaWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.javaWriter, this);
        }
        if (this.javaImplWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.javaImplWriter, this);
        }
        if (this.cWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.cWriter, this);
        }
    }

    protected PrintWriter javaWriter() {
        if (!this.cfg.allStatic() && !this.cfg.emitInterface()) {
            throw new InternalError("Should not call this");
        }
        return this.javaWriter;
    }

    protected PrintWriter javaImplWriter() {
        if (this.cfg.allStatic() || !this.cfg.emitImpl()) {
            throw new InternalError("Should not call this");
        }
        return this.javaImplWriter;
    }

    protected PrintWriter cWriter() {
        if (!this.cfg.emitImpl()) {
            throw new InternalError("Should not call this");
        }
        return this.cWriter;
    }

    private void closeWriter(PrintWriter writer) throws IOException {
        writer.flush();
        writer.close();
    }

    private void closeWriters() throws IOException {
        if (this.javaWriter != null) {
            this.closeWriter(this.javaWriter);
        }
        if (this.javaImplWriter != null) {
            this.closeWriter(this.javaImplWriter);
        }
        if (this.cWriter != null) {
            this.closeWriter(this.cWriter);
        }
        this.javaWriter = null;
        this.javaImplWriter = null;
        this.cWriter = null;
    }

    protected String getJavaOutputDir() {
        return this.cfg.javaOutputDir();
    }

    protected String getJavaPackageName() {
        return this.cfg.packageName();
    }

    protected String getImplPackageName() {
        return this.cfg.implPackageName();
    }

    protected void emitCustomJavaCode(PrintWriter writer, String className) throws Exception {
        List code = this.cfg.customJavaCodeForClass(className);
        if (code.size() == 0) {
            return;
        }
        writer.println();
        writer.println("  // --- Begin CustomJavaCode .cfg declarations");
        Iterator iter = code.iterator();
        while (iter.hasNext()) {
            writer.println((String)iter.next());
        }
        writer.println("  // ---- End CustomJavaCode .cfg declarations");
    }

    protected void emitAllFileHeaders() throws IOException {
        try {
            if (this.cfg.allStatic() || this.cfg.emitInterface()) {
                List userSpecifiedInterfaces = null;
                userSpecifiedInterfaces = this.cfg.emitInterface() ? this.cfg.extendedInterfaces(this.cfg.className()) : this.cfg.implementedInterfaces(this.cfg.className());
                String[] interfaces = new String[userSpecifiedInterfaces.size()];
                userSpecifiedInterfaces.toArray(interfaces);
                final List intfDocs = this.cfg.javadocForClass(this.cfg.className());
                CodeGenUtils.EmissionCallback docEmitter = new CodeGenUtils.EmissionCallback(){

                    @Override
                    public void emit(PrintWriter w) {
                        Iterator iter = intfDocs.iterator();
                        while (iter.hasNext()) {
                            w.println((String)iter.next());
                        }
                    }
                };
                String[] accessModifiers = null;
                accessModifiers = this.cfg.accessControl(this.cfg.className()) == 5 ? new String[]{"public", "abstract"} : new String[]{"public"};
                CodeGenUtils.emitJavaHeaders(this.javaWriter, this.cfg.packageName(), this.cfg.className(), this.cfg.gluegenRuntimePackage(), this.cfg.allStatic(), this.cfg.imports().toArray(new String[0]), accessModifiers, interfaces, this.cfg.extendedParentClass(this.cfg.className()), docEmitter);
            }
            if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
                final List implDocs = this.cfg.javadocForClass(this.cfg.implClassName());
                CodeGenUtils.EmissionCallback docEmitter = new CodeGenUtils.EmissionCallback(){

                    @Override
                    public void emit(PrintWriter w) {
                        Iterator iter = implDocs.iterator();
                        while (iter.hasNext()) {
                            w.println((String)iter.next());
                        }
                    }
                };
                List userSpecifiedInterfaces = null;
                userSpecifiedInterfaces = this.cfg.implementedInterfaces(this.cfg.implClassName());
                int additionalNum = 0;
                if (this.cfg.className() != null) {
                    additionalNum = 1;
                }
                String[] interfaces = new String[additionalNum + userSpecifiedInterfaces.size()];
                userSpecifiedInterfaces.toArray(interfaces);
                if (additionalNum == 1) {
                    interfaces[userSpecifiedInterfaces.size()] = this.cfg.className();
                }
                String[] accessModifiers = null;
                accessModifiers = this.cfg.accessControl(this.cfg.implClassName()) == 5 ? new String[]{"public", "abstract"} : new String[]{"public"};
                CodeGenUtils.emitJavaHeaders(this.javaImplWriter, this.cfg.implPackageName(), this.cfg.implClassName(), this.cfg.gluegenRuntimePackage(), true, this.cfg.imports().toArray(new String[0]), accessModifiers, interfaces, this.cfg.extendedParentClass(this.cfg.implClassName()), docEmitter);
            }
            if (this.cfg.emitImpl()) {
                PrintWriter cWriter = this.cWriter();
                this.emitCHeader(cWriter, this.cfg.implClassName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error emitting all file headers: cfg.allStatic()=" + this.cfg.allStatic() + " cfg.emitImpl()=" + this.cfg.emitImpl() + " cfg.emitInterface()=" + this.cfg.emitInterface(), e);
        }
    }

    protected void emitCHeader(PrintWriter cWriter, String className) {
        cWriter.println("#include <jni.h>");
        cWriter.println("#include <stdlib.h>");
        cWriter.println();
        if (this.getConfig().emitImpl()) {
            cWriter.println("#include <assert.h>");
            cWriter.println();
        }
        Iterator iter = this.cfg.customCCode().iterator();
        while (iter.hasNext()) {
            cWriter.println((String)iter.next());
        }
        cWriter.println();
    }

    protected void emitAllFileFooters() {
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.javaWriter().println();
            this.javaWriter().println("} // end of class " + this.cfg.className());
        }
        if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
            this.javaImplWriter().println();
            this.javaImplWriter().println("} // end of class " + this.cfg.implClassName());
        }
    }

    private JavaType javaType(Class c) {
        return JavaType.createForClass(c);
    }

    private MethodBinding bindFunction(FunctionSymbol sym, JavaType containingType, Type containingCType, MachineDescription curMachDesc) {
        MethodBinding binding = new MethodBinding(sym, containingType, containingCType);
        binding.renameMethodName(this.cfg.getJavaSymbolRename(sym.getName()));
        if (this.cfg.returnsString(binding.getName())) {
            PointerType prt = sym.getReturnType().asPointer();
            if (prt == null || prt.getTargetType().asInt() == null || prt.getTargetType().getSize(curMachDesc) != 1L) {
                throw new RuntimeException("Cannot apply ReturnsString configuration directive to \"" + sym + "\". ReturnsString requires native method to have return type \"char *\"");
            }
            binding.setJavaReturnType(this.javaType(String.class));
        } else {
            binding.setJavaReturnType(this.typeToJavaType(sym.getReturnType(), false, curMachDesc));
        }
        List stringArgIndices = this.cfg.stringArguments(binding.getName());
        for (int i = 0; i < sym.getNumArguments(); ++i) {
            Type cArgType = sym.getArgumentType(i);
            JavaType mappedType = this.typeToJavaType(cArgType, true, curMachDesc);
            if (stringArgIndices != null && stringArgIndices.contains(new Integer(i))) {
                if (mappedType.isCVoidPointerType() || mappedType.isCCharPointerType() || mappedType.isCShortPointerType() || mappedType.isArray() && mappedType.getJavaClass() == ArrayTypes.byteBufferArrayClass || mappedType.getJavaClass() == ArrayTypes.shortBufferArrayClass) {
                    mappedType = mappedType.isArray() ? this.javaType(ArrayTypes.stringArrayClass) : this.javaType(String.class);
                } else {
                    throw new RuntimeException("Cannot apply ArgumentIsString configuration directive to argument " + i + " of \"" + sym + "\": argument type is not " + "a \"void*\", \"char *\", \"short *\", \"char**\", or \"short**\" equivalent");
                }
            }
            binding.addJavaArgumentType(mappedType);
        }
        return binding;
    }

    private MethodBinding lowerMethodBindingPointerTypes(MethodBinding inputBinding, boolean convertToArrays, boolean[] canProduceArrayVariant) {
        MethodBinding result = inputBinding;
        boolean arrayPossible = false;
        for (int i = 0; i < inputBinding.getNumArguments(); ++i) {
            JavaType t = inputBinding.getJavaArgumentType(i);
            if (!t.isCPrimitivePointerType()) continue;
            if (t.isCVoidPointerType()) {
                result = result.replaceJavaArgumentType(i, JavaType.forNIOBufferClass());
                continue;
            }
            if (t.isCCharPointerType()) {
                arrayPossible = true;
                if (convertToArrays) {
                    result = result.replaceJavaArgumentType(i, this.javaType(ArrayTypes.byteArrayClass));
                    continue;
                }
                result = result.replaceJavaArgumentType(i, JavaType.forNIOByteBufferClass());
                continue;
            }
            if (t.isCShortPointerType()) {
                arrayPossible = true;
                if (convertToArrays) {
                    result = result.replaceJavaArgumentType(i, this.javaType(ArrayTypes.shortArrayClass));
                    continue;
                }
                result = result.replaceJavaArgumentType(i, JavaType.forNIOShortBufferClass());
                continue;
            }
            if (t.isCInt32PointerType()) {
                arrayPossible = true;
                if (convertToArrays) {
                    result = result.replaceJavaArgumentType(i, this.javaType(ArrayTypes.intArrayClass));
                    continue;
                }
                result = result.replaceJavaArgumentType(i, JavaType.forNIOIntBufferClass());
                continue;
            }
            if (t.isCInt64PointerType()) {
                arrayPossible = true;
                if (convertToArrays) {
                    result = result.replaceJavaArgumentType(i, this.javaType(ArrayTypes.longArrayClass));
                    continue;
                }
                result = result.replaceJavaArgumentType(i, JavaType.forNIOPointerBufferClass());
                continue;
            }
            if (t.isCFloatPointerType()) {
                arrayPossible = true;
                if (convertToArrays) {
                    result = result.replaceJavaArgumentType(i, this.javaType(ArrayTypes.floatArrayClass));
                    continue;
                }
                result = result.replaceJavaArgumentType(i, JavaType.forNIOFloatBufferClass());
                continue;
            }
            if (t.isCDoublePointerType()) {
                arrayPossible = true;
                if (convertToArrays) {
                    result = result.replaceJavaArgumentType(i, this.javaType(ArrayTypes.doubleArrayClass));
                    continue;
                }
                result = result.replaceJavaArgumentType(i, JavaType.forNIODoubleBufferClass());
                continue;
            }
            throw new RuntimeException("Unknown C pointer type " + t);
        }
        JavaType t = result.getJavaReturnType();
        if (t.isCPrimitivePointerType()) {
            if (t.isCVoidPointerType()) {
                result = result.replaceJavaArgumentType(-1, JavaType.forNIOByteBufferClass());
            } else if (t.isCCharPointerType()) {
                result = result.replaceJavaArgumentType(-1, JavaType.forNIOByteBufferClass());
            } else if (t.isCShortPointerType()) {
                result = result.replaceJavaArgumentType(-1, JavaType.forNIOShortBufferClass());
            } else if (t.isCInt32PointerType()) {
                result = result.replaceJavaArgumentType(-1, JavaType.forNIOIntBufferClass());
            } else if (t.isCInt64PointerType()) {
                result = result.replaceJavaArgumentType(-1, JavaType.forNIOPointerBufferClass());
            } else if (t.isCFloatPointerType()) {
                result = result.replaceJavaArgumentType(-1, JavaType.forNIOFloatBufferClass());
            } else if (t.isCDoublePointerType()) {
                result = result.replaceJavaArgumentType(-1, JavaType.forNIODoubleBufferClass());
            } else {
                throw new RuntimeException("Unknown C pointer type " + t);
            }
        }
        if (canProduceArrayVariant != null) {
            canProduceArrayVariant[0] = arrayPossible;
        }
        return result;
    }

    protected List expandMethodBinding(MethodBinding binding) {
        ArrayList<MethodBinding> result = new ArrayList<MethodBinding>();
        boolean[] canProduceArrayVariant = new boolean[1];
        if (binding.signatureUsesCPrimitivePointers() || binding.signatureUsesCVoidPointers() || binding.signatureUsesCArrays()) {
            result.add(this.lowerMethodBindingPointerTypes(binding, false, canProduceArrayVariant));
            if (canProduceArrayVariant[0] && (binding.signatureUsesCPrimitivePointers() || binding.signatureUsesCArrays()) && !this.cfg.nioDirectOnly(binding.getName()) && !this.cfg.nioOnly(binding.getName())) {
                result.add(this.lowerMethodBindingPointerTypes(binding, true, null));
            }
        } else {
            result.add(binding);
        }
        return result;
    }

    private String resultName() {
        return "_res";
    }

    private Type canonicalize(Type t) {
        Type res = (Type)this.canonMap.get(t);
        if (res != null) {
            return res;
        }
        this.canonMap.put(t, t);
        return t;
    }

    class ConstantRenamer
    implements SymbolFilter {
        private List constants;

        ConstantRenamer() {
        }

        @Override
        public void filterSymbols(List constants, List functions) {
            this.constants = constants;
            this.doWork();
        }

        @Override
        public List getConstants() {
            return this.constants;
        }

        @Override
        public List getFunctions() {
            return null;
        }

        private void doWork() {
            ArrayList<ConstantDefinition> newConstants = new ArrayList<ConstantDefinition>();
            JavaConfiguration cfg = JavaEmitter.this.getConfig();
            for (ConstantDefinition def : this.constants) {
                String rename = cfg.getJavaSymbolRename(def.getName());
                def.rename(cfg.getJavaSymbolRename(def.getName()));
                newConstants.add(def);
            }
            this.constants = newConstants;
        }
    }
}

